/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file;

import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionListener;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.gui.file.FilePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.utils.IDisposable;

public class FileListPanel
extends JPanel
implements SessionListener,
IDisposable {
    private static final int FILE_SEPARATOR_WIDTH = 6;
    private Session session;
    private JScrollPane scroller;
    private JPanel contentPanel;
    private List<FileDetails> fileDetails = new ArrayList<FileDetails>();
    private Map<AudioFile, FileDetails> file2detail = new HashMap<AudioFile, FileDetails>();
    private int width = -1;

    public FileListPanel(Session session) {
        this.session = session;
        session.addSessionListener(this);
        super.setLayout(new BorderLayout());
        JPanel scrollView = new JPanel();
        this.scroller = new JScrollPane(scrollView);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.getVerticalScrollBar().setUnitIncrement(12);
        super.add((Component)this.scroller, "Center");
        scrollView.setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        scrollView.add((Component)this.contentPanel, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.contentPanel.setLayout(new TableLayout(1, gbc));
        for (AudioFile file : session.getFiles()) {
            this.fileAdded0(file);
        }
    }

    public void fileAdded(Session session, final AudioFile audioFile) {
        assert (session == this.session);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileListPanel.this.fileAdded0(audioFile);
            }
        });
    }

    public void fileRemoved(Session session, final AudioFile audioFile) {
        assert (session == this.session);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileListPanel.this.fileRemoved0(audioFile);
            }
        });
    }

    public void currentFileChanged(Session session, AudioFile audioFile) {
    }

    public void focusedFileChanged(Session session, AudioFile audioFile) {
    }

    private void fileAdded0(AudioFile audioFile) {
        assert (SwingUtilities.isEventDispatchThread());
        final FilePanel panel = new FilePanel(this.session, audioFile, this);
        this.contentPanel.add(panel);
        final JSeparator separator = new JSeparator(0);
        separator.setPreferredSize(new Dimension(6, 6));
        separator.setCursor(Cursor.getPredefinedCursor(9));
        separator.setToolTipText("<html><body>Click and drag to resize.<br>Double-click to fit window</body></html>");
        separator.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                panel.fileSeparatorPressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                panel.fileSeparatorDragged(e);
            }

            public void mouseClicked(MouseEvent e) {
                panel.fileSeparatorClicked(e, FileListPanel.this.scroller, separator);
            }
        });
        separator.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                panel.fileSeparatorDragged(e);
            }
        });
        this.contentPanel.add(separator);
        FileDetails details = new FileDetails();
        details.panel = panel;
        details.separator = separator;
        this.fileDetails.add(details);
        this.file2detail.put(audioFile, details);
        this.scroller.validate();
    }

    void fitHeight(AudioFile file) {
        FileDetails details = this.file2detail.get(file);
        details.panel.fitHeight(this.scroller, details.separator);
    }

    private void fileRemoved0(AudioFile audioFile) {
        assert (SwingUtilities.isEventDispatchThread());
        FileDetails details = this.file2detail.get(audioFile);
        details.panel.dispose();
        this.contentPanel.remove(details.panel);
        AwtTools.cleanupListeners(details.separator);
        this.contentPanel.remove(details.separator);
        this.fileDetails.remove(details);
        this.file2detail.remove(audioFile);
        this.scroller.validate();
        super.repaint();
    }

    public void setWidth(int width) {
        this.width = width;
        this.revalidate();
    }

    public void resetWidth() {
        this.width = -1;
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.width > 0) {
            result = new Dimension(this.width, result.height);
        }
        return result;
    }

    public void dispose() {
        for (FileDetails details : this.fileDetails) {
            details.panel.dispose();
        }
        this.file2detail = null;
        this.fileDetails = null;
        this.session = null;
    }

    static class FileDetails {
        public FilePanel panel;
        public JSeparator separator;

        FileDetails() {
        }
    }
}

