/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file;

import ch.tachyon.sonics.data.ILockListener;
import ch.tachyon.sonics.data.ILockable;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionListener;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioChannelListener;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.audio.AudioFileListener;
import ch.tachyon.sonics.data.view.AudioChannelDataView;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.AudioFileViewListener;
import ch.tachyon.sonics.data.view.ChannelViewType;
import ch.tachyon.sonics.data.view.IAudioChannelPanel;
import ch.tachyon.sonics.gui.file.CornerScrollPanel;
import ch.tachyon.sonics.gui.file.FileControlPanel;
import ch.tachyon.sonics.gui.file.FileListPanel;
import ch.tachyon.sonics.gui.file.TimeFormater;
import ch.tachyon.sonics.gui.file.TimeLinePanel;
import ch.tachyon.sonics.gui.file.VerticalAxisPanel;
import ch.tachyon.sonics.gui.file.action.SetCurrentFileAction;
import ch.tachyon.sonics.gui.file.view.AudioChannelDataPanel;
import ch.tachyon.sonics.gui.file.view.ChannelControlPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BoundedRangeModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.utils.IDisposable;
import org.corebounce.common.utils.Platform;

public class FilePanel
extends JPanel
implements AudioFileListener,
AudioChannelListener,
AudioFileViewListener,
ILockListener,
ChangeListener,
IDisposable {
    static final String LOCK_NAME = "Refresh Panel";
    private static final int CHANNEL_SEPARATOR_WIDTH = 4;
    private static final int SCROLLER_ONE = 0x40000000;
    static final int MIN_VIEW_HEIGHT = 10;
    private static final int MAX_VIEW_HEIGHT = 8000;
    private static Map<AudioFile, FilePanel> filePanels = Collections.synchronizedMap(new WeakHashMap());
    private AudioFile file;
    private FileListPanel parent;
    private List<ChannelDetails> channelDetails = new ArrayList<ChannelDetails>();
    private Map<AudioChannel, ChannelDetails> chan2details = new HashMap<AudioChannel, ChannelDetails>();
    private GridBagConstraints gbcS;
    private GridBagConstraints gbcF;
    private GridBagConstraints gbc2r;
    private GridBagConstraints gbcF2c;
    private GridBagConstraints gbc3c;
    private JCheckBox chkHide;
    private JCheckBox chkShow;
    private JLabel fileNameLabel;
    private JPanel fileNamePanel;
    private JRadioButton fileNameRadio;
    private boolean controlPanelsVisible = true;
    private JScrollBar scrollBar;
    private JPanel cornerPanel1;
    private JPanel cornerPanel2;
    private JPanel cornerPanel3;
    private TimeLinePanel timeLinePanel;
    private FileControlPanel controlPanel;
    private int prevScrollBarValue;
    private ChannelViewType viewType = ChannelViewType.WAVEFORM;
    private JPanel contentPanel;
    private JPanel disablerPanel;
    private AtomicInteger disablerAlpha = new AtomicInteger();
    private Session session;
    private SessionListener sessionListener;
    private SetCurrentFileAction setCurrentFileAction;
    private boolean dragging = false;
    private int startDragY;
    private int startDragHeight;
    private int startDragHeight2;
    private int curDragHeight;
    private int curDragHeight2;
    private boolean scrollBarUpdating = false;

    public FilePanel(final Session session, final AudioFile file, FileListPanel parent) {
        this.file = file;
        this.session = session;
        this.parent = parent;
        filePanels.put(file, this);
        this.setLayout(new OverlayLayout(this));
        this.disablerPanel = new JPanel(){

            public void paint(Graphics g) {
                if (this.isShowing()) {
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
        };
        this.disablerPanel.setOpaque(false);
        this.disablerPanel.setBackground(new Color(255, 255, 255, 0));
        this.disablerPanel.setCursor(Cursor.getPredefinedCursor(3));
        this.disablerPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (FilePanel.this.disablerAlpha.get() > 0) {
                    return;
                }
                if (Platform.isMacOsX()) {
                    return;
                }
                Timer timer = new Timer(20, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (!FilePanel.this.disablerPanel.isVisible() || FilePanel.this.disablerAlpha.get() > 128) {
                            Timer timer = (Timer)e.getSource();
                            timer.stop();
                            return;
                        }
                        FilePanel.this.disablerPanel.setBackground(new Color(255, 255, 255, FilePanel.this.disablerAlpha.addAndGet(32)));
                        FilePanel.this.repaint();
                        if (FilePanel.this.disablerAlpha.get() >= 128) {
                            Timer timer = (Timer)e.getSource();
                            timer.stop();
                            return;
                        }
                    }
                });
                timer.setInitialDelay(0);
                timer.start();
            }
        });
        this.disablerPanel.addMouseMotionListener(new MouseMotionAdapter(){});
        this.disablerPanel.setVisible(false);
        this.add(this.disablerPanel);
        this.contentPanel = new JPanel();
        this.add(this.contentPanel);
        this.contentPanel.setBorder(new BevelBorder(1));
        this.gbcS = new GridBagConstraints();
        this.gbcS.fill = 1;
        this.gbcF = (GridBagConstraints)this.gbcS.clone();
        this.gbcF.weightx = 1.0;
        this.gbcF2c = (GridBagConstraints)this.gbcF.clone();
        this.gbcF2c.gridwidth = 2;
        this.gbc3c = (GridBagConstraints)this.gbcS.clone();
        this.gbc3c.gridwidth = 3;
        this.gbc2r = (GridBagConstraints)this.gbcS.clone();
        this.gbc2r.gridheight = 2;
        this.contentPanel.setLayout(new TableLayout(3, this.gbcS));
        this.chkHide = new JCheckBox();
        this.chkHide.setText("Controls");
        this.chkHide.setToolTipText("Hide the playback controls for this file");
        this.chkHide.setMnemonic(67);
        this.contentPanel.add((Component)this.chkHide, this.gbcS);
        this.fileNamePanel = new JPanel();
        this.fileNamePanel.setLayout(new BorderLayout());
        this.chkShow = new JCheckBox();
        this.chkShow.setText("Controls");
        this.chkShow.setToolTipText("Show the playback controls for this file");
        this.chkShow.setMnemonic(67);
        this.fileNamePanel.add((Component)this.chkShow, "West");
        JPanel panel = new JPanel();
        panel.setLayout(new TableLayout(2));
        this.setCurrentFileAction = new SetCurrentFileAction(session, file);
        this.fileNamePanel.add((Component)panel, "Center");
        this.fileNameLabel = new JLabel(FilePanel.getDisplayedFileName(file));
        this.fileNameLabel.setToolTipText(FilePanel.getDisplayedTooltip(file));
        this.fileNameLabel.setFont(this.fileNameLabel.getFont().deriveFont(1));
        this.fileNameLabel.setHorizontalAlignment(0);
        panel.add(this.fileNameLabel);
        this.fileNameRadio = new JRadioButton(this.setCurrentFileAction);
        this.fileNameRadio.setFont(this.fileNameRadio.getFont().deriveFont(1));
        this.fileNameRadio.setHorizontalAlignment(0);
        this.fileNameRadio.setVisible(false);
        panel.add(this.fileNameRadio);
        this.setCurrentFileAction.init(this.fileNameLabel, this.fileNameRadio);
        this.fileNamePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                session.setCurrentFile(file);
            }
        });
        this.contentPanel.add((Component)this.fileNamePanel, this.gbcF2c);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilePanel.this.toggleControlPanelVisible();
                session.setCurrentFile(file);
            }
        };
        this.chkHide.addActionListener(listener);
        this.chkShow.addActionListener(listener);
        this.cornerPanel1 = new JPanel();
        this.contentPanel.add((Component)this.cornerPanel1, this.gbcS);
        this.timeLinePanel = new TimeLinePanel(session, file);
        this.contentPanel.add((Component)this.timeLinePanel, this.gbcF);
        this.contentPanel.add((Component)new CornerScrollPanel(file, this), this.gbcS);
        for (AudioChannel channel : file.getData().getChannels()) {
            this.channelAdded0(file, channel);
        }
        this.cornerPanel2 = new JPanel();
        this.scrollBar = new JScrollBar(0, 0, 0x40000000, 0, 0x40000000);
        if (!Platform.isMacOsX()) {
            this.scrollBar.setEnabled(false);
        }
        this.cornerPanel3 = new JPanel();
        this.controlPanel = new FileControlPanel(session, file, this);
        this.addBottomPanel();
        this.toggleControlPanelVisible();
        file.addAudioFileListener(this);
        file.addLockListener(this);
        file.getView().addViewListener(this);
        this.scrollBar.getModel().addChangeListener(this);
        this.prevScrollBarValue = this.scrollBar.getModel().getValue();
    }

    private void addBottomPanel() {
        if (this.cornerPanel2 == null) {
            return;
        }
        this.contentPanel.add((Component)this.cornerPanel2, this.gbc2r);
        this.contentPanel.add((Component)this.scrollBar, this.gbcS);
        this.contentPanel.add((Component)this.cornerPanel3, this.gbcS);
        this.contentPanel.add((Component)this.controlPanel, this.gbcF2c);
    }

    private void removeBottomPanel() {
        if (this.cornerPanel2 == null) {
            return;
        }
        this.contentPanel.remove(this.cornerPanel2);
        this.contentPanel.remove(this.scrollBar);
        this.contentPanel.remove(this.cornerPanel3);
        this.contentPanel.remove(this.controlPanel);
    }

    private void channelAdded0(AudioFile file, AudioChannel channel) {
        assert (SwingUtilities.isEventDispatchThread());
        this.removeBottomPanel();
        ChannelControlPanel controlPanel = new ChannelControlPanel(channel);
        this.contentPanel.add((Component)controlPanel, this.gbcS);
        AudioChannelDataView view = new AudioChannelDataView(channel);
        final AudioChannelDataPanel wavePanel = new AudioChannelDataPanel(this.session, view, this.viewType);
        view.setPanel(wavePanel);
        this.contentPanel.add((Component)wavePanel, this.gbcF);
        VerticalAxisPanel verticalAxisPanel = new VerticalAxisPanel(this.session, channel);
        this.contentPanel.add((Component)verticalAxisPanel, this.gbcS);
        JSeparator separator = new JSeparator(0);
        separator.setCursor(Cursor.getPredefinedCursor(8));
        separator.setPreferredSize(new Dimension(4, 4));
        separator.setToolTipText("<html><body>Click and drag to resize.<br>Double-click to distribute height equally.</body></html>");
        separator.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                FilePanel.this.viewSeparatorPressed(e, wavePanel);
            }

            public void mouseReleased(MouseEvent e) {
                FilePanel.this.viewSeparatorDragged(e, wavePanel);
            }

            public void mouseClicked(MouseEvent e) {
                FilePanel.this.viewSeparatorClicked(e, wavePanel);
            }
        });
        separator.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                FilePanel.this.viewSeparatorDragged(e, wavePanel);
            }
        });
        this.contentPanel.add((Component)separator, this.gbc3c);
        ChannelDetails details = new ChannelDetails();
        details.controlPanel = controlPanel;
        details.graphPanel = wavePanel;
        details.verticalAxisPanel = verticalAxisPanel;
        details.separator = separator;
        this.channelDetails.add(details);
        this.chan2details.put(channel, details);
        this.refreshSeparators();
        this.addBottomPanel();
        super.validate();
        channel.addAudioChannelListener(this);
    }

    private void channelRemoved0(AudioFile file, AudioChannel channel) {
        channel.removeAudioChannelListener(this);
        assert (SwingUtilities.isEventDispatchThread());
        ChannelDetails details = this.chan2details.get(channel);
        this.contentPanel.remove(details.controlPanel);
        this.contentPanel.remove((Component)((Object)details.graphPanel));
        this.contentPanel.remove(details.verticalAxisPanel);
        AwtTools.cleanupListeners(details.separator);
        this.contentPanel.remove(details.separator);
        ((IDisposable)((Object)details.graphPanel)).dispose();
        this.chan2details.remove(channel);
        this.channelDetails.remove(details);
        this.refreshSeparators();
        super.validate();
    }

    private void channelExchanged0(AudioFile file, AudioChannel channel1, AudioChannel channel2) {
        assert (SwingUtilities.isEventDispatchThread());
        this.removeBottomPanel();
        for (ChannelDetails details : this.channelDetails) {
            this.contentPanel.remove(details.controlPanel);
            this.contentPanel.remove((Component)((Object)details.graphPanel));
            this.contentPanel.remove(details.verticalAxisPanel);
            this.contentPanel.remove(details.separator);
        }
        ChannelDetails details1 = this.chan2details.get(channel1);
        ChannelDetails details2 = this.chan2details.get(channel2);
        int index1 = this.channelDetails.indexOf(details1);
        int index2 = this.channelDetails.indexOf(details2);
        this.channelDetails.set(index1, details2);
        this.channelDetails.set(index2, details1);
        for (ChannelDetails details : this.channelDetails) {
            this.contentPanel.add((Component)details.controlPanel, this.gbcS);
            this.contentPanel.add((Component)((Object)details.graphPanel), this.gbcF);
            this.contentPanel.add((Component)details.verticalAxisPanel, this.gbcS);
            this.contentPanel.add((Component)details.separator, this.gbc3c);
        }
        this.addBottomPanel();
        this.refreshSeparators();
        super.validate();
    }

    public void channelAdded(final AudioFile file, final AudioChannel channel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilePanel.this.channelAdded0(file, channel);
            }
        });
    }

    public void channelRemoved(final AudioFile file, final AudioChannel channel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilePanel.this.channelRemoved0(file, channel);
            }
        });
    }

    public void channelExchanged(final AudioFile file, final AudioChannel channel1, final AudioChannel channel2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilePanel.this.channelExchanged0(file, channel1, channel2);
            }
        });
    }

    public void lockStatusChanged(ILockable lockable, boolean readLocked, final boolean writeLocked) {
        AwtTools.invokeInSwing(new Runnable(){

            public void run() {
                FilePanel.this.disablerAlpha.set(0);
                if (writeLocked) {
                    FilePanel.this.contentPanel.setCursor(Cursor.getPredefinedCursor(3));
                    FilePanel.this.disablerPanel.setBackground(new Color(0, 0, 0, 0));
                    FilePanel.this.disablerPanel.setVisible(true);
                    FilePanel.this.repaint();
                } else {
                    FilePanel.this.contentPanel.setCursor(null);
                    FilePanel.this.disablerPanel.setVisible(false);
                    FilePanel.this.repaint();
                }
            }
        });
    }

    public static String getDisplayedFileName(AudioFile file) {
        String result = file.getFile() == null ? "New Audio File" : file.getFile().getName();
        if (file.isModified()) {
            result = String.valueOf(result) + "*";
        }
        return result;
    }

    public static String getDisplayedTooltip(AudioFile file) {
        StringBuilder result = new StringBuilder();
        result.append("<html><body>");
        if (file.getFile() != null) {
            result.append(file.getFile().getAbsolutePath());
        }
        result.append("<p>");
        result.append(TimeFormater.formatDuration(file));
        result.append(" - ");
        result.append(file.getSampleSize());
        result.append(" bit / ");
        float sampleRate = file.getSampleRate();
        int ksr = (int)sampleRate / 100;
        if (sampleRate == (float)(ksr * 100)) {
            DecimalFormat format = new DecimalFormat("#0.#");
            result.append(format.format(sampleRate / 1000.0f));
            result.append(" kHz");
        } else {
            result.append(sampleRate);
            result.append(" Hz");
        }
        if (file.isModified()) {
            result.append("<p>");
            result.append("<small><i>");
            result.append("There are unsaved changes");
            result.append("</i></small>");
        }
        result.append("</body></html>");
        return result.toString();
    }

    public void fileSaved(AudioFile file) {
        this.updateFileDetails(file);
    }

    public void transactionStateChanged(AudioChannel channel, boolean running) {
    }

    public void dataModified(AudioChannel channel, long startPos, long stopPos) {
        this.updateFileDetails(channel.getFile());
    }

    private void updateFileDetails(final AudioFile file) {
        AwtTools.invokeInSwing(new Runnable(){

            public void run() {
                if (FilePanel.this.session.isOpened(file)) {
                    String displayName = FilePanel.getDisplayedFileName(file);
                    String tooltip = FilePanel.getDisplayedTooltip(file);
                    FilePanel.this.fileNameLabel.setText(displayName);
                    FilePanel.this.fileNameLabel.setToolTipText(tooltip);
                    FilePanel.this.fileNameRadio.setText(displayName);
                    FilePanel.this.fileNameRadio.setToolTipText(tooltip);
                    if (FilePanel.this.fileNameLabel.isVisible()) {
                        FilePanel.this.fileNameLabel.repaint();
                        FilePanel.this.fileNameLabel.revalidate();
                    } else if (FilePanel.this.fileNameRadio.isVisible()) {
                        FilePanel.this.fileNameRadio.repaint();
                        FilePanel.this.fileNameRadio.revalidate();
                    }
                }
            }
        });
    }

    public void viewChanged(AudioDataView view) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilePanel.this.refreshScrollBar();
            }
        });
    }

    public void channelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
        final AudioFile file = channel.getFile();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (FilePanel.this.session.isOpened(file)) {
                    FilePanel.this.refreshScrollBar();
                }
            }
        });
    }

    public void setViewType(ChannelViewType viewType) {
        if (this.viewType.equals((Object)viewType)) {
            return;
        }
        this.viewType = viewType;
        for (ChannelDetails detail : this.channelDetails) {
            detail.graphPanel.setViewType(viewType);
        }
    }

    private void refreshSeparators() {
        assert (SwingUtilities.isEventDispatchThread());
        int i = 0;
        while (i < this.channelDetails.size()) {
            boolean isLast = i == this.channelDetails.size() - 1;
            ChannelDetails details = this.channelDetails.get(i);
            details.separator.setVisible(!isLast);
            details.separator.revalidate();
            ++i;
        }
    }

    private int getViewsHeight() {
        int result = 0;
        for (ChannelDetails detail : this.channelDetails) {
            result += detail.graphPanel.getHeight();
        }
        return result;
    }

    private int getMinViewHeight(ChannelDetails details) {
        if (details.controlPanel.isVisible()) {
            Dimension minSize = details.controlPanel.getMinimumSize();
            Insets insets = details.controlPanel.getInsets();
            return minSize.height + insets.top + insets.bottom;
        }
        return 10;
    }

    private int getMinViewsHeight() {
        int result = 0;
        for (ChannelDetails details : this.channelDetails) {
            result += this.getMinViewHeight(details);
        }
        return result;
    }

    private void setViewsHeight(int height) {
        int maxHeight = 8000 * this.channelDetails.size();
        if (height > maxHeight) {
            height = maxHeight;
        }
        float[] ratios = new float[this.channelDetails.size()];
        int totalHeight = this.getViewsHeight();
        int i = 0;
        while (i < this.channelDetails.size()) {
            ChannelDetails details = this.channelDetails.get(i);
            int viewHeight = details.graphPanel.getHeight();
            ratios[i] = (float)viewHeight / (float)totalHeight;
            ++i;
        }
        assert (height >= this.getMinViewsHeight());
        float ratioRemaining = 1.0f;
        int heightRemaining = height;
        int i2 = 0;
        while (i2 < this.channelDetails.size()) {
            float ratio = ratios[i2] / ratioRemaining;
            int viewHeight = (int)((float)heightRemaining * ratio + 0.5f);
            ChannelDetails details = this.channelDetails.get(i2);
            int minViewheight = this.getMinViewHeight(details);
            if (viewHeight < minViewheight) {
                viewHeight = minViewheight;
            }
            details.graphPanel.setHeight(viewHeight);
            ((JComponent)((Object)details.graphPanel)).revalidate();
            heightRemaining -= viewHeight;
            ratioRemaining -= ratios[i2];
            ++i2;
        }
    }

    void fileSeparatorPressed(MouseEvent e) {
        if ((e.getModifiersEx() & 0x1000) != 0 && this.dragging) {
            this.setViewsHeight(this.startDragHeight);
            this.dragging = false;
        } else {
            this.startDragY = AwtTools.getScreenY(e);
            this.curDragHeight = this.startDragHeight = this.getViewsHeight();
            this.dragging = true;
        }
    }

    void fileSeparatorDragged(MouseEvent e) {
        int minHeight;
        if (!this.dragging) {
            return;
        }
        int newY = AwtTools.getScreenY(e);
        int yDelta = newY - this.startDragY;
        int newHeight = this.startDragHeight + yDelta;
        if (newHeight < (minHeight = this.getMinViewsHeight())) {
            newHeight = minHeight;
        }
        if (newHeight != this.curDragHeight) {
            this.setViewsHeight(newHeight);
            this.curDragHeight = newHeight;
        }
    }

    void fileSeparatorClicked(MouseEvent e, JScrollPane sp, JSeparator fileSeparator) {
        if (e.getClickCount() == 2) {
            this.fitHeight(sp, fileSeparator);
        }
        this.dragging = false;
    }

    void fitHeight(JScrollPane sp, JSeparator fileSeparator) {
        int newHeight = sp.getViewport().getViewRect().height;
        newHeight -= this.getHeight();
        newHeight -= fileSeparator.getHeight();
        for (ChannelDetails detail : this.channelDetails) {
            newHeight += detail.graphPanel.getHeight();
        }
        int minHeight = this.getMinViewsHeight();
        if (newHeight < minHeight) {
            newHeight = minHeight;
        }
        this.setViewsHeight(newHeight);
    }

    private IAudioChannelPanel getNextPanel(IAudioChannelPanel panel) {
        boolean found = false;
        for (ChannelDetails details : this.channelDetails) {
            if (found) {
                return details.graphPanel;
            }
            if (details.graphPanel != panel) continue;
            found = true;
        }
        return null;
    }

    private ChannelDetails getDetails(IAudioChannelPanel panel) {
        for (ChannelDetails details : this.channelDetails) {
            if (details.graphPanel != panel) continue;
            return details;
        }
        return null;
    }

    void viewSeparatorPressed(MouseEvent e, IAudioChannelPanel panel1) {
        IAudioChannelPanel panel2 = this.getNextPanel(panel1);
        assert (panel1 != panel2);
        if ((e.getModifiersEx() & 0x1000) != 0 && this.dragging) {
            panel1.setHeight(this.startDragHeight);
            panel2.setHeight(this.startDragHeight2);
            this.dragging = false;
        } else {
            this.startDragY = AwtTools.getScreenY(e);
            this.curDragHeight = this.startDragHeight = panel1.getHeight();
            this.curDragHeight2 = this.startDragHeight2 = panel2.getHeight();
            this.session.setCurrentFile(this.file);
            this.dragging = true;
        }
    }

    void viewSeparatorDragged(MouseEvent e, IAudioChannelPanel panel1) {
        if (!this.dragging) {
            return;
        }
        IAudioChannelPanel panel2 = this.getNextPanel(panel1);
        int newY = AwtTools.getScreenY(e);
        int yDelta = newY - this.startDragY;
        int newHeight1 = this.startDragHeight + yDelta;
        int newHeight2 = this.startDragHeight2 - yDelta;
        int minViewHeight1 = this.getMinViewHeight(this.getDetails(panel1));
        int minViewHeight2 = this.getMinViewHeight(this.getDetails(panel2));
        while (newHeight1 < minViewHeight1 || newHeight2 < minViewHeight2) {
            if (yDelta == 0) {
                return;
            }
            yDelta = yDelta > 0 ? --yDelta : ++yDelta;
            newHeight1 = this.startDragHeight + yDelta;
            newHeight2 = this.startDragHeight2 - yDelta;
        }
        if (newHeight1 != this.curDragHeight) {
            panel1.setHeight(newHeight1);
            this.curDragHeight = newHeight1;
        }
        if (newHeight2 != this.curDragHeight2) {
            panel2.setHeight(newHeight2);
            this.curDragHeight2 = newHeight2;
        }
    }

    void viewSeparatorClicked(MouseEvent e, IAudioChannelPanel panel1) {
        if (e.getClickCount() == 2) {
            IAudioChannelPanel panel2 = this.getNextPanel(panel1);
            int totalheight = panel1.getHeight() + panel2.getHeight();
            int halfHeight = (totalheight + 1) / 2;
            if (halfHeight < 10) {
                halfHeight = 10;
            }
            panel1.setHeight(halfHeight);
            panel2.setHeight(halfHeight);
        } else if (e.getClickCount() == 3) {
            this.distributeHeight();
        }
        this.dragging = false;
    }

    void distributeHeight() {
        int totalHeight = 0;
        for (ChannelDetails details : this.channelDetails) {
            totalHeight += details.graphPanel.getHeight();
        }
        int newHeight = totalHeight / this.channelDetails.size();
        if (newHeight < 10) {
            newHeight = 10;
        }
        for (ChannelDetails details : this.channelDetails) {
            details.graphPanel.setHeight(newHeight);
        }
    }

    void fitHeight() {
        this.parent.fitHeight(this.file);
    }

    FilePanel getPanelFor(AudioFile file) {
        return filePanels.get(file);
    }

    private void toggleControlPanelVisible() {
        this.controlPanelsVisible = !this.controlPanelsVisible;
        this.chkHide.setVisible(this.controlPanelsVisible);
        this.chkHide.setSelected(true);
        this.chkShow.setSelected(false);
        this.chkShow.setVisible(!this.controlPanelsVisible);
        this.chkHide.revalidate();
        this.chkShow.revalidate();
        for (ChannelDetails details : this.channelDetails) {
            details.controlPanel.setVisible(this.controlPanelsVisible);
            details.controlPanel.revalidate();
        }
        this.cornerPanel1.setVisible(this.controlPanelsVisible);
        this.cornerPanel1.revalidate();
        this.cornerPanel2.setVisible(this.controlPanelsVisible);
        this.cornerPanel2.revalidate();
    }

    private void refreshScrollBar() {
        if (this.scrollBarUpdating) {
            return;
        }
        this.scrollBarUpdating = true;
        assert (SwingUtilities.isEventDispatchThread());
        AudioDataView view = this.file.getView();
        long total = this.file.getLength();
        long start = view.getStartPosition();
        long stop = view.getStopPosition();
        long visible = stop - start;
        if (visible < 1L) {
            visible = 1L;
        }
        if (total < 1L) {
            total = 1L;
        }
        int extent = (int)(visible * 0x40000000L / total);
        int value = (int)(start * 0x40000000L / total);
        this.scrollBar.setValue(value);
        this.scrollBar.setVisibleAmount(extent);
        this.scrollBar.setValue(value);
        this.scrollBar.setBlockIncrement((int)((long)extent * 9L / 10L));
        this.scrollBar.setUnitIncrement((int)((long)extent / 20L));
        this.scrollBar.setEnabled(extent < 0x40000000 || Platform.isMacOsX());
        this.scrollBar.revalidate();
        this.scrollBar.repaint();
        this.prevScrollBarValue = this.scrollBar.getModel().getValue();
        this.scrollBarUpdating = false;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.scrollBarUpdating) {
            return;
        }
        this.scrollBarUpdating = true;
        AudioDataView view = this.file.getView();
        long total = this.file.getLength();
        BoundedRangeModel model = this.scrollBar.getModel();
        long start = ((long)model.getValue() * total + (long)model.getMaximum() / 2L) / (long)model.getMaximum();
        if (model.getValue() < this.prevScrollBarValue) {
            start = Math.min(start, view.getStartPosition() - 1L);
        } else if (model.getValue() > this.prevScrollBarValue) {
            start = Math.max(start, view.getStartPosition() + 1L);
        }
        long stop = start + (view.getStopPosition() - view.getStartPosition());
        if (stop > total) {
            start -= stop - total;
            stop = total;
        }
        if (start < 0L) {
            stop -= start;
            start = 0L;
        }
        view.scroll(start - view.getStartPosition());
        this.scrollBarUpdating = false;
        this.session.setCurrentFile(this.file);
        this.prevScrollBarValue = this.scrollBar.getModel().getValue();
    }

    public void dispose() {
        filePanels.remove(this.file);
        this.file.getView().removeViewListener(this);
        this.file.removeLockListener(this);
        this.file.removeAudioFileListener(this);
        this.session.removeSessionListener(this.sessionListener);
        for (ChannelDetails details : this.channelDetails) {
            ((IDisposable)((Object)details.graphPanel)).dispose();
            AwtTools.cleanupListeners(details.separator);
        }
        this.timeLinePanel.dispose();
        this.setCurrentFileAction.dispose();
        this.controlPanel.dispose();
        this.channelDetails = null;
        this.chan2details = null;
        this.file = null;
        this.session = null;
        this.parent = null;
        this.sessionListener = null;
        this.setCurrentFileAction = null;
        this.cornerPanel1 = null;
        this.timeLinePanel = null;
        this.cornerPanel2 = null;
        this.controlPanel = null;
        this.scrollBar = null;
        AwtTools.cleanupListeners(this.chkHide);
        AwtTools.cleanupListeners(this.chkShow);
        this.chkHide = null;
        this.chkShow = null;
        this.fileNameLabel = null;
        this.fileNameRadio = null;
        AwtTools.cleanupListeners(this.fileNamePanel);
        this.fileNamePanel = null;
    }

    static class ChannelDetails {
        public ChannelControlPanel controlPanel;
        public IAudioChannelPanel graphPanel;
        public VerticalAxisPanel verticalAxisPanel;
        public JSeparator separator;

        ChannelDetails() {
        }
    }
}

