/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file;

import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.sonics.gui.selectors.SelectionsCombinator;

public class FlagInfo {
    private final AudioFile file;
    private final long oldCursorPos;
    private final TimeRangeSelection selection;
    private final TimeRangeSelection prevSelection;
    private final boolean start;
    private final SelectionsCombinator combinator;

    public FlagInfo(AudioFile file, TimeRangeSelection selection, boolean start) {
        this.file = file;
        this.selection = selection;
        this.start = start;
        if (selection != null) {
            this.combinator = new SelectionsCombinator(file, true, selection);
            this.prevSelection = selection.clone();
            this.oldCursorPos = 0L;
        } else {
            this.combinator = null;
            this.prevSelection = null;
            this.oldCursorPos = file.getSelection().getCursorPosition();
        }
    }

    public long getPosition() {
        if (this.getSelection() == null) {
            return this.file.getSelection().getCursorPosition();
        }
        if (this.isStart()) {
            return this.getSelection().getStartPosition();
        }
        return this.getSelection().getStopPosition();
    }

    public void setPosition(long newPos, boolean adjusting) {
        if (this.getSelection() == null) {
            this.file.getSelection().setCursorPosition(newPos);
        } else if (this.isStart()) {
            this.setRange(newPos, this.prevSelection.getStopPosition(), adjusting);
        } else {
            this.setRange(this.prevSelection.getStartPosition(), newPos, adjusting);
        }
        if (this.combinator != null) {
            this.combinator.combineWithCurrentSelection(this.getSelection());
        }
    }

    private void setRange(long start, long stop, boolean adjusting) {
        long stop0;
        long start0 = Math.min(start, stop);
        if (start0 < 0L) {
            start0 = 0L;
        }
        if ((stop0 = Math.max(start, stop)) > this.file.getLength()) {
            stop0 = this.file.getLength();
        }
        this.selection.setRange(start0, stop0, adjusting);
    }

    public void cancel() {
        if (this.combinator != null) {
            this.combinator.cancel();
        } else {
            this.file.getSelection().setCursorPosition(this.oldCursorPos);
        }
    }

    public TimeRangeSelection getSelection() {
        return this.selection;
    }

    public TimeRangeSelection getPrevSelection() {
        return this.prevSelection;
    }

    public boolean isStart() {
        return this.start;
    }
}

