/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file;

import ch.tachyon.sonics.data.audio.AudioFile;

public class TimeFormater {
    private static final long MINUTE = 60L;
    private static final long HOUR = 3600L;
    private static final long DAY = 86400L;
    private static final int MAX_ELEMENTS = 3;
    private static final int MAX_ELEMENTS_FOR_MILLIS = 2;

    public static String formatDuration(AudioFile file) {
        double duration = (double)file.getLength() / (double)file.getSampleRate();
        return TimeFormater.formatDuration(duration, 3, 2);
    }

    public static String formatFullDuration(double durationSeconds) {
        return TimeFormater.formatDuration(durationSeconds, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static String formatDuration(double durationSeconds, int maxElements, int maxElementsMillis) {
        int days = (int)(durationSeconds / 86400.0);
        int hours = (int)((durationSeconds -= (double)((long)days * 86400L)) / 3600.0);
        int minutes = (int)((durationSeconds -= (double)((long)hours * 3600L)) / 60.0);
        int seconds = (int)(durationSeconds -= (double)((long)minutes * 60L));
        int tmillis = (int)((durationSeconds -= (double)seconds) * 10000.0 + 0.5);
        StringBuilder result = new StringBuilder();
        int numElements = 0;
        if (days > 0 && numElements < maxElements) {
            result.append(days);
            result.append('d');
            ++numElements;
        }
        if ((hours > 0 || numElements > 0) && numElements < maxElements) {
            result.append(hours);
            result.append('h');
            ++numElements;
        }
        if ((minutes > 0 || numElements > 0) && numElements < maxElements) {
            if (numElements > 0) {
                result.append(minutes / 10);
                result.append(minutes % 10);
            } else {
                result.append(minutes);
            }
            ++numElements;
        }
        if (numElements < maxElements) {
            if (numElements > 0) {
                result.append(':');
                result.append(seconds / 10);
                result.append(seconds % 10);
            } else {
                result.append(seconds);
            }
            if (++numElements == 1 && tmillis == 0) {
                result.append("s");
            }
        }
        if (tmillis > 0 && numElements < maxElementsMillis) {
            result.append('.');
            while (tmillis > 0 && tmillis % 10 == 0) {
                tmillis /= 10;
            }
            result.append(tmillis);
            if (numElements == 1) {
                result.append("s");
            }
        }
        return result.toString();
    }
}

