/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file;

import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionAdapter;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.AudioFileViewListener;
import ch.tachyon.sonics.gui.file.FlagInfo;
import ch.tachyon.sonics.gui.file.TimeFormater;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.ILafListener;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.gui.ImageUtils;
import org.corebounce.common.utils.IDisposable;

public class TimeLinePanel
extends JPanel
implements AudioFileViewListener,
ILafListener,
IDisposable {
    private static final Color MAJOR_TICK_COLOR = Color.black;
    private static final Color MINOR_TICK_COLOR = Color.darkGray;
    private static final int HEIGHT = 19;
    private static final int BORDER_SIZE = 2;
    private static final int LABEL_MIN_WIDTH = 80;
    private static final int CURSOR_WIDTH = 7;
    private static final int CURSOR_HEIGHT = 14;
    private static final int FLAG_WIDTH = 8;
    private static final int FLAG_HEIGHT = 16;
    private static final int MOUSE_LOCK_WIDTH = 10;
    private static final double MIN = 60000.0;
    private static final double HOUR = 360000.0;
    private static final double[] TICKS = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0, 10000.0, 30000.0, 60000.0, 120000.0, 300000.0, 600000.0, 1800000.0, 360000.0, 720000.0, 1800000.0, 3600000.0, 8640000.0};
    private static final int[] MINOR_DIVS = new int[]{5, 4, 5, 5, 4, 5, 5, 4, 5, 5, 4, 5, 5, 4, 5, 5, 3, 6, 4, 5, 5, 3, 6, 4, 5, 5, 6};
    private final Session session;
    private final AudioFile file;
    private Font font;
    private long prevStartPos = -1L;
    private long prevStopPos = -1L;
    private Image cacheImage;
    private int cacheWidth;
    private Map<?, ?> textRenderingHints;
    private SelectionAdapter selectionListener = new SelectionListener();
    private Image cursorImage;
    private Image beginImage;
    private Image endImage;
    private Color majorTickColor;
    private Color minorTickColor;
    private Color background;
    private FlagInfo draggingFlag = null;
    private boolean moving = false;
    private boolean zooming = false;
    private int startMoveX;
    private int lastX;
    private long prevViewStart;
    private long prevViewStop;
    private int cursorType = -1;

    public TimeLinePanel(Session session, AudioFile file) {
        this.setOpaque(true);
        this.setBorder(new BevelBorder(0));
        this.session = session;
        this.file = file;
        file.getView().addViewListener(this);
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.textRenderingHints = (Map)tk.getDesktopProperty("awt.font.desktophints");
        file.getSelection().addSelectionListener(this.selectionListener);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TimeLinePanel.this.mouseClicked(e);
            }

            public void mousePressed(MouseEvent e) {
                TimeLinePanel.this.mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                TimeLinePanel.this.mouseReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                TimeLinePanel.this.mouseMoved(e);
            }

            public void mouseDragged(MouseEvent e) {
                TimeLinePanel.this.mouseDragged(e);
            }
        });
        this.cursorImage = IconLoader.getImage(this.getClass(), "diamond.png", 7, 14);
        this.beginImage = IconLoader.getImage(this.getClass(), "flag-begin.png", 8, 16);
        this.endImage = IconLoader.getImage(this.getClass(), "flag-end.png", 8, 16);
        this.updateTooltip();
        this.updateLaf();
        AwtTools.addPostLafListener(this);
    }

    private void updateTooltip() {
        final StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html><body><b>");
        tooltip.append("Time");
        tooltip.append("</b>");
        tooltip.append("<p>Left-click and drag to move");
        tooltip.append("<p>Right-click and drag to zoom in/out");
        tooltip.append("<p>Double-click to normalize");
        tooltip.append("</body></html>");
        AwtTools.invokeInSwing(new Runnable(){

            public void run() {
                TimeLinePanel.this.setToolTipText(tooltip.toString());
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 19);
    }

    public AudioFile getFile() {
        return this.file;
    }

    public void lookAndFeelChanged(String lafClassName) {
        if (!this.isShowing()) {
            return;
        }
        this.updateLaf();
        this.refresh();
    }

    private void updateLaf() {
        AwtTools.invokeAndWait(new Runnable(){

            public void run() {
                TimeLinePanel.this.font = TimeLinePanel.this.getFont().deriveFont(11.0f);
                TimeLinePanel.this.background = AwtTools.backgroundColor(TimeLinePanel.this);
                TimeLinePanel.this.majorTickColor = AwtTools.foregroundColor(TimeLinePanel.this, "Label.foreground", MAJOR_TICK_COLOR);
                TimeLinePanel.this.minorTickColor = AwtTools.foregroundColor(TimeLinePanel.this, "Label.disabledForeground", MINOR_TICK_COLOR);
            }
        });
    }

    public void viewChanged(AudioDataView view) {
        long fileSpan = view.getStopPosition() - view.getStartPosition();
        if (fileSpan <= 0L) {
            return;
        }
        if (fileSpan == this.prevStopPos - this.prevStartPos) {
            int width = this.getWidth();
            int oldX = (int)(this.prevStartPos * (long)width / fileSpan);
            int newX = (int)(view.getStartPosition() * (long)width / fileSpan);
            int scrollPixel = newX - oldX;
            if (Math.abs(scrollPixel) + 80 < width) {
                int height = this.getHeight();
                Image cacheImage = this.cacheImage(true);
                if (cacheImage != null) {
                    Graphics2D gc = (Graphics2D)cacheImage.getGraphics();
                    if (scrollPixel > 0) {
                        ImageUtils.copyArea(gc, scrollPixel, 0, width - scrollPixel, height, -scrollPixel, 0);
                        this.refresh(gc, width - scrollPixel - 80, width);
                    } else if (scrollPixel < 0) {
                        ImageUtils.copyArea(gc, 0, 0, width + scrollPixel, height, -scrollPixel, 0);
                        this.refresh(gc, 0, -scrollPixel + 80);
                    }
                    gc.dispose();
                    this.prevStartPos = view.getStartPosition();
                    this.prevStopPos = view.getStopPosition();
                    return;
                }
            }
        }
        this.refresh();
        this.prevStartPos = view.getStartPosition();
        this.prevStopPos = view.getStopPosition();
    }

    public void channelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
        this.prevStartPos = -1L;
        this.prevStopPos = -1L;
        this.refresh();
    }

    private void selectFile() {
        this.session.setCurrentFile(this.file);
    }

    private FlagInfo getFlagUnderMouse(MouseEvent e) {
        boolean shiftKey;
        int mouseX = e.getX();
        SelectionInfo selInfo = this.file.getSelection();
        int bestScore = -1;
        FlagInfo bestFlag = null;
        for (ISelection selection : selInfo.getSelections()) {
            int stopScore;
            if (!(selection instanceof TimeRangeSelection)) continue;
            TimeRangeSelection trSel = (TimeRangeSelection)selection;
            int startScore = this.getScore(trSel.getStartPosition(), mouseX);
            if (startScore > bestScore) {
                bestScore = startScore;
                bestFlag = new FlagInfo(this.file, trSel, true);
            }
            if ((stopScore = this.getScore(trSel.getStopPosition(), mouseX)) <= bestScore) continue;
            bestScore = stopScore;
            bestFlag = new FlagInfo(this.file, trSel, false);
        }
        int cursorScore = this.getScore(selInfo.getCursorPosition(), mouseX);
        boolean bl = shiftKey = (e.getModifiersEx() & 0x40) != 0;
        if (cursorScore > bestScore || shiftKey && cursorScore >= 0 && cursorScore >= bestScore) {
            bestScore = cursorScore;
            bestFlag = new FlagInfo(this.file, null, false);
        }
        return bestFlag;
    }

    private void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.file.getView().setVisibleRange(0L, this.file.getLength());
        }
    }

    private void mouseMoved(MouseEvent e) {
        if ((e.getModifiersEx() & 0x80) != 0) {
            this.changeCursor(null);
            return;
        }
        FlagInfo bestFlag = this.getFlagUnderMouse(e);
        this.changeCursor(bestFlag);
    }

    private void changeCursor(FlagInfo flag) {
        if (flag == null) {
            this.changeCursor(-1);
        } else if (flag.getSelection() == null) {
            this.changeCursor(12);
        } else if (flag.isStart()) {
            this.changeCursor(10);
        } else if (!flag.isStart()) {
            this.changeCursor(11);
        }
    }

    private int getScore(long position, int mouseX) {
        int xPos = this.file.getMergedPanel().toXCoord(position, 0);
        if (Math.abs(xPos - mouseX) > 10) {
            return -1;
        }
        return 10 - Math.abs(xPos - mouseX);
    }

    private void mousePressed(MouseEvent e) {
        this.selectFile();
        if (AwtTools.isLeftButton(e)) {
            if (this.zooming) {
                this.file.getView().setVisibleRange(this.prevViewStart, this.prevViewStop);
                this.changeCursor(-1);
                this.zooming = false;
            }
            this.draggingFlag = this.getFlagUnderMouse(e);
            if (this.draggingFlag != null) {
                this.changeCursor(this.draggingFlag);
            } else {
                this.prevViewStart = this.file.getView().getStartPosition();
                this.prevViewStop = this.file.getView().getStopPosition();
                this.startMoveX = e.getX();
                this.moving = true;
            }
        } else {
            if (this.draggingFlag != null) {
                this.draggingFlag.cancel();
                this.draggingFlag = null;
                this.changeCursor(this.draggingFlag);
            }
            if (this.moving) {
                this.file.getView().setVisibleRange(this.prevViewStart, this.prevViewStop);
                this.changeCursor(-1);
                this.moving = false;
            }
            if (AwtTools.isRightButton(e)) {
                this.prevViewStart = this.file.getView().getStartPosition();
                this.prevViewStop = this.file.getView().getStopPosition();
                this.lastX = this.startMoveX = e.getX();
                Debug.info((String)"Mouse X {0}", (Object[])new Object[]{this.startMoveX});
                this.zooming = true;
            }
        }
    }

    private void mouseDragged(MouseEvent e) {
        if (this.draggingFlag != null) {
            this.dragFlag(e, true);
        } else if (this.moving) {
            this.moveView(e);
        } else if (this.zooming) {
            this.zoomView(e);
        }
    }

    private void mouseReleased(MouseEvent e) {
        if (this.draggingFlag != null) {
            this.dragFlag(e, false);
            this.draggingFlag = null;
            int x = e.getX();
            int y = e.getY();
            if (x >= 0 && y >= 0 && x < this.getWidth() && y < this.getHeight()) {
                this.mouseMoved(e);
            } else {
                this.changeCursor(-1);
            }
        } else if (this.moving) {
            this.moveView(e);
            this.moving = false;
            this.changeCursor(-1);
        } else if (this.zooming) {
            this.zoomView(e);
            this.zooming = false;
            this.changeCursor(-1);
        }
    }

    private void dragFlag(MouseEvent e, boolean adjusting) {
        int xPos = e.getX();
        int roundPos = this.draggingFlag.getSelection() == null ? 0 : (this.draggingFlag.isStart() ? -1 : 1);
        long newPos = this.file.getMergedPanel().fromXCoord(xPos, roundPos);
        this.draggingFlag.setPosition(newPos, adjusting);
    }

    private void moveView(MouseEvent e) {
        this.changeCursor(13);
        int newX = e.getX();
        long deltaPos = this.file.getMergedPanel().deltaFromPixel(this.startMoveX - newX);
        if (this.prevViewStart + deltaPos < 0L) {
            deltaPos = -this.prevViewStart;
        } else if (this.prevViewStop + deltaPos > this.file.getLength()) {
            deltaPos = this.file.getLength() - this.prevViewStop;
        }
        AudioDataView view = this.file.getView();
        view.scroll(this.prevViewStart + deltaPos - view.getStartPosition());
    }

    private void zoomView(MouseEvent e) {
        AudioDataView view = this.file.getView();
        int width = this.getWidth();
        int newX = e.getX();
        int delta = this.lastX - newX;
        if (delta > 0) {
            this.changeCursor(10);
        } else {
            this.changeCursor(11);
        }
        double zoomAmount = Math.pow(1.01, delta);
        float stopAmount = (float)(width - this.startMoveX) / (float)width;
        float startAmount = (float)this.startMoveX / (float)width;
        double startZoom = Math.pow(zoomAmount, startAmount);
        double stopZoom = Math.pow(zoomAmount, stopAmount);
        long range = view.getStopPosition() - view.getStartPosition();
        double stopDelta = (double)range * stopZoom + 0.5;
        double startDelta = (double)range * startZoom + 0.5;
        double middle = ((double)view.getStartPosition() + (double)view.getStopPosition()) / 2.0;
        long newStart = (long)(middle - startDelta / 2.0 + 0.5);
        long newStop = (long)(middle + stopDelta / 2.0 + 0.5);
        if (newStart < 0L) {
            newStart = 0L;
        }
        if (newStop > this.file.getLength()) {
            newStop = this.file.getLength();
        }
        if (newStop >= newStart + 8L) {
            view.setVisibleRange(newStart, newStop);
        }
        this.lastX = newX;
    }

    private void changeCursor(int cursorType) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.cursorType == cursorType) {
            return;
        }
        this.cursorType = cursorType;
        if (cursorType < 0) {
            AwtTools.getWindow(this).setCursor(null);
            this.setCursor(null);
        } else if (this.draggingFlag != null || this.moving || this.zooming) {
            AwtTools.getWindow(this).setCursor(Cursor.getPredefinedCursor(cursorType));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(cursorType));
        }
    }

    private synchronized Image cacheImage(boolean renderIfCreated) {
        if (this.cacheImage == null || this.cacheWidth != this.getWidth()) {
            this.cacheImage = this.createImage(this.getWidth(), this.getHeight() - 4);
            this.cacheWidth = this.getWidth();
            if (this.cacheImage != null && renderIfCreated) {
                Graphics2D gc = (Graphics2D)this.cacheImage.getGraphics();
                this.render(this.getWidth(), this.getHeight() - 4, gc);
            }
        }
        return this.cacheImage;
    }

    private void refresh() {
        Image cacheImage = this.cacheImage(false);
        if (cacheImage == null) {
            return;
        }
        Graphics2D gc = (Graphics2D)cacheImage.getGraphics();
        this.refresh0(gc, 0, this.getWidth());
        gc.dispose();
    }

    private void refresh(Graphics2D gc0, int startX, int stopX) {
        Graphics2D gc = (Graphics2D)gc0.create();
        this.refresh0(gc, startX, stopX);
        gc.dispose();
    }

    private void refresh0(Graphics2D gc, int startX, int stopX) {
        gc.setClip(startX, 0, stopX - startX, this.getHeight());
        this.render(this.getWidth(), this.getHeight() - 4, gc);
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Image cacheImage = this.cacheImage(true);
        if (cacheImage != null) {
            g.drawImage(cacheImage, 0, 2, null);
        }
    }

    private void render(int width, int height, Graphics2D g) {
        if (!this.session.isOpened(this.file)) {
            return;
        }
        g.setColor(this.background);
        g.fillRect(0, 0, width, height);
        g.setFont(this.font);
        if (this.textRenderingHints != null) {
            g.setRenderingHints(this.textRenderingHints);
        }
        float sampleRate = this.file.getSampleRate();
        long startPos = this.file.getView().getStartPosition();
        long stopPos = this.file.getView().getStopPosition();
        long viewSpan = stopPos - startPos;
        if (this.file.getLength() <= 0L) {
            String label = "The audio file is empty";
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(label, g);
            int textHeight = (int)(-bounds.getY() - 0.5);
            int xText = (int)((double)width / 2.0 - bounds.getWidth() / 2.0 + 0.5);
            g.setColor(this.majorTickColor);
            g.drawString(label, xText, textHeight);
            return;
        }
        if (viewSpan <= 0L) {
            return;
        }
        double startMillis = (double)startPos * 1000.0 / (double)sampleRate;
        double stopMillis = (double)stopPos * 1000.0 / (double)sampleRate;
        double spanMillis = stopMillis - startMillis;
        double labelMinSpanMillis = spanMillis * 80.0 / (double)width;
        int index = 0;
        double labelRes = TICKS[0];
        double tickRes = TICKS[0];
        while (labelRes < labelMinSpanMillis) {
            if (++index < TICKS.length) {
                labelRes = TICKS[index];
                continue;
            }
            labelRes *= 10.0;
        }
        tickRes = index < MINOR_DIVS.length ? labelRes / (double)MINOR_DIVS[index] : labelRes / 5.0;
        g.setColor(this.minorTickColor);
        double tickMillis = Math.floor(stopMillis / tickRes) * tickRes;
        while (tickMillis > startMillis) {
            int xPos = (int)((tickMillis - startMillis) * (double)width / spanMillis + 0.5);
            g.fillRect(xPos, (height + 1) / 2, 1, height / 2);
            tickMillis -= tickRes;
        }
        double labelMillis = Math.floor(stopMillis / labelRes) * labelRes;
        while (labelMillis > startMillis) {
            int xPos = (int)((labelMillis - startMillis) * (double)width / spanMillis + 0.5);
            String label = TimeFormater.formatFullDuration(labelMillis / 1000.0);
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(label, g);
            int textHeight = (int)(-bounds.getY() - 0.5);
            g.setColor(this.majorTickColor);
            g.fillRect(xPos - 1, textHeight + 1, 3, height - textHeight - 1);
            g.setColor(this.background);
            int xText = (int)((double)xPos - bounds.getWidth() / 2.0 + 0.5);
            int textWidth = (int)(bounds.getWidth() + 0.5);
            g.fillRect(xText - 2, 1, textWidth + 4, textHeight);
            g.setColor(this.majorTickColor);
            g.drawString(label, xText, textHeight);
            labelMillis -= labelRes;
        }
        long cursorPos = this.file.getSelection().getCursorPosition();
        int cursorX = (int)(((cursorPos - startPos) * (long)width + viewSpan / 2L) / viewSpan);
        if (cursorX >= -3 && cursorX <= width + 3) {
            g.drawImage(this.cursorImage, cursorX - 3, 1, null);
        }
        SelectionInfo selInfo = this.file.getSelection();
        for (ISelection selection : selInfo.getSelections()) {
            AffineTransform tr;
            long selStart = selection.getBoundingStartPosition();
            long selStop = selection.getBoundingStopPosition();
            double startX = (double)(selStart - startPos) * (double)width / (double)viewSpan;
            double stopX = (double)(selStop - startPos) * (double)width / (double)viewSpan;
            if (startX >= 0.0 && startX <= (double)(width + 8)) {
                tr = AffineTransform.getTranslateInstance(startX - 8.0, -1.0);
                g.drawImage(this.beginImage, tr, null);
            }
            if (!(stopX >= -8.0) || !(stopX <= (double)width)) continue;
            tr = AffineTransform.getTranslateInstance(stopX, -1.0);
            g.drawImage(this.endImage, tr, null);
        }
    }

    public void dispose() {
        this.file.getView().removeViewListener(this);
        this.file.getSelection().removeSelectionListener(this.selectionListener);
    }

    class SelectionListener
    extends SelectionAdapter {
        SelectionListener() {
        }

        public void selectionChanged(SelectionInfo selectionInfo, ISelection oldSelection, ISelection newSelection, boolean isAdjusting) {
            TimeLinePanel.this.refresh();
        }

        public void cursorPositionChanged(SelectionInfo selectionInfo) {
            TimeLinePanel.this.refresh();
        }
    }
}

