/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file;

import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.AudioFileViewListener;
import ch.tachyon.sonics.data.view.ChannelViewType;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.BitSet;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.ILafListener;
import org.corebounce.common.utils.IDisposable;

public class VerticalAxisPanel
extends JPanel
implements AudioFileViewListener,
ILafListener,
IDisposable {
    private static final int LABEL_X_OFFSET = 6;
    private static final int LABEL_HEIGHT = 12;
    private static final int LABEL_Y_OFFSET = 4;
    private static final int BORDER_SIZE = 2;
    private static final int MINOR_LABEL_MIN_SPACE = 16;
    private static final int MAJOR_LABEL_MIN_SPACE = 40;
    private static final Color MAJOR_TICK_COLOR = Color.black;
    private static final Color MINOR_TICK_COLOR = Color.darkGray;
    private static final float ZOOM_RATIO_PER_PIXEL = 1.01f;
    private final Session session;
    private final AudioChannel channel;
    private Map<?, ?> textRenderingHints;
    private Font font;
    private Image cacheImage;
    private int cacheWidth;
    private int cacheHeight;
    private Color background;
    private Color majorTickColor;
    private Color minorTickColor;
    private float floor = -1.0f;
    private float ceil = 1.0f;
    private ChannelViewType viewType;
    private double majorRes;
    private double minorRes;
    private String pattern;
    private boolean dragging = false;
    private boolean zooming = false;
    private float zoomMiddle = 0.0f;
    private int lastY;
    private float startFloor;
    private float startCeil;
    private String lastPattern = "";
    private int lastPreferredWidth = 0;

    public VerticalAxisPanel(Session session, AudioChannel channel) {
        this.session = session;
        this.channel = channel;
        this.viewType = channel.getFile().getView().getViewType();
        this.setOpaque(true);
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.textRenderingHints = (Map)tk.getDesktopProperty("awt.font.desktophints");
        this.setBorder(new BevelBorder(0));
        channel.getFile().getView().addViewListener(this);
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.updateTooltip();
        this.updateLaf();
        AwtTools.addPostLafListener(this);
    }

    public void lookAndFeelChanged(String lafClassName) {
        if (!this.isShowing()) {
            return;
        }
        this.updateLaf();
        this.refresh();
    }

    private void updateLaf() {
        AwtTools.invokeAndWait(new Runnable(){

            public void run() {
                VerticalAxisPanel.this.font = VerticalAxisPanel.this.getFont().deriveFont(11.0f);
                VerticalAxisPanel.this.background = AwtTools.backgroundColor(VerticalAxisPanel.this);
                VerticalAxisPanel.this.majorTickColor = AwtTools.foregroundColor(VerticalAxisPanel.this, "Label.foreground", MAJOR_TICK_COLOR);
                VerticalAxisPanel.this.minorTickColor = AwtTools.foregroundColor(VerticalAxisPanel.this, "Label.disabledForeground", MINOR_TICK_COLOR);
            }
        });
    }

    public Dimension getPreferredSize() {
        if (this.viewType == ChannelViewType.WAVEFORM) {
            this.updateResolutions(this.getHeight());
        } else {
            this.pattern = "00000";
        }
        if (!this.pattern.equals(this.lastPattern)) {
            this.lastPattern = this.pattern;
            String p = this.pattern;
            if (p.startsWith("#")) {
                p = p.substring(1);
            }
            p = "-" + p.replace('#', '0');
            Graphics g = this.getGraphics();
            g.setFont(g.getFont().deriveFont(1));
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(p, g);
            this.lastPreferredWidth = (int)(bounds.getWidth() + 0.99) + 6 + 2;
        }
        return new Dimension(this.lastPreferredWidth, 10);
    }

    public void viewChanged(AudioDataView view) {
        boolean changes = this.floor != view.getVerticalFloor() || this.ceil != view.getVerticalCeil() || this.viewType != view.getViewType();
        this.floor = view.getVerticalFloor();
        this.ceil = view.getVerticalCeil();
        this.viewType = view.getViewType();
        if (changes) {
            this.refresh();
            this.updateTooltip();
        }
    }

    public void channelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
    }

    private void updateTooltip() {
        final StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html><body><b>");
        if (this.viewType == ChannelViewType.WAVEFORM) {
            tooltip.append("Amplitude");
        } else {
            tooltip.append("Frequency in Hz");
        }
        tooltip.append("</b>");
        tooltip.append("<p>Left-click and drag to move");
        tooltip.append("<p>Right-click and drag to zoom in/out");
        tooltip.append("<p>Double-click to normalize");
        tooltip.append("</body></html>");
        AwtTools.invokeInSwing(new Runnable(){

            public void run() {
                VerticalAxisPanel.this.setToolTipText(tooltip.toString());
            }
        });
    }

    private void selectFile() {
        this.session.setCurrentFile(this.channel.getFile());
    }

    private void fitHeight() {
        this.channel.getFile().getView().setVerticalRange(1.0f, -1.0f);
    }

    private synchronized Image cacheImage(boolean renderIfCreated) {
        if (this.cacheImage == null || this.cacheHeight != this.getHeight() || this.cacheWidth != this.getWidth() - 4) {
            this.cacheWidth = this.getWidth() - 4;
            this.cacheHeight = this.getHeight();
            this.cacheImage = this.createImage(this.cacheWidth, this.cacheHeight);
            if (this.cacheImage != null && renderIfCreated) {
                Graphics2D gc = (Graphics2D)this.cacheImage.getGraphics();
                this.render(this.getWidth() - 4, this.getHeight(), gc);
            }
        }
        return this.cacheImage;
    }

    private void refresh() {
        Image cacheImage = this.cacheImage(false);
        if (cacheImage == null) {
            return;
        }
        Graphics2D gc = (Graphics2D)cacheImage.getGraphics();
        this.refresh(gc, 0, this.getWidth());
    }

    private void refresh(Graphics2D gc, int startX, int stopX) {
        gc.setClip(startX, 0, stopX - startX, this.getHeight());
        this.render(this.getWidth() - 4, this.getHeight(), gc);
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Image cacheImage = this.cacheImage(true);
        if (cacheImage != null) {
            g.drawImage(cacheImage, 2, 0, null);
        }
    }

    private void updateResolutions(int height) {
        double span = this.ceil - this.floor;
        double tryRes = 1.0;
        double labelSpace = (double)height / (span / tryRes);
        int cycle = 0;
        this.majorRes = tryRes;
        this.pattern = "#0.";
        while (labelSpace > 40.0) {
            this.majorRes = tryRes;
            if (cycle == 0) {
                tryRes /= 2.0;
            } else if (cycle == 1) {
                tryRes = tryRes * 2.0 / 5.0;
                this.pattern = String.valueOf(this.pattern) + "#";
            } else {
                tryRes /= 2.0;
            }
            cycle = (cycle + 1) % 3;
            labelSpace = (double)height / (span / tryRes);
        }
        if (this.pattern.length() >= 7) {
            this.pattern = this.pattern.substring(2);
        }
        this.minorRes = cycle == 0 ? this.majorRes / 4.0 : (cycle == 1 ? this.majorRes / 5.0 : this.majorRes / 5.0);
    }

    private void render(int width, int height, Graphics2D g) {
        AudioFile file = this.channel.getFile();
        if (!this.session.isOpened(file)) {
            return;
        }
        g.setColor(this.background);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setFont(this.font);
        if (this.textRenderingHints != null) {
            g.setRenderingHints(this.textRenderingHints);
        }
        if (this.viewType == ChannelViewType.WAVEFORM) {
            this.renderWave(width, height, g);
        } else {
            this.renderFrequency(width, height, g);
        }
        g.dispose();
    }

    private void renderWave(int width, int height, Graphics2D g) {
        int yPos;
        int yPos2;
        double span = this.ceil - this.floor;
        this.updateResolutions(height);
        double y = Math.floor((double)this.floor / this.minorRes) * this.minorRes;
        while ((yPos2 = (int)((y - (double)this.floor) * (double)height / span + 0.5)) <= height + 1) {
            yPos2 = height - yPos2;
            g.setColor(this.minorTickColor);
            g.fillRect(0, yPos2, 3, 1);
            y += this.minorRes;
        }
        DecimalFormat format = new DecimalFormat(this.pattern);
        y = Math.floor((double)this.floor / this.majorRes) * this.majorRes;
        while ((yPos = (int)((y - (double)this.floor) * (double)height / span + 0.5)) <= height + 12) {
            yPos = height - yPos;
            String label = format.format(y);
            g.setColor(this.majorTickColor);
            g.fillRect(0, yPos - 1, 5, 3);
            g.drawString(label, 6, yPos + 4);
            y += this.majorRes;
        }
    }

    private void renderFrequency(int width, int height, Graphics2D g) {
        int[] FreqSteps = new int[]{10000, 5000, 2500, 1000, 500, 250, 100, 50, 25, 10, 5, 1};
        float sampleRate = this.channel.getFile().getSampleRate();
        float maxFreq = sampleRate / 2.0f;
        float midFreq = this.viewType == ChannelViewType.SPECTROGRAM ? (float)Math.pow(maxFreq, 0.7) : (float)Math.pow(maxFreq, 0.76);
        BitSet usedPixelsCoarse = new BitSet(height);
        BitSet usedPixelsFine = new BitSet(height);
        int[] nArray = FreqSteps;
        int n = FreqSteps.length;
        int n2 = 0;
        while (n2 < n) {
            int freqStep = nArray[n2];
            int freq = 0;
            while ((float)freq < maxFreq) {
                int yPos;
                float f0 = freq;
                if (this.viewType == ChannelViewType.CEPSTROGRAM) {
                    f0 /= sampleRate;
                    f0 = 1.0f / (4096.0f * f0);
                } else {
                    f0 /= sampleRate;
                }
                float vertPos = this.freqToPos(f0 * 2.0f, midFreq, maxFreq);
                if (this.viewType == ChannelViewType.CEPSTROGRAM) {
                    vertPos = 1.0f - vertPos;
                }
                if ((yPos = this.posToY(vertPos, height)) >= 0 && yPos < height) {
                    int yMaxFine;
                    int yMinCoarse = Math.max(0, yPos - 20);
                    int yMaxCoarse = Math.min(height, yPos + 20);
                    int yMinFine = Math.max(0, yPos - 8);
                    if (usedPixelsFine.get(yMinFine, yMaxFine = Math.min(height, yPos + 8)).isEmpty()) {
                        usedPixelsFine.set(yMinFine, yMaxFine);
                        yPos = height - yPos;
                        if (usedPixelsCoarse.get(yMinCoarse, yMaxCoarse).isEmpty()) {
                            g.setColor(this.majorTickColor);
                            g.fillRect(0, yPos - 1, 5, 3);
                            g.setFont(g.getFont().deriveFont(1));
                            usedPixelsCoarse.set(yMinCoarse, yMaxCoarse);
                        } else {
                            g.setColor(this.minorTickColor);
                            g.fillRect(0, yPos, 3, 1);
                            g.setFont(g.getFont().deriveFont(0));
                            g.setColor(this.majorTickColor);
                        }
                        String label = String.valueOf(freq);
                        g.drawString(label, 6, yPos + 4);
                    }
                }
                freq += freqStep;
            }
            ++n2;
        }
    }

    private int posToY(float vertPos, int height) {
        vertPos = vertPos * 2.0f - 1.0f;
        return (int)((vertPos - this.floor) * (float)height / (this.ceil - this.floor) + 0.5f);
    }

    private float freqToPos(float f, float midFreq, float maxFreq) {
        float base = maxFreq / midFreq * (maxFreq / midFreq);
        float result = (float)(Math.log((double)f * ((double)base - 1.0) + 1.0) / Math.log(base));
        return result;
    }

    public void dispose() {
        this.channel.getFile().getView().removeViewListener(this);
    }

    class MyMouseAdapter
    implements MouseListener,
    MouseMotionListener {
        MyMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (AwtTools.isLeftButton(e)) {
                VerticalAxisPanel.this.selectFile();
                if (e.getClickCount() == 2) {
                    VerticalAxisPanel.this.fitHeight();
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            if (AwtTools.isLeftButton(e)) {
                if (VerticalAxisPanel.this.zooming) {
                    this.cancelDragOrZoom();
                    return;
                }
                VerticalAxisPanel.this.lastY = e.getY();
                AudioDataView view = VerticalAxisPanel.this.channel.getFile().getView();
                VerticalAxisPanel.this.startFloor = view.getVerticalFloor();
                VerticalAxisPanel.this.startCeil = view.getVerticalCeil();
                VerticalAxisPanel.this.dragging = true;
                VerticalAxisPanel.this.selectFile();
            } else if (AwtTools.isRightButton(e)) {
                if (VerticalAxisPanel.this.dragging) {
                    this.cancelDragOrZoom();
                    return;
                }
                VerticalAxisPanel.this.lastY = e.getY();
                AudioDataView view = VerticalAxisPanel.this.channel.getFile().getView();
                VerticalAxisPanel.this.startFloor = view.getVerticalFloor();
                VerticalAxisPanel.this.startCeil = view.getVerticalCeil();
                VerticalAxisPanel.this.zoomMiddle = VerticalAxisPanel.this.channel.getView().getVerticalCeil() - VerticalAxisPanel.this.channel.getView().getPanel().toVertOffset(VerticalAxisPanel.this.lastY);
                VerticalAxisPanel.this.zooming = true;
                VerticalAxisPanel.this.selectFile();
            } else if (VerticalAxisPanel.this.dragging || VerticalAxisPanel.this.zooming) {
                this.cancelDragOrZoom();
                VerticalAxisPanel.this.selectFile();
            }
        }

        private void cancelDragOrZoom() {
            VerticalAxisPanel.this.channel.getFile().getView().setVerticalRange(VerticalAxisPanel.this.startCeil, VerticalAxisPanel.this.startFloor);
            VerticalAxisPanel.this.dragging = false;
            VerticalAxisPanel.this.zooming = false;
            AwtTools.getWindow(VerticalAxisPanel.this).setCursor(null);
        }

        public void mouseDragged(MouseEvent e) {
            if (VerticalAxisPanel.this.dragging) {
                AwtTools.getWindow(VerticalAxisPanel.this).setCursor(Cursor.getPredefinedCursor(13));
                int newY = e.getY();
                int deltaY = newY - VerticalAxisPanel.this.lastY;
                if (deltaY != 0) {
                    float offset = VerticalAxisPanel.this.channel.getView().getPanel().toVertOffset(deltaY);
                    VerticalAxisPanel.this.channel.getFile().getView().scrollVertical(offset);
                }
                VerticalAxisPanel.this.lastY = newY;
            } else if (VerticalAxisPanel.this.zooming) {
                int newY = e.getY();
                int deltaY = newY - VerticalAxisPanel.this.lastY;
                if (deltaY != 0) {
                    if (deltaY > 0) {
                        AwtTools.getWindow(VerticalAxisPanel.this).setCursor(Cursor.getPredefinedCursor(9));
                    } else {
                        AwtTools.getWindow(VerticalAxisPanel.this).setCursor(Cursor.getPredefinedCursor(8));
                    }
                    float zoomAmount = (float)Math.pow(1.01f, deltaY);
                    AudioDataView view = VerticalAxisPanel.this.channel.getFile().getView();
                    float ceil = view.getVerticalCeil();
                    float floor = view.getVerticalFloor();
                    float range = ceil - floor;
                    float middle = (ceil + floor) / 2.0f;
                    float ceilAmount = (ceil - VerticalAxisPanel.this.zoomMiddle) * 2.0f / range;
                    float floorAmount = (VerticalAxisPanel.this.zoomMiddle - floor) * 2.0f / range;
                    float ceilRange = (float)((double)range * Math.pow(zoomAmount, ceilAmount));
                    float floorRange = (float)((double)range * Math.pow(zoomAmount, floorAmount));
                    view.setVerticalRange(middle + ceilRange / 2.0f, middle - floorRange / 2.0f);
                }
                VerticalAxisPanel.this.lastY = newY;
            }
        }

        public void mouseReleased(MouseEvent e) {
            VerticalAxisPanel.this.dragging = false;
            VerticalAxisPanel.this.zooming = false;
            AwtTools.getWindow(VerticalAxisPanel.this).setCursor(null);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

