/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.action;

import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.gui.file.FilePanel;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.corebounce.common.utils.IDisposable;
import org.corebounce.common.utils.IProgressMonitor;

public class SetCurrentFileAction
extends ActionBase
implements IDisposable {
    private final Session session;
    private final WeakReference<AudioFile> fileRef;
    private final SessionAdapter adapter;
    private JRadioButton fileNameRadio;
    private JLabel fileNameLabel;

    public SetCurrentFileAction(Session session, AudioFile file) {
        this.session = session;
        this.fileRef = new WeakReference<AudioFile>(file);
        this.setText(FilePanel.getDisplayedFileName(file));
        this.setTooltip(FilePanel.getDisplayedTooltip(file));
        this.adapter = new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                SetCurrentFileAction.this.setSelected0(audioFile);
            }

            public void fileAdded(Session session, AudioFile audioFile) {
                SetCurrentFileAction.this.setMultipleFiles(session.getFiles().size() > 1);
            }

            public void fileRemoved(Session session, AudioFile audioFile) {
                SetCurrentFileAction.this.setMultipleFiles(session.getFiles().size() > 1);
            }
        };
        session.addSessionListener(this.adapter);
    }

    public void init(JLabel fileNameLabel, JRadioButton fileNameRadio) {
        this.fileNameLabel = fileNameLabel;
        this.fileNameRadio = fileNameRadio;
        if (this.session.getCurrentFile() == this.fileRef.get()) {
            this.setSelected(true);
        }
        this.setMultipleFiles(this.session.getFiles().size() > 1);
    }

    public ActionDisplayType getDisplayType() {
        return ActionDisplayType.TOGGLE;
    }

    private void setSelected0(final AudioFile audioFile) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean selected = audioFile == SetCurrentFileAction.this.fileRef.get();
                SetCurrentFileAction.this.setSelected(selected);
                SetCurrentFileAction.this.fileNameRadio.setSelected(selected);
            }
        });
    }

    private void setMultipleFiles(final boolean value) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SetCurrentFileAction.this.fileNameLabel.setVisible(!value);
                SetCurrentFileAction.this.fileNameRadio.setVisible(value);
                SetCurrentFileAction.this.fileNameLabel.revalidate();
                SetCurrentFileAction.this.fileNameRadio.revalidate();
            }
        });
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        AudioFile file = (AudioFile)this.fileRef.get();
        if (this.session.getCurrentFile() == file) {
            this.setSelected0(file);
        } else {
            this.session.setCurrentFile(file);
        }
        return false;
    }

    public void dispose() {
        this.session.removeSessionListener(this.adapter);
    }
}

