/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view;

import ch.tachyon.sonics.action.transport.PlayStopAction;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.core.TransportAdapter;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.SessionListener;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioChannelListener;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.PlaybackListener;
import ch.tachyon.sonics.data.selection.SelectionAdapter;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.sonics.data.view.AudioChannelDataView;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.AudioFileViewListener;
import ch.tachyon.sonics.data.view.ChannelViewType;
import ch.tachyon.sonics.data.view.IAudioChannelPanel;
import ch.tachyon.sonics.gui.file.view.AudioChannelDataRange;
import ch.tachyon.sonics.gui.file.view.IChannelOfflineDataBuffer;
import ch.tachyon.sonics.gui.file.view.IRefreshObserver;
import ch.tachyon.sonics.gui.file.view.ViewDragger;
import ch.tachyon.sonics.gui.file.view.spectrogram.CepstrogramOfflineBuffer;
import ch.tachyon.sonics.gui.file.view.spectrogram.GradientType;
import ch.tachyon.sonics.gui.file.view.spectrogram.SpectrogramOfflineBuffer;
import ch.tachyon.sonics.gui.file.view.waveform.WaveCurveOfflineBuffer;
import ch.tachyon.sonics.gui.file.view.waveform.WaveFormOfflineBuffer;
import ch.tachyon.sonics.gui.selectors.TimeRangeSelector;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Monitor;
import ch.tachyon.tunnel.utils.ThreadUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.utils.IDisposable;
import org.corebounce.common.utils.InOut;
import org.corebounce.common.utils.Out;

public class AudioChannelDataPanel
extends JPanel
implements AudioChannelListener,
AudioFileViewListener,
IAudioChannelPanel,
Runnable,
IDisposable {
    private static final int SPECTROGRAM_44100_RESOLUTION = 4096;
    private static final GradientType SPECTROGRAM_GRADIENT = GradientType.RAINBOW;
    private static final int PAINT_INTERVAL = 500;
    private static final int MAX_SCROLL_RATIO = 40;
    private static final int MIN_PAINT_FRACTION = 12;
    private static final Color BACKGROUD_COLOR = Color.BLACK;
    private static final Color BUSY_COLOR = Color.darkGray;
    private static final Color CURSOR_COLOR = Color.WHITE;
    private static final Color PLAY_CURSOR_COLOR = Color.GREEN;
    private static final Color PAUSE_CURSOR_COLOR = Color.ORANGE;
    private static final Color SELECTION_BACKGROUND_COLOR = new Color(0.75f, 0.75f, 0.75f, 1.0f);
    private static final Color SELECTION_OVER_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.25f);
    private Session session;
    private AudioChannel audioChannel;
    private AudioChannelDataRange viewRange;
    private Reference<IChannelOfflineDataBuffer> bufferCache;
    private IChannelOfflineDataBuffer buffer;
    private long smearAmount;
    private boolean active;
    private ChannelViewType viewType;
    private int height = 180;
    private int currentWidth = -1;
    private Thread refresher;
    private Object refreshLock = new Monitor("refreshLock");
    private AudioChannelDataRange dirtyRange = null;
    private long dirtyStart = -1L;
    private long dirtyStop = -1L;
    private int scrollRequestPixel = 0;
    private long scrollRequestFile = 0L;
    private static final AtomicInteger nbRefreshing = new AtomicInteger();
    private boolean scrollingStable;
    private long lastCleanTime;
    private ViewDragger dragger;
    private TimeRangeSelector selector = new TimeRangeSelector();
    private boolean needsToFocus = false;
    private SessionListener sessionListener;
    private TransportAdapter transportAdapter;
    private int lastCursorX = -1;
    private int paintCursorX = -1;
    private int lastPlaybackX = -1;
    private int paintPlaybackX = -1;
    private PlayState playState = PlayState.STOP;
    private boolean playbackPaused = false;
    private final Object cursorLock = new Monitor("cursorLock");
    private long lastPaintTime = -1L;
    private int lastPaintX = -1;
    private boolean repaintDirtyRequested = false;
    private boolean refreshAfterScroll = false;
    private boolean fullRepaint = false;
    private volatile boolean paintedBusy = false;
    private boolean fileLocked = false;
    private final AtomicBoolean handlingPlaybackScroll = new AtomicBoolean(false);

    public AudioChannelDataPanel(Session session, AudioChannelDataView view, ChannelViewType viewType) {
        this.setOpaque(true);
        this.session = session;
        this.viewRange = new AudioChannelDataRange(view);
        this.audioChannel = view.getAudioChannel();
        this.viewType = viewType;
        this.active = session.getCurrentFile() == view.getAudioFile();
        this.sessionListener = new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                AudioChannelDataPanel.this.active = AudioChannelDataPanel.this.audioChannel != null && AudioChannelDataPanel.this.audioChannel.getFile() == audioFile;
                if (!AudioChannelDataPanel.this.active) {
                    AudioChannelDataPanel.this.buffer = null;
                }
            }
        };
        session.addSessionListener(this.sessionListener);
        this.dragger = new ViewDragger(this, this, view.getAudioFile());
        this.audioChannel.addAudioChannelListener(this);
        this.audioChannel.getFile().getView().addViewListener(this);
        SelectionInfo selectionInfo = this.audioChannel.getFile().getSelection();
        selectionInfo.addSelectionListener(new SelectionAdapter(){

            public void cursorPositionChanged(SelectionInfo selectionInfo) {
                AudioChannelDataPanel.this.cursorChanged(selectionInfo);
            }

            public void selectionChanged(SelectionInfo selectionInfo, ISelection oldSelection, ISelection newSelection, boolean isAdjusting) {
                AudioChannelDataPanel.this.selectionChanged(oldSelection, newSelection);
            }
        });
        selectionInfo.addPlaybackListener(new PlaybackListener(){

            public void playbackPositionChanged(SelectionInfo selectionInfo) {
                AudioChannelDataPanel.this.playbackCursorChanged(selectionInfo);
            }
        });
        this.transportAdapter = new TransportAdapter(){

            public void playStateChanged(Transport transport, PlayState oldPlayState, PlayState newPlayState) {
                AudioChannelDataPanel.this.playState = newPlayState;
                SelectionInfo selection = AudioChannelDataPanel.this.audioChannel.getFile().getSelection();
                AudioChannelDataPanel.this.repaintPlaybackCursor(selection);
            }
        };
        Transport.getInstance().addTransportAdapter(this.transportAdapter);
        this.refresher = new Thread((Runnable)this, "WaveForm Painter");
        this.refresher.setDaemon(true);
        this.refresher.start();
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (AudioChannelDataPanel.this.dragger.isDragViewEvent(e)) {
                    AudioChannelDataPanel.this.dragger.mouseReleased(e);
                } else {
                    AudioChannelDataPanel.this.selector.mouseReleased(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                AudioChannelDataPanel.this.selectChannel();
                if (AudioChannelDataPanel.this.dragger.isDragViewEvent(e)) {
                    AudioChannelDataPanel.this.dragger.mousePressed(e);
                } else {
                    AudioChannelDataPanel.this.selector.mousePressed(e);
                }
            }

            public void mouseClicked(MouseEvent e) {
                AudioChannelDataPanel.this.selectChannel();
                if (AudioChannelDataPanel.this.dragger.isDragViewEvent(e)) {
                    AudioChannelDataPanel.this.dragger.mouseClicked(e);
                } else {
                    AudioChannelDataPanel.this.selector.mouseClicked(e);
                }
            }

            public void mouseEntered(MouseEvent e) {
                AudioChannelDataPanel.this.needsToFocus = true;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                if (AudioChannelDataPanel.this.needsToFocus) {
                    AudioChannelDataPanel.this.focusChannel();
                }
                AudioChannelDataPanel.this.needsToFocus = false;
                AudioChannelDataPanel.this.selector.mouseMoved(e);
            }

            public void mouseDragged(MouseEvent e) {
                if (AudioChannelDataPanel.this.dragger.isDragViewEvent(e)) {
                    AudioChannelDataPanel.this.dragger.mouseDragged(e);
                } else {
                    AudioChannelDataPanel.this.selector.mouseDragged(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsRefresh(boolean ignoreScroll) {
        Object object = this.refreshLock;
        synchronized (object) {
            return this.dirtyStart >= 0L || this.dirtyStop >= 0L || !ignoreScroll && this.scrollRequestPixel != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirty(AudioChannelDataView view) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.dirtyRange = new AudioChannelDataRange(view);
            this.dirtyStart = this.dirtyRange.getStartPosition();
            this.dirtyStop = this.dirtyRange.getStopPosition();
            this.scrollRequestPixel = 0;
            this.scrollRequestFile = 0L;
            this.refreshLock.notify();
        }
    }

    private void markDirty() {
        this.markDirty(this.viewRange.getStartPosition(), this.viewRange.getStopPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirty(long startPos, long stopPos) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.dirtyStart = this.dirtyStart < 0L ? startPos : Math.min(this.dirtyStart, startPos);
            this.dirtyStop = this.dirtyStop < 0L ? stopPos : Math.max(this.dirtyStop, stopPos);
            this.refreshLock.notify();
        }
    }

    public void markUnpainted(AudioChannelDataView view) {
        this.viewRange.setVerticalCeil(view.getVerticalCeil());
        this.viewRange.setVerticalFloor(view.getVerticalFloor());
        IChannelOfflineDataBuffer buffer = this.buffer(false);
        if (buffer != null && buffer.verticalChange(false)) {
            this.markDirty();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scroll(AudioChannelDataView view, long fileOffset, int pixelOffset) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.dirtyRange = new AudioChannelDataRange(view);
            if (this.dirtyStart >= 0L || this.dirtyStop >= 0L) {
                this.dirtyStart = this.dirtyRange.getStartPosition();
                this.dirtyStop = this.dirtyRange.getStopPosition();
                this.scrollRequestPixel = 0;
                this.scrollRequestFile = 0L;
            } else {
                this.scrollRequestPixel += pixelOffset;
                this.scrollRequestFile += fileOffset;
            }
            this.refreshLock.notify();
        }
    }

    public float toVertOffset(int pixelValue) {
        float verticalRange = this.viewRange.getVerticalCeil() - this.viewRange.getVerticalFloor();
        return (float)pixelValue * verticalRange / (float)this.getHeight();
    }

    private int viewPosToXCoord(long viewPos, long viewStart, long viewStop, int width) {
        long viewRange = Math.max(1L, viewStop - viewStart);
        return (int)(((viewPos - viewStart) * (long)width + viewRange / 2L) / viewRange);
    }

    public int toXCoord(long position, int roundPos) {
        long viewStart = this.viewRange.getStartPosition();
        long viewStop = this.viewRange.getStopPosition();
        long viewRange = viewStop - viewStart;
        if (viewRange <= 0L) {
            return 0;
        }
        int width = this.getWidth();
        if (roundPos < 0) {
            return (int)((position - viewStart) * (long)width / viewRange);
        }
        if (roundPos == 0) {
            return (int)(((position - viewStart) * (long)width + viewRange / 2L) / viewRange);
        }
        return (int)(((position - viewStart) * (long)width + viewRange - 1L) / viewRange);
    }

    private double toXCoordD(long position) {
        long viewStart = this.viewRange.getStartPosition();
        long viewStop = this.viewRange.getStopPosition();
        long viewRange = viewStop - viewStart;
        int width = this.getWidth();
        double result = (double)((position - viewStart) * (long)width + viewRange / 2L) / (double)viewRange;
        if (result < 0.0) {
            result = 0.0;
        } else if (result > (double)width) {
            result = width;
        }
        return result;
    }

    public long fromXCoord(int xCoord, int roundPos) {
        int width = this.getWidth();
        int wh = width / 2;
        long viewLength = this.viewRange.getStopPosition() - this.viewRange.getStartPosition();
        if (roundPos < 0) {
            return this.viewRange.getStartPosition() + ((long)xCoord * viewLength + (long)wh) / (long)width;
        }
        if (roundPos == 0) {
            return this.viewRange.getStartPosition() + ((long)xCoord * viewLength + viewLength / 2L + (long)wh) / (long)width;
        }
        return this.viewRange.getStartPosition() + ((long)xCoord * viewLength + viewLength - 1L + (long)wh) / (long)width;
    }

    public int deltaToPixel(long viewDelta) {
        long viewStart = this.viewRange.getStartPosition();
        long viewStop = this.viewRange.getStopPosition();
        long viewRange = viewStop - viewStart;
        int width = this.getWidth();
        int xCoord = viewDelta > 0L ? (int)((viewDelta * (long)width + viewRange / 2L) / viewRange) : -((int)((-viewDelta * (long)width + viewRange / 2L) / viewRange));
        return xCoord;
    }

    public long deltaFromPixel(int xCoord) {
        long viewStart = this.viewRange.getStartPosition();
        long viewStop = this.viewRange.getStopPosition();
        long viewRange = viewStop - viewStart;
        int width = this.getWidth();
        long result = xCoord < 0 ? -((long)(-xCoord) * viewRange + (long)(width / 2)) / (long)width : ((long)xCoord * viewRange + (long)(width / 2)) / (long)width;
        return result;
    }

    public void viewChanged(AudioDataView view) {
        this.scrollingStable = false;
    }

    public void dataModified(AudioChannel channel, long startPos, long stopPos) {
        if ((startPos -= this.smearAmount) < 0L) {
            startPos = 0L;
        }
        if ((stopPos += this.smearAmount) > this.audioChannel.getLength()) {
            stopPos = this.audioChannel.getLength();
        }
        this.markDirty(startPos, stopPos);
    }

    public void channelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
        this.markDirty(Math.min(oldSize, newSize), Math.max(oldSize, newSize));
    }

    public void transactionStateChanged(AudioChannel channel, boolean running) {
    }

    public void viewTypeChanged(AudioDataView view, ChannelViewType viewType) {
    }

    public void setViewType(ChannelViewType viewType) {
        if (this.viewType.equals((Object)viewType)) {
            return;
        }
        this.viewType = viewType;
        this.markDirty();
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, this.height);
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
        IChannelOfflineDataBuffer buffer = this.buffer(false);
        if (buffer != null && buffer.verticalChange(true)) {
            this.markDirty();
        }
        this.revalidate();
    }

    protected void paintComponent(Graphics g1) {
        if (this.detectResizing(g1)) {
            return;
        }
        Graphics2D g = (Graphics2D)g1.create();
        g.setColor(BACKGROUD_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.prePaintSelection(g);
        this.paintAudioData(g);
        if (!this.paintedBusy) {
            this.postPaintSelection(g);
            this.paintCursor(g);
            this.paintPlaybackCursor(g);
        }
    }

    private boolean detectResizing(Graphics g1) {
        int width = this.getWidth();
        if (width != this.currentWidth) {
            g1.setColor(this.getBackground());
            g1.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.currentWidth = width;
            this.invalidateCursors();
            this.markDirty();
            return true;
        }
        return false;
    }

    private void paintAudioData(Graphics2D g) {
        IChannelOfflineDataBuffer buffer = this.buffer(true);
        Rectangle bounds = g.getClipBounds();
        int startX = bounds.x;
        int stopX = bounds.x + bounds.width;
        startX = Math.max(startX, 0);
        stopX = Math.min(stopX, buffer.getWidth());
        if (this.paintedBusy) {
            g.setColor(BUSY_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            buffer.paint(this.viewRange, g, startX, stopX, this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintCursor(Graphics2D g) {
        int cursorX = -1;
        Object object = this.cursorLock;
        synchronized (object) {
            cursorX = this.paintCursorX;
        }
        if (cursorX >= 0 && cursorX < this.getWidth()) {
            g.setColor(CURSOR_COLOR);
            g.fillRect(cursorX, 0, 1, this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPlaybackCursor(Graphics2D g) {
        boolean paused;
        int playBackX = -1;
        Object object = this.cursorLock;
        synchronized (object) {
            playBackX = this.paintPlaybackX;
            paused = this.playbackPaused;
        }
        if (playBackX >= 0) {
            if (paused) {
                g.setColor(PAUSE_CURSOR_COLOR);
            } else {
                g.setColor(PLAY_CURSOR_COLOR);
            }
            g.fillRect(playBackX, 0, 1, this.getHeight());
        }
    }

    private void prePaintSelection(Graphics2D g) {
        this.paintSelection(g, SELECTION_BACKGROUND_COLOR);
    }

    private void postPaintSelection(Graphics2D g) {
        this.paintSelection(g, SELECTION_OVER_COLOR);
    }

    private void paintSelection(Graphics2D g, Color color) {
        SelectionInfo info = this.audioChannel.getFile().getSelection();
        g.setColor(color);
        Rectangle2D.Double rect = new Rectangle2D.Double();
        int width = this.getWidth();
        for (ISelection selection : info.getSelections()) {
            if (!(selection instanceof TimeRangeSelection)) continue;
            TimeRangeSelection trSelection = (TimeRangeSelection)selection;
            double minX = this.toXCoordD(trSelection.getStartPosition());
            double maxX = this.toXCoordD(trSelection.getStopPosition());
            if (minX <= 0.0 && maxX >= (double)width) {
                g.fillRect(0, 0, width, this.height);
                continue;
            }
            if (!(maxX > minX)) continue;
            rect.setFrame(minX, 0.0, maxX - minX, this.getHeight());
            g.fill(rect);
        }
    }

    private void flushPreviousBuffer() {
        IChannelOfflineDataBuffer previous = this.buffer;
        if (previous == null && this.bufferCache != null) {
            previous = this.bufferCache.get();
        }
        if (previous != null) {
            previous.dispose();
        }
    }

    private synchronized IChannelOfflineDataBuffer buffer(boolean checkType) {
        IChannelOfflineDataBuffer result = this.buffer;
        if (result == null && this.bufferCache != null) {
            result = this.bufferCache.get();
        }
        if (result == null || checkType) {
            int width = this.getWidth();
            float sampleRate = this.audioChannel.getFile().getSampleRate();
            if (sampleRate < 4000.0f) {
                sampleRate = 4000.0f;
            } else if (sampleRate > 192000.0f) {
                sampleRate = 192000.0f;
            }
            int resolution = AudioMath.adjustPowerOf2(4096, 44100.0f, sampleRate);
            if (this.viewType.equals((Object)ChannelViewType.WAVEFORM)) {
                if (this.viewRange.getStopPosition() - this.viewRange.getStartPosition() >= (long)width) {
                    if (!(result instanceof WaveFormOfflineBuffer) || result.getWidth() != width) {
                        this.flushPreviousBuffer();
                        result = new WaveFormOfflineBuffer(width, this.getBackground(), BUSY_COLOR);
                        this.markDirty();
                    }
                } else if (!(result instanceof WaveCurveOfflineBuffer) || result.getWidth() != width) {
                    this.flushPreviousBuffer();
                    result = new WaveCurveOfflineBuffer(width);
                    this.markDirty();
                }
            } else if (this.viewType.equals((Object)ChannelViewType.SPECTROGRAM)) {
                if (result == null || !result.getClass().equals(SpectrogramOfflineBuffer.class) || result.getWidth() != width) {
                    this.flushPreviousBuffer();
                    result = new SpectrogramOfflineBuffer(width, resolution, this.audioChannel.getFile().getSampleRate(), true, SPECTROGRAM_GRADIENT, this.getBackground(), BUSY_COLOR);
                    this.markDirty();
                }
            } else if (this.viewType.equals((Object)ChannelViewType.CEPSTROGRAM)) {
                if (!(result instanceof CepstrogramOfflineBuffer) || result.getWidth() != width) {
                    this.flushPreviousBuffer();
                    result = new CepstrogramOfflineBuffer(width, resolution, this.audioChannel.getFile().getSampleRate(), true, SPECTROGRAM_GRADIENT, this.getBackground(), BUSY_COLOR);
                    this.markDirty();
                }
            } else {
                throw new IllegalStateException("Unsupported view type " + (Object)((Object)this.viewType));
            }
            if (this.bufferCache == null || this.bufferCache.get() != result) {
                this.bufferCache = new SoftReference<IChannelOfflineDataBuffer>(result);
            }
            this.buffer = this.active ? result : null;
            this.smearAmount = result.getSmearAmount();
        }
        return result;
    }

    public void run() {
        block16: {
            nbRefreshing.incrementAndGet();
            try {
                while (true) {
                    try {
                        block17: {
                            RefreshData rd = new RefreshData();
                            boolean interrupted = this.waitForRefreshNotification(rd);
                            if (interrupted) break block16;
                            nbRefreshing.decrementAndGet();
                            boolean success = this.lockFile();
                            if (success) break block17;
                            this.repaintAsBusy(rd);
                            Debug.info((String)"Could not refresh", (Object[])new Object[0]);
                            nbRefreshing.incrementAndGet();
                            continue;
                        }
                        try {
                            try {
                                this.paintedBusy = false;
                            }
                            catch (InterruptedException ex) {
                                nbRefreshing.incrementAndGet();
                                this.unlockFile();
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            nbRefreshing.incrementAndGet();
                        }
                    }
                    finally {
                        this.unlockFile();
                        continue;
                    }
                    break;
                }
            }
            finally {
                nbRefreshing.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForRefreshNotification(@Out RefreshData rd) {
        Object object = this.refreshLock;
        synchronized (object) {
            while (true) {
                if (this.needsRefresh(false)) {
                    if (this.dirtyRange != null) {
                        this.viewRange = this.dirtyRange;
                        this.dirtyRange = null;
                        rd.invalidateCursors = true;
                    }
                    rd.dirtyStart = this.dirtyStart;
                    rd.dirtyStop = this.dirtyStop;
                    rd.scrollDeltaPixel = -this.scrollRequestPixel;
                    rd.scrollDeltaFile = -this.scrollRequestFile;
                    this.dirtyStart = -1L;
                    this.dirtyStop = -1L;
                    this.scrollRequestPixel = 0;
                    this.scrollRequestFile = 0L;
                    this.refreshLock.notify();
                    return false;
                }
                nbRefreshing.decrementAndGet();
                try {
                    try {
                        this.refreshLock.wait();
                    }
                    catch (InterruptedException ex) {
                        nbRefreshing.incrementAndGet();
                        return true;
                    }
                }
                finally {
                    nbRefreshing.incrementAndGet();
                }
                this.lastCleanTime = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintAsBusy(RefreshData rd) {
        if (!this.paintedBusy) {
            this.paintedBusy = true;
            this.repaint(0, 0, this.getWidth(), this.height);
        }
        Object object = this.refreshLock;
        synchronized (object) {
            this.markDirty();
        }
    }

    private void processScrolling(@InOut RefreshData rd, long viewStart, long viewStop) {
        IChannelOfflineDataBuffer buffer = this.buffer(false);
        boolean success = false;
        if (buffer != null) {
            success = buffer.scroll(rd.scrollDeltaPixel);
        }
        if (!success) {
            rd.dirtyStart = viewStart;
            rd.dirtyStop = viewStop;
        } else {
            if (rd.dirtyStart < 0L && rd.dirtyStop < 0L && Math.abs(rd.scrollDeltaPixel) < this.getWidth() / 4) {
                this.refreshAfterScroll = true;
            }
            if (rd.scrollDeltaFile > 0L) {
                rd.dirtyStart = viewStart;
                rd.dirtyStop = rd.dirtyStop < 0L ? viewStart + rd.scrollDeltaFile : Math.max(rd.dirtyStop, viewStart + rd.scrollDeltaFile);
            } else {
                rd.dirtyStop = viewStop;
                rd.dirtyStart = rd.dirtyStart < 0L ? viewStop + rd.scrollDeltaFile : Math.min(rd.dirtyStart, viewStop + rd.scrollDeltaFile);
            }
            this.fullRepaint = true;
        }
    }

    private void processRefresh(long dirtyStart, long dirtyStop, long viewStart, long viewStop) {
        assert (dirtyStart >= 0L && dirtyStop >= 0L);
        dirtyStart = Math.max(dirtyStart, viewStart);
        if ((dirtyStop = Math.min(dirtyStop, viewStop)) > dirtyStart) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width <= 0 || height <= 0 || this.currentWidth <= 0 || !this.isShowing()) {
                return;
            }
            IChannelOfflineDataBuffer buffer = this.buffer(true);
            int startX = this.toXCoord(dirtyStart, -1);
            int stopX = this.toXCoord(dirtyStop, 1);
            if ((startX = Math.max(startX, 0)) >= (stopX = Math.min(stopX, buffer.getWidth()))) {
                return;
            }
            long stopPos = dirtyStop;
            float reduction = (float)((double)(viewStop - viewStart) / (double)width);
            buffer.markDirty(startX, stopX);
            if ((System.currentTimeMillis() > this.lastCleanTime + 500L || AudioChannelDataView.fileAccessLock.isLocked()) && stopX - startX > width / 4) {
                this.repaint(startX, 0, stopX - startX + 1, height);
            } else {
                this.repaintDirtyRequested = true;
            }
            try {
                AudioChannelDataView.fileAccessLock.lock();
                this.refreshAudio(viewStart, width, height, buffer, startX, stopX, stopPos, reduction);
            }
            finally {
                AudioChannelDataView.fileAccessLock.unlock();
            }
        }
    }

    private void refreshAudio(long viewStart, int width, int height, IChannelOfflineDataBuffer buffer, int startX, int stopX, final long stopPos, float reduction) {
        this.lastPaintX = startX;
        this.lastPaintTime = System.currentTimeMillis();
        try {
            final int dirtyStopX = stopX;
            final int minWidth = width / 12;
            buffer.refresh(this.audioChannel, this.viewRange, startX, stopX, viewStart, reduction, height, new IRefreshObserver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean refreshed(IChannelOfflineDataBuffer cdBuffer, int x, long pos, boolean repaintDirty) {
                    Object object = AudioChannelDataPanel.this.refreshLock;
                    synchronized (object) {
                        if (AudioChannelDataPanel.this.needsRefresh(AudioChannelDataPanel.this.refreshAfterScroll)) {
                            if (AudioChannelDataPanel.this.scrollRequestPixel == 0) {
                                AudioChannelDataPanel.this.markDirty(pos, stopPos);
                            } else {
                                AudioChannelDataPanel.this.markDirty();
                            }
                            return false;
                        }
                    }
                    AudioChannelDataPanel audioChannelDataPanel = AudioChannelDataPanel.this;
                    audioChannelDataPanel.repaintDirtyRequested = audioChannelDataPanel.repaintDirtyRequested | repaintDirty;
                    long now = System.currentTimeMillis();
                    if (now >= AudioChannelDataPanel.this.lastPaintTime + 500L && x - AudioChannelDataPanel.this.lastPaintX >= minWidth) {
                        if (AudioChannelDataPanel.this.repaintDirtyRequested) {
                            AudioChannelDataPanel.this.repaint(AudioChannelDataPanel.this.lastPaintX, 0, dirtyStopX - AudioChannelDataPanel.this.lastPaintX, AudioChannelDataPanel.this.getHeight());
                            AudioChannelDataPanel.this.repaintDirtyRequested = false;
                        } else {
                            AudioChannelDataPanel.this.repaint(AudioChannelDataPanel.this.lastPaintX, 0, x - AudioChannelDataPanel.this.lastPaintX + 1, AudioChannelDataPanel.this.getHeight());
                        }
                        AudioChannelDataPanel.this.lastPaintX = x;
                        AudioChannelDataPanel.this.lastPaintTime = now;
                    }
                    return true;
                }
            });
            if (this.fullRepaint) {
                this.repaint();
            } else {
                this.repaint(this.lastPaintX, 0, stopX - this.lastPaintX + 1, this.getHeight());
            }
            this.refreshAfterScroll = false;
            this.fullRepaint = false;
        }
        catch (Throwable ex) {
            Debug.error((Throwable)ex);
        }
    }

    private boolean lockFile() throws InterruptedException {
        if (!this.fileLocked) {
            String owner = this.audioChannel.getFile().lockReadWait("Refreshing display", 500L);
            if (owner != null) {
                return false;
            }
            this.fileLocked = true;
        }
        return true;
    }

    private void unlockFile() {
        if (this.fileLocked) {
            this.audioChannel.getFile().unlockRead("Refreshing display");
            this.fileLocked = false;
        }
    }

    private void selectChannel() {
        this.session.setCurrentFile(this.audioChannel.getFile());
        this.selector.setCurrentChannel(this.audioChannel);
        PlayStopAction.requestFocus();
    }

    private void focusChannel() {
        this.session.setFocusedFile(this.audioChannel.getFile());
        this.selector.setCurrentChannel(this.audioChannel);
        this.needsToFocus = false;
    }

    private void invalidateCursors() {
        SelectionInfo sInfo = this.audioChannel.getFile().getSelection();
        this.cursorChanged(sInfo);
        this.playbackCursorChanged(sInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cursorChanged(SelectionInfo selectionInfo) {
        CursorDetails cd = this.cursorPositionChanged(selectionInfo.getCursorPosition(), this.lastCursorX, false);
        if (cd != null) {
            Object object = this.cursorLock;
            synchronized (object) {
                this.paintCursorX = cd.newX;
                this.lastCursorX = cd.newX;
                this.repaint(cd.minX, 0, cd.maxX - cd.minX + 1, this.getHeight());
            }
        }
    }

    public void playbackCursorChanged(SelectionInfo selectionInfo) {
        if (nbRefreshing.get() > 0 && this.playState == PlayState.PLAY) {
            return;
        }
        if (this.followPlaybackCursorIfWorth(selectionInfo)) {
            return;
        }
        this.moveToNextPageIfWorth(selectionInfo);
        this.scrollingStable = false;
        this.repaintPlaybackCursor(selectionInfo);
    }

    private boolean followPlaybackCursorIfWorth(SelectionInfo selectionInfo) {
        if (!Transport.getInstance().isScrolling()) {
            return false;
        }
        if (selectionInfo.getPlaybackPosition() >= 0L && this.playState != PlayState.PAUSE) {
            boolean isFirstChan;
            boolean bl = isFirstChan = this.audioChannel.getFile().getData().getChannel(0, true) == this.audioChannel;
            if (nbRefreshing.get() == 0 && this.handlingPlaybackScroll.compareAndSet(false, true)) {
                boolean smallEnough;
                int maxSkew = this.currentWidth / 3;
                int maxScroll = this.currentWidth / 40;
                long curStart = this.viewRange.getStartPosition();
                long curStop = this.viewRange.getStopPosition();
                long curPos = (curStart + curStop * 2L) / 3L;
                long newPos = selectionInfo.getPlaybackPosition();
                int curXPos = this.currentWidth * 2 / 3;
                int newXPos = this.toXCoord(newPos, 0);
                int deltaX = newXPos - curXPos;
                boolean wasStable = this.scrollingStable;
                this.scrollingStable = true;
                if (deltaX > maxScroll && deltaX <= maxSkew) {
                    newXPos = curXPos + maxScroll;
                    newPos = this.fromXCoord(newXPos, 0);
                    this.repaintPlaybackCursor(selectionInfo);
                    this.scrollingStable = false;
                }
                long lastPos = this.audioChannel.getFileLength();
                if (Transport.getInstance().isSelectionOnly() && !selectionInfo.isEmpty()) {
                    lastPos = selectionInfo.getBoundingStopPosition();
                }
                boolean inRange = curStop + (newPos - curPos) < lastPos;
                boolean bl2 = smallEnough = deltaX > 0 && deltaX <= maxSkew;
                if (inRange && smallEnough && !SwingUtilities.isEventDispatchThread()) {
                    boolean otherChanges = this.playbackPaused ^ this.playState == PlayState.PAUSE;
                    if (otherChanges) {
                        this.repaintPlaybackCursor(selectionInfo);
                    }
                    if (this.scrollingStable && !wasStable) {
                        this.lastPlaybackX = this.paintPlaybackX = this.getWidth() * 2 / 3;
                    }
                    if (!isFirstChan) {
                        this.handlingPlaybackScroll.set(false);
                        return true;
                    }
                    final long delta = newPos - curPos;
                    AwtTools.invokeInSwing(new Runnable(){

                        public void run() {
                            AudioChannelDataPanel.this.audioChannel.getView().getAudioFile().getView().scroll(delta);
                            AudioChannelDataPanel.this.handlingPlaybackScroll.set(false);
                        }
                    });
                    return true;
                }
                this.handlingPlaybackScroll.set(false);
            } else {
                return true;
            }
        }
        return false;
    }

    private void moveToNextPageIfWorth(SelectionInfo selectionInfo) {
        if (Transport.getInstance().isScrolling()) {
            return;
        }
        if (selectionInfo.getPlaybackPosition() >= 0L && this.playState != PlayState.PAUSE) {
            boolean isFirstChan;
            boolean bl = isFirstChan = this.audioChannel.getFile().getData().getChannel(0, true) == this.audioChannel;
            if (nbRefreshing.get() == 0 && this.handlingPlaybackScroll.compareAndSet(false, true)) {
                boolean timeToPage;
                int maxSkew = this.currentWidth + this.currentWidth / 3;
                long curStart = this.viewRange.getStartPosition();
                long curStop = this.viewRange.getStopPosition();
                long newPos = selectionInfo.getPlaybackPosition();
                int newXPos = this.toXCoord(newPos, 0);
                long lastPos = this.audioChannel.getFileLength();
                if (Transport.getInstance().isSelectionOnly() && !selectionInfo.isEmpty()) {
                    lastPos = selectionInfo.getBoundingStopPosition();
                }
                boolean inRange = curStop < lastPos;
                boolean bl2 = timeToPage = newPos >= curStop && newXPos <= maxSkew;
                if (inRange && timeToPage && !SwingUtilities.isEventDispatchThread()) {
                    if (!isFirstChan) {
                        this.handlingPlaybackScroll.set(false);
                        return;
                    }
                    newPos = curStop;
                    if (curStart > lastPos) {
                        newPos = lastPos - curStop + curStart;
                    }
                    final long delta = newPos - curStart;
                    AwtTools.invokeInSwing(new Runnable(){

                        public void run() {
                            AudioChannelDataPanel.this.audioChannel.getView().getAudioFile().getView().scroll(delta);
                            AudioChannelDataPanel.this.handlingPlaybackScroll.set(false);
                        }
                    });
                    return;
                }
                this.handlingPlaybackScroll.set(false);
            } else {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintPlaybackCursor(SelectionInfo selectionInfo) {
        boolean otherChanges = this.playbackPaused ^ this.playState == PlayState.PAUSE;
        CursorDetails cd = this.cursorPositionChanged(selectionInfo.getPlaybackPosition(), this.lastPlaybackX, otherChanges);
        if (cd != null) {
            Object object = this.cursorLock;
            synchronized (object) {
                this.paintPlaybackX = cd.newX;
                this.lastPlaybackX = cd.newX;
                this.playbackPaused = this.playState == PlayState.PAUSE;
                this.repaint(cd.minX, 0, cd.maxX - cd.minX + 1, this.getHeight());
            }
        }
    }

    private CursorDetails cursorPositionChanged(long position, int lastX, boolean otherChanges) {
        int width = this.getWidth();
        long viewStart = this.viewRange.getStartPosition();
        long viewStop = this.viewRange.getStopPosition();
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int newX = -1;
        if (position >= 0L) {
            newX = this.viewPosToXCoord(position, viewStart, viewStop, width);
            if (newX == lastX && !otherChanges) {
                return null;
            }
            minX = Math.min(minX, newX);
            maxX = Math.max(maxX, newX);
        }
        if (lastX >= 0) {
            minX = Math.min(minX, lastX);
            maxX = Math.max(maxX, lastX);
        }
        if ((minX = Math.max(minX, 0)) <= (maxX = Math.min(maxX, width)) || otherChanges) {
            return new CursorDetails(minX, maxX, newX);
        }
        return null;
    }

    private void selectionChanged(ISelection oldSelection, ISelection newSelection) {
        int width;
        if (oldSelection == null && newSelection == null) {
            this.repaint();
            return;
        }
        int minX = width = this.getWidth();
        if (oldSelection != null) {
            minX = Math.min(minX, this.toXCoord(oldSelection.getBoundingStartPosition(), -1));
        }
        if (newSelection != null) {
            minX = Math.min(minX, this.toXCoord(newSelection.getBoundingStartPosition(), -1));
        }
        if (minX < 0) {
            minX = 0;
        }
        int maxX = 0;
        if (oldSelection != null) {
            maxX = Math.max(maxX, this.toXCoord(oldSelection.getBoundingStopPosition(), 1));
        }
        if (newSelection != null) {
            maxX = Math.max(maxX, this.toXCoord(newSelection.getBoundingStopPosition(), 1));
        }
        if (maxX > width) {
            maxX = width;
        }
        if (minX <= maxX) {
            this.repaint(minX, 0, maxX - minX + 1, this.getHeight());
        }
    }

    public String toString() {
        return "AudioChannelDataPanel[chan=" + this.audioChannel.getChannelIndex() + "]";
    }

    public void dispose() {
        this.audioChannel.removeAudioChannelListener(this);
        this.audioChannel.getFile().getView().removeViewListener(this);
        this.refresher.interrupt();
        ThreadUtils.join((Thread)this.refresher, (long)3000L);
        this.session.removeSessionListener(this.sessionListener);
        Transport.getInstance().removeTransportAdapter(this.transportAdapter);
        if (this.buffer == null && this.bufferCache != null) {
            this.buffer = this.bufferCache.get();
        }
        if (this.buffer != null) {
            this.buffer.dispose();
        }
        this.session = null;
        this.audioChannel = null;
        this.viewRange = null;
        this.buffer = null;
        this.bufferCache = null;
        this.refresher = null;
        this.dragger = null;
        this.selector = null;
    }

    static class CursorDetails {
        public final int minX;
        public final int maxX;
        public final int newX;

        public CursorDetails(int minX, int maxX, int newX) {
            this.minX = minX;
            this.maxX = maxX;
            this.newX = newX;
        }
    }

    static class RefreshData {
        long dirtyStart;
        long dirtyStop;
        int scrollDeltaPixel;
        long scrollDeltaFile;
        boolean invalidateCursors;

        RefreshData() {
        }
    }
}

