/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view;

public class DirtyArea
implements Cloneable {
    public int startX = -1;
    public int stopX = -1;

    public void markDirty(int startX, int stopX) {
        this.startX = this.startX >= 0 ? Math.min(this.startX, startX) : startX;
        this.stopX = this.stopX >= 0 ? Math.max(this.stopX, stopX) : stopX;
    }

    public void markDirty(DirtyArea other) {
        if (other.isDirty()) {
            this.markDirty(other.startX, other.stopX);
        }
    }

    public void markClean(int x) {
        if (this.startX == x) {
            ++this.startX;
        } else if (this.stopX - 1 == x) {
            --this.stopX;
        }
        if (this.startX >= this.stopX) {
            this.markClean();
        }
    }

    public void markClean() {
        this.startX = -1;
        this.stopX = -1;
    }

    public void copyFrom(DirtyArea other) {
        this.startX = other.startX;
        this.stopX = other.stopX;
    }

    public void scroll(int deltaX, int width) {
        if (this.isDirty()) {
            if (deltaX > 0) {
                if (this.startX > 0) {
                    this.startX = Math.min(this.startX + deltaX, width);
                }
                this.stopX = Math.min(this.stopX + deltaX, width);
            } else {
                this.startX = Math.max(this.startX + deltaX, 0);
                if (this.stopX < width) {
                    this.stopX = Math.max(this.stopX + deltaX, 0);
                }
            }
        }
    }

    public boolean isDirty() {
        return this.startX >= 0 || this.stopX >= 0;
    }

    public int getDirtyWidth() {
        return this.stopX - this.startX;
    }

    public boolean contains(int x) {
        assert (x >= 0);
        return x >= this.startX && x < this.stopX;
    }

    public boolean isInside(DirtyArea other) {
        if (!other.isDirty() || !this.isDirty()) {
            return false;
        }
        return this.startX >= other.startX && this.stopX <= other.stopX;
    }

    public boolean contains(int startX, int stopX) {
        if (!this.isDirty() || startX >= stopX) {
            return false;
        }
        return startX < this.stopX && stopX > this.startX;
    }

    public DirtyArea clone() {
        try {
            return (DirtyArea)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public String toString() {
        if (this.isDirty()) {
            return "[" + this.startX + "-" + this.stopX + "]";
        }
        return "[clean]";
    }
}

