/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view;

import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.IAudioChannelPanel;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class ViewDragger {
    private final JPanel cmp;
    private final IAudioChannelPanel panel;
    private final AudioFile file;
    private final AudioDataView view;
    private Cursor prevCursor;
    private int startDragX = -1;
    private int startDragY = -1;
    private long startDragPos;
    private long viewRange;
    private float startDragFloor;
    private float viewVertRange;

    public ViewDragger(JPanel cmp, IAudioChannelPanel panel, AudioFile file) {
        this.cmp = cmp;
        this.panel = panel;
        this.file = file;
        this.view = file.getView();
    }

    public boolean isDragViewEvent(MouseEvent event) {
        if (this.startDragX >= 0 && this.startDragY >= 0) {
            return true;
        }
        int theMask = 10752;
        if ((event.getModifiersEx() & theMask) != 0) {
            return true;
        }
        return event.getButton() == 2;
    }

    public void mousePressed(MouseEvent event) {
        if (event.getButton() != 2) {
            this.cancelDrag();
            return;
        }
        this.startDragX = event.getX();
        this.startDragY = event.getY();
        this.startDragPos = this.view.getStartPosition();
        this.viewRange = this.view.getStopPosition() - this.view.getStartPosition();
        this.startDragFloor = this.view.getVerticalFloor();
        this.viewVertRange = this.view.getVerticalCeil() - this.view.getVerticalFloor();
        if (this.prevCursor == null) {
            this.prevCursor = this.cmp.getCursor();
        }
        this.cmp.setCursor(Cursor.getPredefinedCursor(13));
    }

    public void mouseDragged(MouseEvent event) {
        if (this.startDragX < 0 || this.startDragY < 0) {
            return;
        }
        long deltaPos = this.panel.fromXCoord(this.startDragX, 0) - this.panel.fromXCoord(event.getX(), 0);
        int deltaY = event.getY() - this.startDragY;
        float deltaVert = this.panel.toVertOffset(deltaY);
        if (this.startDragPos + deltaPos < 0L) {
            deltaPos = -this.startDragPos;
        } else if (this.startDragPos + this.viewRange + deltaPos > this.file.getLength()) {
            deltaPos = this.file.getLength() - (this.startDragPos + this.viewRange);
        }
        if (this.startDragFloor + deltaVert < -2.0f) {
            deltaVert = -2.0f - this.startDragFloor;
        } else if (this.startDragFloor + this.viewVertRange + deltaVert > 2.0f) {
            deltaVert = 2.0f - (this.startDragFloor + this.viewVertRange);
        }
        this.view.scroll(this.startDragPos + deltaPos - this.view.getStartPosition());
        this.view.setVerticalRange(this.startDragFloor + this.viewVertRange + deltaVert, this.startDragFloor + deltaVert);
    }

    public void mouseReleased(MouseEvent event) {
        this.mouseDragged(event);
        this.cmp.setCursor(this.prevCursor);
        this.prevCursor = null;
        this.startDragX = -1;
        this.startDragY = -1;
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 1) {
            this.cancelDrag();
        } else if (event.getClickCount() == 2) {
            float vertRange = this.view.getVerticalCeil() - this.view.getVerticalFloor();
            this.view.setVerticalRange(vertRange / 2.0f, -vertRange / 2.0f);
        }
    }

    private void cancelDrag() {
        if (this.startDragX < 0 || this.startDragY < 0) {
            return;
        }
        this.cmp.setCursor(this.prevCursor);
        this.prevCursor = null;
        this.view.setVisibleRange(this.startDragPos, this.startDragPos + this.viewRange);
        this.view.setVerticalRange(this.startDragFloor + this.viewVertRange, this.startDragFloor);
        this.startDragX = -1;
        this.startDragY = -1;
    }
}

