/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view.spectrogram;

import ch.tachyon.sonics.gui.file.view.spectrogram.GradientType;
import ch.tachyon.sonics.gui.file.view.spectrogram.SpectrogramOfflineBuffer;
import java.awt.Color;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class CepstrogramOfflineBuffer
extends SpectrogramOfflineBuffer {
    private static final float BOOST_DB = 10.0f;
    private final float[] logMag;
    private final Cmplx[] cepstrum;
    private final BooFFT magFFT;

    public CepstrogramOfflineBuffer(int width, int fftSize, float sampleRate, boolean logarithmic, GradientType gradientType, Color backgroundColor, Color busyColor) {
        super(width, fftSize, sampleRate, logarithmic, gradientType, backgroundColor, busyColor);
        this.logMag = new float[fftSize / 2];
        this.cepstrum = Cmplx.newArray(fftSize / 4 + 1);
        this.magFFT = BooFFT.getInstance(fftSize / 4);
    }

    protected int swapCoordVert(int y) {
        return y;
    }

    protected float swapShiftVert(float v) {
        return -v;
    }

    protected int dynamicRange() {
        return 60;
    }

    protected void computeSpectrum(int x) {
        int i = 0;
        while (i < this.fftSize) {
            int n = i;
            this.buffer[n] = this.buffer[n] * this.window[i];
            ++i;
        }
        this.fft.forwR2C(this.buffer, this.spectrum);
        int y = 0;
        while (y < this.logMag.length) {
            float pMag = this.spectrum[y].powerMag();
            this.logMag[y] = (float)Math.log(pMag + 1.0E-8f);
            ++y;
        }
        float dc = 0.0f;
        int i2 = 0;
        while (i2 < this.logMag.length) {
            dc += this.logMag[i2];
            ++i2;
        }
        dc /= (float)this.logMag.length;
        i2 = 0;
        while (i2 < this.logMag.length) {
            int n = i2++;
            this.logMag[n] = this.logMag[n] - dc;
        }
        this.magFFT.forwR2C(this.logMag, this.cepstrum);
        Windows.convolveHann(this.cepstrum);
        float minDb = this.minDb();
        int y2 = 0;
        while (y2 < this.cepstrum.length) {
            float pMag = this.cepstrum[y2].powerMag();
            float db = (float)AudioMath.powerLevelToDb(pMag) + 10.0f;
            if (db < minDb) {
                db = minDb;
            }
            this.spectrogram[y2 * 2 + 0][x] = (byte)(db + 40.0f - 0.5f);
            if (y2 > 0) {
                this.spectrogram[y2 * 2 - 1][x] = (byte)((this.spectrogram[y2 * 2 + 0][x] + this.spectrogram[y2 * 2 - 2][x]) / 2);
            }
            ++y2;
        }
    }
}

