/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view.spectrogram;

import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GradientType {
    GREYSCALE{

        public void initGradient(int[] gradient) {
            int i = 0;
            while (i < gradient.length) {
                float value = (float)i / (float)gradient.length;
                float level = GradientType.crop(1.0f - value);
                level *= level;
                gradient[i] = new Color(level, level, level).getRGB();
                ++i;
            }
        }
    }
    ,
    GREEN{

        public void initGradient(int[] gradient) {
            float KNEE = 0.33f;
            float greenHue = 0.33f;
            float midBright = 0.7f;
            float maxBright = 0.85f;
            int i = 0;
            while (i < gradient.length) {
                float bright;
                float hue;
                float value = (float)i / (float)gradient.length;
                if (value < 0.33f) {
                    hue = 0.33f;
                    float sat = value / 0.33f;
                    bright = 0.85f - value / 0.33f * 0.15000004f;
                    gradient[i] = Color.HSBtoRGB(hue, GradientType.crop(sat), bright);
                } else {
                    hue = 0.33f;
                    float n = (value - 0.33f) / 0.66999996f;
                    n = (float)Math.sqrt(n);
                    bright = (1.0f - n) * 0.7f;
                    gradient[i] = Color.HSBtoRGB(GradientType.crop(hue), 1.0f, GradientType.crop(bright));
                }
                ++i;
            }
        }
    }
    ,
    RED_BLUE{

        public void initGradient(int[] gradient) {
            float KNEE1 = 0.33f;
            float KNEE2 = 0.66f;
            float maxBright = 0.8f;
            float midBright = 0.5f;
            float minBright = 0.1f;
            float redHue = 1.02f;
            float blueHue = 0.6f;
            float maxSat = 0.9f;
            int i = 0;
            while (i < gradient.length) {
                float bright;
                float hue;
                float value = (float)i / (float)gradient.length;
                if (value < 0.33f) {
                    hue = 1.02f;
                    float sat = value / 0.33f;
                    bright = 0.8f;
                    gradient[i] = Color.HSBtoRGB(GradientType.norm(hue), GradientType.crop(sat * 0.9f), bright);
                } else if (value < 0.66f) {
                    float a = (value - 0.33f) / 0.33f;
                    float hue2 = (1.0f - a) * 1.02f + a * 0.6f;
                    bright = 0.8f - a * 0.3f;
                    gradient[i] = Color.HSBtoRGB(GradientType.norm(hue2), 0.9f, GradientType.crop(bright));
                } else {
                    hue = 0.6f;
                    float a = (value - 0.66f) / 0.33999997f;
                    bright = (1.0f - a) * 0.4f + 0.1f;
                    gradient[i] = Color.HSBtoRGB(GradientType.norm(hue), 0.9f, GradientType.crop(bright));
                }
                ++i;
            }
        }
    }
    ,
    RAINBOW{

        public void initGradient(int[] gradient) {
            float KNEE = 0.25f;
            float maxHue = 0.95f;
            float brightMax = 0.8f;
            float brightMin = 0.2f;
            float brightRange = 0.6f;
            int i = 0;
            while (i < gradient.length) {
                float hue;
                float value = (float)i / (float)gradient.length;
                if (value < 0.25f) {
                    hue = 0.0f;
                    float sat = value / 0.25f;
                    float bright = 0.8f;
                    gradient[i] = Color.HSBtoRGB(hue, GradientType.crop(sat), bright);
                } else {
                    hue = (value - 0.25f) / 0.75f * 0.95f;
                    float bright = (1.0f - (value - 0.25f) / 0.75f) * 0.6f + 0.2f;
                    gradient[i] = Color.HSBtoRGB(GradientType.crop(hue), 1.0f, GradientType.crop(bright));
                }
                ++i;
            }
        }
    }
    ,
    SIMPLE_HUE{

        public void initGradient(int[] gradient) {
            float SATURATION = 0.8f;
            float BRIGHTNESS = 0.8f;
            int i = 0;
            while (i < gradient.length) {
                float hue = (float)i / (float)gradient.length;
                gradient[i] = Color.HSBtoRGB(hue, 0.8f, 0.8f);
                ++i;
            }
        }
    };


    private GradientType() {
    }

    public abstract void initGradient(int[] var1);

    private static float crop(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    private static float norm(float value) {
        while (value < 0.0f) {
            value += 1.0f;
        }
        while (value > 1.0f) {
            value -= 1.0f;
        }
        return value;
    }

    /* synthetic */ GradientType(String string, int n, GradientType gradientType) {
        this();
    }
}

