/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view.spectrogram;

import ch.tachyon.sonics.gui.file.view.spectrogram.GradientType;
import ch.tachyon.sonics.gui.file.view.spectrogram.SpectrogramOfflineBuffer;
import java.awt.Color;
import org.corebounce.common.audio.AudioMath;

public class PitchOfflineBuffer
extends SpectrogramOfflineBuffer {
    private final float[] temp1;
    private final float[] temp2;

    public PitchOfflineBuffer(int width, int fftSize, float sampleRate, boolean logarithmic, GradientType gradientType, Color backgroundColor, Color busyColor) {
        super(width, fftSize, sampleRate, logarithmic, gradientType, backgroundColor, busyColor);
        this.temp1 = new float[fftSize / 2 + 1];
        this.temp2 = new float[fftSize / 2 + 1];
    }

    protected void computeSpectrum(int x) {
        int i = 0;
        while (i < this.fftSize) {
            int n = i;
            this.buffer[n] = this.buffer[n] * this.window[i];
            ++i;
        }
        this.fft.forwR2C(this.buffer, this.spectrum);
        float sqrtCorr = (float)Math.sqrt(this.correction);
        int y = 0;
        while (y < this.nbBins) {
            float pMag;
            this.temp1[y] = pMag = this.spectrum[y].magApprox() * sqrtCorr;
            this.temp2[y] = pMag;
            ++y;
        }
        int i2 = 0;
        while (i2 < this.nbBins) {
            if (i2 % 2 == 0) {
                int n = i2;
                this.temp1[n] = this.temp1[n] - this.temp2[i2 / 2];
            } else {
                int n = i2;
                this.temp1[n] = this.temp1[n] - (this.temp2[i2 / 2] + this.temp2[i2 / 2 + 1]) / 2.0f;
            }
            this.temp1[i2] = Math.max(this.temp1[i2], 0.0f);
            ++i2;
        }
        float minDb = this.minDb();
        int y2 = 0;
        while (y2 < this.nbBins) {
            float db = (float)AudioMath.levelToDb(this.temp1[y2]);
            if (db < minDb) {
                db = minDb;
            }
            this.spectrogram[y2][x] = (byte)(db + 40.0f - 0.5f);
            ++y2;
        }
    }
}

