/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view.spectrogram;

import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.stats.LoudestExtremum;
import ch.tachyon.sonics.gui.file.view.AudioChannelDataRange;
import ch.tachyon.sonics.gui.file.view.DirtyArea;
import ch.tachyon.sonics.gui.file.view.IChannelOfflineDataBuffer;
import ch.tachyon.sonics.gui.file.view.IRefreshObserver;
import ch.tachyon.sonics.gui.file.view.spectrogram.GradientType;
import ch.tachyon.tunnel.utils.Monitor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.BitSet;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.ImageUtils;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.CubicInterpolator;
import org.corebounce.common.math.FastMath;

public class SpectrogramOfflineBuffer
implements IChannelOfflineDataBuffer {
    private static final float DB_BOOST_PER_OCTAVE = 3.0f;
    private static final boolean ENHANCE_TOWARD_ZERO = false;
    private static final int BOOST_DB = 10;
    private static final int SCALING_QUALITY = 1;
    private static final int SPECTRUM_QUALITY = 1;
    protected static final float SHIFT_DB = 40.0f;
    protected final float maxFreq;
    protected final float midFreq;
    protected final boolean logarithmic;
    protected final int width;
    protected final int fftSize;
    protected final float sampleRate;
    protected final int nbBins;
    protected final float correction;
    protected final BooFFT fft;
    protected final float[] window;
    protected final float[] buffer;
    protected final Cmplx[] spectrum;
    protected final byte[][] spectrogram;
    private final BitSet outOfFileColumns;
    private final float[] lookupCache;
    private final float[] dbBoost;
    private final Color backgroundColor;
    private final Color busyColor;
    private final float[] gradientR;
    private final float[] gradientG;
    private final float[] gradientB;
    private GradientType gradientType;
    private SoftReference<BufferedImage> rgbImageRef = new SoftReference<Object>(null);
    private SoftReference<VolatileImage> imageRef = new SoftReference<Object>(null);
    private final DirtyArea dirtySpectrogram = new DirtyArea();
    private final DirtyArea dirtyRgb = new DirtyArea();
    private final DirtyArea dirtyImage = new DirtyArea();
    private final int scalingQuality;
    private final int spectrumQuality;
    private ColorData colorData;
    private int offlineOffset;
    private long avgPaintDuration = 0L;
    private final Object durationLock = new Monitor("durationLock");
    private final Object paintLock = new Monitor("paintLock");
    private final Object dataLock = new Monitor("dataLock");

    public SpectrogramOfflineBuffer(int width, int fftSize, float sampleRate, boolean logarithmic, GradientType gradientType, Color backgroundColor, Color busyColor) {
        this.width = width;
        this.fftSize = fftSize;
        this.sampleRate = sampleRate;
        this.maxFreq = sampleRate / 2.0f;
        this.midFreq = this.getClass().equals(SpectrogramOfflineBuffer.class) ? (float)Math.pow(this.maxFreq, 0.7) : (float)Math.pow(this.maxFreq, 0.76);
        this.logarithmic = logarithmic;
        this.buffer = new float[fftSize];
        this.window = new float[fftSize];
        this.fft = BooFFT.getInstance(fftSize / 2);
        this.nbBins = fftSize / 2 + 1;
        this.correction = fftSize;
        this.spectrum = Cmplx.newArray(this.nbBins);
        this.spectrogram = new byte[this.nbBins][width];
        this.outOfFileColumns = new BitSet(width);
        this.lookupCache = new float[this.nbBins + 1];
        Arrays.fill(this.lookupCache, Float.NaN);
        this.dbBoost = new float[this.nbBins];
        this.initBoost();
        this.backgroundColor = backgroundColor;
        this.busyColor = busyColor;
        this.gradientR = new float[this.nbDb()];
        this.gradientG = new float[this.nbDb()];
        this.gradientB = new float[this.nbDb()];
        this.offlineOffset = 0;
        this.scalingQuality = 1;
        this.spectrumQuality = 1;
        Windows.fillWindow(this.window, Windows.HannCoefs);
        this.setGradientType(gradientType);
        this.markDirty(0, width);
    }

    protected int dynamicRange() {
        return 80;
    }

    protected final int nbDb() {
        return this.dynamicRange() + 10;
    }

    protected final float minDb() {
        return -this.nbDb();
    }

    protected void initBoost() {
        if (!this.logarithmic) {
            return;
        }
        int y = 0;
        while (y < this.nbBins) {
            int y1 = Math.max(y, 1);
            float freq = (float)y1 * (this.sampleRate / 2.0f) / (float)(this.nbBins - 1);
            float octaves = (float)(Math.log(freq / this.midFreq) / Math.log(2.0));
            this.dbBoost[y] = octaves * 3.0f;
            ++y;
        }
    }

    public GradientType getGradientType() {
        return this.gradientType;
    }

    public void setGradientType(GradientType gradientType) {
        if (this.gradientType != gradientType) {
            this.gradientType = gradientType;
            int[] gradient = new int[this.nbDb()];
            gradientType.initGradient(gradient);
            int i = 0;
            while (i < gradient.length) {
                int rgb = gradient[i];
                this.gradientR[i] = (float)(rgb >> 16 & 0xFF) / 256.0f;
                this.gradientG[i] = (float)(rgb >> 8 & 0xFF) / 256.0f;
                this.gradientB[i] = (float)(rgb & 0xFF) / 256.0f;
                ++i;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public long getSmearAmount() {
        return this.fftSize;
    }

    private int rotate(int x, boolean hiBound) {
        if (hiBound) {
            while (x < 0) {
                x += this.width;
            }
            if ((x += this.offlineOffset) > this.width) {
                x %= this.width;
            }
            return x;
        }
        x = (x + this.offlineOffset + this.width) % this.width;
        return x;
    }

    private int rotate(int x) {
        return this.rotate(x, false);
    }

    private float getValue(AudioChannelDataRange view, int dx, int y) {
        if (this.outOfFileColumns.get(dx)) {
            return Float.NEGATIVE_INFINITY;
        }
        float y0 = this.scale(view, y);
        float y1 = this.scale(view, y + 1);
        if (y1 <= 0.0f || y0 >= (float)this.nbBins) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.spectrumQuality < 1) {
            int sy = (int)((y0 + y1) / 2.0f + 0.5f);
            return this.getBoostedValue0(dx, sy);
        }
        if (y1 - y0 > 1.0f) {
            int sy = (int)y0;
            int ey = (int)y1;
            assert (ey > sy);
            float result = Float.NEGATIVE_INFINITY;
            int i = sy;
            while (i < ey) {
                result = FastMath.max(result, this.getBoostedValue0(dx, i));
                ++i;
            }
            return result;
        }
        float index = (y0 + y1) / 2.0f - 0.5f;
        int index1 = (int)index;
        int index0 = index1 - 1;
        int index2 = index1 + 1;
        int index3 = index1 + 2;
        double mu = index - (float)index1;
        double ya = this.getBoostedValue0(dx, index0);
        double yb = this.getBoostedValue0(dx, index1);
        double yc = this.getBoostedValue0(dx, index2);
        double yd = this.getBoostedValue0(dx, index3);
        double result = CubicInterpolator.splineInterpolateY(ya, yb, yc, yd, mu);
        return (float)result;
    }

    private float scale(AudioChannelDataRange view, int y) {
        float result = this.lookupCache[y];
        if (Float.isNaN(result)) {
            result = this.scaleVertical(view, y);
            if (this.logarithmic) {
                result = this.logLookup(result);
            }
            this.lookupCache[y] = result;
        }
        return result;
    }

    private float logLookup(float y) {
        float base = this.maxFreq / this.midFreq * (this.maxFreq / this.midFreq);
        double norm = (double)y / (double)(this.nbBins - 1);
        double logNorm = (Math.pow(base, norm) - 1.0) / ((double)base - 1.0);
        float index = (float)(logNorm * (double)(this.nbBins - 1));
        return index;
    }

    private float scaleVertical(AudioChannelDataRange view, float value) {
        float floor = view.getVerticalFloor();
        float ceil = view.getVerticalCeil();
        if (floor == -1.0f && ceil == 1.0f) {
            return value;
        }
        float vertSpan = (ceil - floor) / 2.0f;
        float norm = value * 2.0f / (float)(this.nbBins - 1) - 1.0f;
        float scaledNorm = norm * vertSpan;
        float shifted = scaledNorm + this.swapShiftVert((floor + ceil) / 2.0f);
        return (shifted + 1.0f) * (float)(this.nbBins - 1) / 2.0f;
    }

    private float getBoostedValue0(int dx, int y) {
        if (y < 0) {
            y = 0;
        } else if (y >= this.nbBins) {
            y = this.nbBins - 1;
        }
        return (float)this.spectrogram[y][dx] + this.dbBoost[y] - 40.0f;
    }

    protected int swapCoordVert(int y) {
        return this.nbBins - y - 1;
    }

    protected float swapShiftVert(float v) {
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirty(int startX, int stopX) {
        Object object = this.paintLock;
        synchronized (object) {
            Object object2 = this.dataLock;
            synchronized (object2) {
                this.dirtySpectrogram.markDirty(startX, stopX);
            }
            this.dirtyRgb.markDirty(startX, stopX);
            this.dirtyImage.markDirty(startX, stopX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scroll(int deltaX) {
        if (Math.abs(deltaX) >= this.width - 1) {
            return false;
        }
        Object object = this.paintLock;
        synchronized (object) {
            Object object2 = this.dataLock;
            synchronized (object2) {
                this.dirtyRgb.scroll(deltaX, this.width);
                this.dirtyImage.scroll(deltaX, this.width);
                this.dirtySpectrogram.scroll(deltaX, this.width);
                this.offlineOffset = (this.offlineOffset + this.width - deltaX) % this.width;
                assert (this.offlineOffset >= 0 && this.offlineOffset < this.width);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(AudioChannel data, AudioChannelDataRange view, int startX, int stopX, long fileStartPos, double reduction, int height, IRefreshObserver observer) throws IOException {
        long clock = System.currentTimeMillis();
        if (startX < 0) {
            startX = 0;
        }
        if (stopX > this.width) {
            stopX = this.width;
        }
        int x = startX;
        while (x < stopX) {
            long bucketStop;
            long midPos = fileStartPos + (long)((double)x * reduction + 0.5);
            long bucketStart = fileStartPos + (long)(((double)x - 0.5) * reduction + 0.5);
            if (bucketStart < 0L) {
                bucketStart = 0L;
            }
            if ((bucketStop = fileStartPos + (long)(((double)x + 0.5) * reduction + 0.5)) > data.getLength()) {
                bucketStop = data.getLength();
            }
            long bucketRange = bucketStop - bucketStart;
            double sampling = (double)this.fftSize / (double)bucketRange;
            int dx = this.rotate(x);
            long pos = sampling < 1.5 && bucketRange > 0L ? data.getExtremumSample(bucketStart, bucketStop, data, new LoudestExtremum()) : midPos;
            this.computeSpectrumAt(data, pos, dx);
            Object object = this.dataLock;
            synchronized (object) {
                this.dirtySpectrogram.markClean(x);
            }
            object = this.paintLock;
            synchronized (object) {
                BufferedImage unscaled = this.rgbImageRef.get();
                if (unscaled != null && this.dirtyRgb.startX == x && unscaled.getHeight() == height) {
                    this.rebuildRgbColumn(view, unscaled, x, this.dirtySpectrogram, height);
                    this.dirtyRgb.markClean(x);
                }
            }
            boolean cont = observer.refreshed(this, x, midPos, false);
            if (!cont) break;
            ++x;
        }
        long elapsed = System.currentTimeMillis() - clock;
        this.updateAvgDuration(elapsed);
    }

    private void computeSpectrumAt(AudioChannel data, long pos, int dx) throws IOException {
        long startPos = pos - (long)(this.fftSize / 2);
        long stopPos = startPos + (long)this.fftSize;
        long readStart = Math.max(startPos, 0L);
        long readStop = Math.min(stopPos, data.getLength());
        if (readStop <= readStart) {
            int y = 0;
            while (y < this.nbBins) {
                this.spectrogram[y][dx] = -128;
                ++y;
            }
            this.outOfFileColumns.set(dx);
            return;
        }
        this.outOfFileColumns.clear(dx);
        Arrays.fill(this.buffer, 0.0f);
        if (readStop > readStart) {
            data.read(readStart, this.buffer, (int)(readStart - startPos), (int)(readStop - readStart));
        }
        if (readStart > startPos) {
            Arrays.fill(this.buffer, 0, (int)(readStart - startPos), 0.0f);
        }
        if (stopPos > readStop) {
            Arrays.fill(this.buffer, (int)(readStop - startPos), this.buffer.length, 0.0f);
        }
        this.computeSpectrum(dx);
    }

    protected void computeSpectrum(int dx) {
        int i = 0;
        while (i < this.fftSize) {
            int n = i;
            this.buffer[n] = this.buffer[n] * this.window[i];
            ++i;
        }
        this.fft.forwR2C(this.buffer, this.spectrum);
        float minDb = this.minDb();
        int y = 0;
        while (y < this.nbBins) {
            float pMag = this.spectrum[y].powerMag() * this.correction;
            float db = (float)AudioMath.powerLevelToDb(pMag);
            if (db < minDb) {
                db = minDb;
            }
            this.spectrogram[y][dx] = (byte)(db + 40.0f - 0.5f);
            ++y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage lookupRgbImage(AudioChannelDataRange view, int height) {
        DirtyArea dirtySpectrogram;
        BufferedImage image = this.rgbImageRef.get();
        if (image == null) {
            image = new BufferedImage(this.width, height, 1);
            this.rgbImageRef = new SoftReference<BufferedImage>(image);
            this.dirtyRgb.markDirty(0, this.width);
        }
        Object object = this.dataLock;
        synchronized (object) {
            dirtySpectrogram = this.dirtySpectrogram.clone();
        }
        if (this.dirtyRgb.isDirty() && !this.dirtyRgb.isInside(dirtySpectrogram)) {
            int startX = this.dirtyRgb.startX;
            int stopX = this.dirtyRgb.stopX;
            int cutX = this.width - this.offlineOffset;
            if (cutX > startX && cutX < stopX) {
                this.rebuildRgbRange(view, image, startX, cutX, dirtySpectrogram, height);
                this.rebuildRgbRange(view, image, cutX, stopX, dirtySpectrogram, height);
            } else if (stopX > startX) {
                this.rebuildRgbRange(view, image, startX, stopX, dirtySpectrogram, height);
            }
            this.dirtyRgb.copyFrom(dirtySpectrogram);
        }
        return image;
    }

    private void rebuildRgbRange(AudioChannelDataRange view, BufferedImage image, int startX, int stopX, DirtyArea dirtySpectrogram, int height) {
        int x = startX;
        while (x < stopX) {
            this.rebuildRgbColumn(view, image, x, dirtySpectrogram, height);
            ++x;
        }
    }

    private void rebuildRgbColumn(AudioChannelDataRange view, BufferedImage image, int x, DirtyArea dirtySpectrogram, int height) {
        if (this.colorData == null || this.colorData.getHeight() != height) {
            this.colorData = new ColorData(this.nbBins, height);
        }
        float[] srcR = this.colorData.srcR;
        float[] srcG = this.colorData.srcG;
        float[] srcB = this.colorData.srcB;
        float[] dstR = this.colorData.dstR;
        float[] dstG = this.colorData.dstG;
        float[] dstB = this.colorData.dstB;
        int[] rgb = this.colorData.rgb;
        float backR = (float)this.backgroundColor.getRed() / 255.0f;
        float backG = (float)this.backgroundColor.getGreen() / 255.0f;
        float backB = (float)this.backgroundColor.getBlue() / 255.0f;
        float busyR = (float)this.busyColor.getRed() / 255.0f;
        float busyG = (float)this.busyColor.getGreen() / 255.0f;
        float busyB = (float)this.busyColor.getBlue() / 255.0f;
        int maxIndex = this.nbDb();
        int y = 0;
        while (y < this.nbBins) {
            int yInv = this.swapCoordVert(y);
            int dx = this.rotate(x);
            if (!dirtySpectrogram.contains(x)) {
                float value = this.getValue(view, dx, yInv);
                if (value != Float.NEGATIVE_INFINITY) {
                    value = -value;
                    int index = (int)((value += 10.0f) + 0.5f);
                    if (index < 0) {
                        index = 0;
                    } else if (index >= maxIndex) {
                        index = maxIndex - 1;
                    }
                    srcR[y] = this.gradientR[index];
                    srcG[y] = this.gradientG[index];
                    srcB[y] = this.gradientB[index];
                } else {
                    srcR[y] = backR;
                    srcG[y] = backG;
                    srcB[y] = backB;
                }
            } else {
                srcR[y] = busyR;
                srcG[y] = busyG;
                srcB[y] = busyB;
            }
            ++y;
        }
        if (this.scalingQuality == 0) {
            int dstIndex = 0;
            while (dstIndex < height) {
                int srcIndex = dstIndex * (this.nbBins - 1) / height;
                dstR[dstIndex] = srcR[srcIndex];
                dstG[dstIndex] = srcG[srcIndex];
                dstB[dstIndex] = srcB[srcIndex];
                ++dstIndex;
            }
        } else {
            Arrays.fill(dstR, 0.0f);
            Arrays.fill(dstG, 0.0f);
            Arrays.fill(dstB, 0.0f);
            int intSrc = 0;
            double fracSrc = 0.0;
            double increment = (double)(this.nbBins - 1) / (double)height;
            double correction = 1.0 / increment;
            int dstIndex = 0;
            while (dstIndex < height) {
                double toAdd = increment;
                while (toAdd > 0.0 && intSrc < this.nbBins) {
                    double avail = 1.0 - fracSrc;
                    double weight = toAdd > avail ? avail : toAdd;
                    int n = dstIndex;
                    dstR[n] = (float)((double)dstR[n] + (double)srcR[intSrc] * weight * correction);
                    int n2 = dstIndex;
                    dstG[n2] = (float)((double)dstG[n2] + (double)srcG[intSrc] * weight * correction);
                    int n3 = dstIndex;
                    dstB[n3] = (float)((double)dstB[n3] + (double)srcB[intSrc] * weight * correction);
                    if ((fracSrc += weight) >= 1.0) {
                        assert (fracSrc == 1.0);
                        fracSrc = 0.0;
                        ++intSrc;
                    }
                    toAdd -= weight;
                }
                ++dstIndex;
            }
        }
        int i = 0;
        while (i < height) {
            int r = SpectrogramOfflineBuffer.cropRgb((int)(dstR[i] * 255.0f));
            int g = SpectrogramOfflineBuffer.cropRgb((int)(dstG[i] * 255.0f));
            int b = SpectrogramOfflineBuffer.cropRgb((int)(dstB[i] * 255.0f));
            rgb[i] = (r << 16) + (g << 8) + b;
            ++i;
        }
        ImageUtils.setPixels(image, this.rotate(x), 0, 1, height, rgb);
    }

    private static int cropRgb(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 255) {
            return 255;
        }
        return value;
    }

    private VolatileImage lookupImage(AudioChannelDataRange view, GraphicsConfiguration gc, int height) {
        VolatileImage image;
        boolean contentsLost;
        do {
            int minX;
            int maxX;
            image = this.imageRef.get();
            int imageStatus = 0;
            if (image != null) {
                imageStatus = image.validate(gc);
            }
            if (image == null || image.getWidth() != this.width || image.getHeight() != height || imageStatus == 2) {
                if (image != null) {
                    image.flush();
                }
                image = gc.createCompatibleVolatileImage(this.width, height);
                this.imageRef = new SoftReference<VolatileImage>(image);
                this.dirtyImage.markDirty(0, this.width);
            } else if (imageStatus == 1) {
                this.dirtyImage.markDirty(0, this.width);
            }
            if (this.dirtyImage.isDirty() && (maxX = this.dirtyImage.stopX) > (minX = this.dirtyImage.startX)) {
                BufferedImage rgbImage = this.lookupRgbImage(view, height);
                int cutX = this.width - this.offlineOffset;
                Graphics2D g = image.createGraphics();
                AwtTools.setupHighSpeed(g);
                if (cutX > minX && cutX < maxX) {
                    this.blitRange(rgbImage, gc, height, g, this.rotate(minX, false), this.rotate(cutX, true));
                    this.blitRange(rgbImage, gc, height, g, this.rotate(cutX, false), this.rotate(maxX, true));
                } else {
                    this.blitRange(rgbImage, gc, height, g, this.rotate(minX, false), this.rotate(maxX, true));
                }
                g.dispose();
                this.dirtyImage.copyFrom(this.dirtyRgb);
            }
            if (!(contentsLost = image.contentsLost())) continue;
            this.dirtyImage.markDirty(0, this.width);
        } while (contentsLost);
        return image;
    }

    private void blitRange(BufferedImage rgbImage, GraphicsConfiguration gc, int height, Graphics2D g, int minDX, int maxDX) {
        assert (minDX < maxDX);
        g.drawImage(rgbImage, minDX, 0, maxDX, height, minDX, 0, maxDX, height, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(AudioChannelDataRange view, Graphics2D g, int startX, int stopX, int height) {
        DirtyArea dirty;
        AwtTools.setupHighSpeed(g);
        GraphicsConfiguration gc = g.getDeviceConfiguration();
        Object object = this.dataLock;
        synchronized (object) {
            dirty = this.dirtySpectrogram.clone();
        }
        object = this.paintLock;
        synchronized (object) {
            boolean contentsLost;
            long clock = System.currentTimeMillis();
            do {
                VolatileImage image = this.lookupImage(view, gc, height);
                if (dirty.isDirty()) {
                    int minX = Math.max(dirty.startX, startX);
                    int maxX = Math.min(dirty.stopX, stopX);
                    if (maxX > minX) {
                        g.setColor(this.busyColor);
                        g.fillRect(minX, 0, maxX - minX, height);
                    }
                    if (minX > startX) {
                        this.drawCircularImage(g, image, startX, 0, minX, height);
                    }
                    if (stopX > maxX) {
                        this.drawCircularImage(g, image, maxX, 0, stopX, height);
                    }
                } else {
                    this.drawCircularImage(g, image, startX, 0, stopX, height);
                }
                if (!(contentsLost = image.contentsLost())) continue;
                this.dirtyImage.markDirty(0, this.width);
            } while (contentsLost);
            long duration = System.currentTimeMillis() - clock;
            this.updateAvgDuration(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAvgDuration(long duration) {
        Object object = this.durationLock;
        synchronized (object) {
            this.avgPaintDuration = duration > this.avgPaintDuration ? duration : (this.avgPaintDuration + duration) / 2L;
        }
    }

    private void drawCircularImage(Graphics2D g, Image image, int sx, int sy, int ex, int ey) {
        int cx = this.width - this.offlineOffset;
        if (cx > sx && cx < ex) {
            g.drawImage(image, sx, sy, cx, ey, this.rotate(sx, false), sy, this.rotate(cx, true), ey, null);
            g.drawImage(image, cx, sy, ex, ey, this.rotate(cx, false), sy, this.rotate(ex, true), ey, null);
        } else {
            g.drawImage(image, sx, sy, ex, ey, this.rotate(sx, false), sy, this.rotate(ex, true), ey, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAvgLastPaintDuration() {
        Object object = this.durationLock;
        synchronized (object) {
            return this.avgPaintDuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verticalChange(boolean heightOnly) {
        Object object = this.paintLock;
        synchronized (object) {
            Object object2 = this.dataLock;
            synchronized (object2) {
                VolatileImage image = this.imageRef.get();
                if (image != null) {
                    image.flush();
                }
                this.imageRef.clear();
                BufferedImage unscaled = this.rgbImageRef.get();
                if (unscaled != null) {
                    unscaled.flush();
                }
                this.rgbImageRef.clear();
                Arrays.fill(this.lookupCache, Float.NaN);
                this.markDirty(0, this.getWidth());
            }
        }
        return true;
    }

    public void dispose() {
        VolatileImage image;
        BufferedImage unscaled = this.rgbImageRef.get();
        if (unscaled != null) {
            unscaled.flush();
        }
        if ((image = this.imageRef.get()) != null) {
            image.flush();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    static class ColorData {
        final float[] srcR;
        final float[] srcG;
        final float[] srcB;
        final float[] dstR;
        final float[] dstG;
        final float[] dstB;
        final int[] rgb;

        public ColorData(int nbBins, int height) {
            this.srcR = new float[nbBins];
            this.srcG = new float[nbBins];
            this.srcB = new float[nbBins];
            this.dstR = new float[height];
            this.dstG = new float[height];
            this.dstB = new float[height];
            this.rgb = new int[height];
        }

        public int getHeight() {
            return this.rgb.length;
        }
    }
}

