/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view.waveform;

import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.tunnel.utils.Debug;
import java.io.IOException;
import java.util.Arrays;
import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.IResetable;

public class AudioChannelSource
implements IAudioSource,
IResetable {
    private AudioChannel channel;
    private long startPos;
    private long curPos;

    public AudioChannel getChannel() {
        return this.channel;
    }

    public void setChannel(AudioChannel channel) {
        this.channel = channel;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public void setStartPos(long startPos) {
        this.startPos = startPos;
    }

    public int getSamples(float[] target, int offset, int count) {
        int result = 0;
        if (this.curPos < 0L) {
            int amount = Math.min((int)(-this.curPos), count);
            Arrays.fill(target, offset, offset + amount, 0.0f);
            this.curPos += (long)amount;
            offset += amount;
            result += amount;
            if ((count -= amount) <= 0) {
                return result;
            }
        }
        try {
            this.curPos += (long)count;
            if ((result += this.channel.read(this.curPos, target, offset, count)) < count) {
                Arrays.fill(target, offset + result, offset + count, 0.0f);
            }
            return result;
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
            return 0;
        }
    }

    public void reset() {
        this.curPos = this.startPos;
    }
}

