/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view.waveform;

import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.gui.file.view.AudioChannelDataRange;
import ch.tachyon.sonics.gui.file.view.IChannelOfflineDataBuffer;
import ch.tachyon.sonics.gui.file.view.IRefreshObserver;
import ch.tachyon.sonics.gui.file.view.waveform.AudioChannelSource;
import ch.tachyon.sonics.gui.file.view.waveform.WaveFormOfflineBuffer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import org.corebounce.common.dsp.resample.FastSincResampler;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.ZeroLatencyResampleWrapper;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.IconLoader;

public class WaveCurveOfflineBuffer
implements IChannelOfflineDataBuffer {
    private static final int SINC_UPSAMPLE_FACTOR = 1024;
    private static final int SINC_NB_ZERO_CROSS = 40;
    private static final float SINC_KAISER_FACTOR = 80.0f;
    private static final int BUFFER_SIZE = 4096;
    private static final int NB_PREFETCH_SAMPLES = 40;
    private static final Color clipAreaColor = WaveFormOfflineBuffer.clipAreaColor;
    private static final Color curveColor = new Color(0.28f, 0.145f, 1.0f);
    private static final Color clippedColor = new Color(1.0f, 0.145f, 0.28f);
    private final int width;
    private final float[] curve;
    private final float[] buffer;
    private final float[] dots;
    private float[] preFetch;
    private final AudioChannelSource source = new AudioChannelSource();
    private IResampler resampler;
    private double resampleRatio = Double.NaN;
    private BufferedImage bullet;
    private BufferedImage clippedBullet;

    public WaveCurveOfflineBuffer(int width) {
        this.width = width;
        this.curve = new float[width];
        this.buffer = new float[width];
        this.dots = new float[width];
    }

    public int getWidth() {
        return this.width;
    }

    public long getSmearAmount() {
        return 40L;
    }

    public float getValue(int x) {
        return this.curve[x];
    }

    public float getDot(int x) {
        return this.dots[x];
    }

    public synchronized void markDirty(int startX, int stopX) {
        Arrays.fill(this.curve, startX, stopX, Float.NaN);
        Arrays.fill(this.dots, startX, stopX, Float.NaN);
    }

    public synchronized boolean scroll(int deltaX) {
        return false;
    }

    public synchronized boolean verticalChange(boolean heightOnly) {
        return false;
    }

    private IResampler getResampler(double zoom) {
        if (this.resampler == null || zoom != this.resampleRatio) {
            this.resampler = new FastSincResampler(this.source, zoom, 1024, 40, 80.0f, 0.0f, 4096);
            this.resampler = new ZeroLatencyResampleWrapper(this.resampler, zoom);
            this.resampleRatio = zoom;
        }
        this.resampler.reset();
        return this.resampler;
    }

    private void ensurePreFetchExactSize(int size) {
        if (this.preFetch == null || this.preFetch.length != size) {
            this.preFetch = new float[size];
        }
    }

    double getCurrentZoom() {
        return this.resampleRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(AudioChannel data, AudioChannelDataRange view, int startX, int stopX, long fileStartPos, double reduction, int height, IRefreshObserver observer) throws IOException {
        double zoom = 1.0 / reduction;
        if (zoom < 1.0) {
            throw new IllegalArgumentException("Zoom must be positive");
        }
        double halfSampleWidth = zoom / 2.0;
        IResampler resampler = this.getResampler(zoom);
        int outputPrefetch = (int)(40.0 * zoom + 0.5 - halfSampleWidth);
        this.ensurePreFetchExactSize(outputPrefetch);
        this.source.setChannel(data);
        this.source.setStartPos(fileStartPos - 40L);
        this.source.reset();
        WaveCurveOfflineBuffer waveCurveOfflineBuffer = this;
        synchronized (waveCurveOfflineBuffer) {
            resampler.resample(this.preFetch);
            resampler.resample(this.curve);
            int fileRange = (int)((double)this.width / zoom) + 1;
            int amount = data.read(fileStartPos, this.buffer, 0, fileRange);
            int fileOffset = 0;
            int x = (int)((double)fileOffset * zoom + 0.5 + halfSampleWidth);
            while (x < this.width) {
                if (x >= 0 && fileOffset < amount) {
                    this.dots[x] = this.buffer[fileOffset];
                }
                x = (int)((double)(++fileOffset) * zoom + 0.5 + halfSampleWidth);
            }
        }
    }

    private Image getBulletImage(Graphics2D g, int size) {
        if (this.bullet == null || this.bullet.getWidth() != size || this.bullet.getHeight() != size) {
            Image image = IconLoader.getImage(WaveCurveOfflineBuffer.class, "bullet-blue.png", size);
            this.bullet = g.getDeviceConfiguration().createCompatibleImage(size, size, 3);
            Graphics2D gb = this.bullet.createGraphics();
            gb.drawImage(image, 0, 0, null);
            gb.dispose();
        }
        return this.bullet;
    }

    private Image getClippedBulletImage(Graphics2D g, int size) {
        if (this.clippedBullet == null || this.clippedBullet.getWidth() != size || this.clippedBullet.getHeight() != size) {
            Image image = IconLoader.getImage(WaveCurveOfflineBuffer.class, "bullet-red.png", size);
            this.clippedBullet = g.getDeviceConfiguration().createCompatibleImage(size, size, 3);
            Graphics2D gb = this.clippedBullet.createGraphics();
            gb.drawImage(image, 0, 0, null);
            gb.dispose();
        }
        return this.clippedBullet;
    }

    public synchronized void paint(AudioChannelDataRange view, Graphics2D g, int startX, int stopX, int height) {
        int minDotSize = 3;
        int minDrawnDotSize = 5;
        int maxDotSize = 31;
        double zoom = this.getCurrentZoom();
        g = (Graphics2D)g.create();
        AffineTransform trx = new AffineTransform();
        trx.translate(0.0, height);
        trx.scale(1.0, -1.0);
        g.transform(trx);
        float floor = view.getVerticalFloor();
        float ceil = view.getVerticalCeil();
        if (floor < -1.0f) {
            int yf = this.scaleVertical(view, -1.0f, height);
            g.setColor(clipAreaColor);
            g.fillRect(0, 0, this.width, yf);
        }
        if (ceil > 1.0f) {
            int yc = this.scaleVertical(view, 1.0f, height);
            g.setColor(clipAreaColor);
            g.fillRect(0, yc, this.width, height - yc);
        }
        AwtTools.setupHighQuality(g);
        g.setColor(curveColor);
        g.setStroke(new BasicStroke((float)Math.min(zoom, 2.0)));
        int dotSize = (int)(Math.min(zoom, (double)height) * 0.5);
        if (dotSize > 31) {
            dotSize = 31;
        }
        Image dotImage = null;
        Image clippedDotImage = null;
        if (dotSize >= 3) {
            dotSize = Math.max(dotSize, 5);
            dotImage = this.getBulletImage(g, dotSize);
            clippedDotImage = this.getClippedBulletImage(g, dotSize);
        }
        double dotCenter = (double)(dotSize + 1) / 2.0;
        AffineTransform dotLocation = new AffineTransform();
        int[] xPts = new int[this.width];
        int[] yPts = new int[this.width];
        boolean clipped = false;
        int count = 0;
        int x = 0;
        while (x < this.width) {
            float value = this.getValue(x);
            boolean valueClipped = value < -1.0f || value > 1.0f;
            int y = this.scaleVertical(view, value, height);
            if (valueClipped != clipped) {
                if (valueClipped) {
                    xPts[count] = x;
                    yPts[count] = y;
                    g.drawPolyline(xPts, yPts, count + 1);
                    count = 0;
                    clipped = true;
                    g.setColor(clippedColor);
                } else {
                    g.drawPolyline(xPts, yPts, count);
                    xPts[0] = xPts[count - 1];
                    yPts[0] = yPts[count - 1];
                    count = 1;
                    clipped = false;
                    g.setColor(curveColor);
                }
            }
            xPts[count] = x++;
            yPts[count] = y;
            ++count;
        }
        g.drawPolyline(xPts, yPts, count);
        AwtTools.setupHighSpeed(g);
        x = 0;
        while (x < this.width) {
            float dotValue;
            if (dotSize >= 3 && !Float.isNaN(dotValue = this.getDot(x))) {
                float y = this.scaleVerticalF(view, dotValue, height);
                dotLocation.setToIdentity();
                dotLocation.translate((double)x - dotCenter + 1.0, (double)y - dotCenter);
                if (dotValue >= -1.0f && dotValue <= 1.0f) {
                    g.drawImage(dotImage, dotLocation, null);
                } else {
                    g.drawImage(clippedDotImage, dotLocation, null);
                }
            }
            ++x;
        }
        g.dispose();
    }

    private int scaleVertical(AudioChannelDataRange view, float value, int height) {
        float floor = view.getVerticalFloor();
        float ceil = view.getVerticalCeil();
        float vertSpan = ceil - floor;
        int result = (int)((value - floor) * (float)height / vertSpan + 0.5f);
        return result;
    }

    private float scaleVerticalF(AudioChannelDataRange view, float value, int height) {
        float floor = view.getVerticalFloor();
        float ceil = view.getVerticalCeil();
        float vertSpan = ceil - floor;
        float result = (value - floor) * (float)height / vertSpan + 0.5f;
        return result;
    }

    public void dispose() {
        if (this.bullet != null) {
            this.bullet.flush();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

