/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file.view.waveform;

import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.stats.AudioStatistics;
import ch.tachyon.sonics.gui.file.view.AudioChannelDataRange;
import ch.tachyon.sonics.gui.file.view.DirtyArea;
import ch.tachyon.sonics.gui.file.view.IChannelOfflineDataBuffer;
import ch.tachyon.sonics.gui.file.view.IRefreshObserver;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.corebounce.common.gui.AwtTools;

public class WaveFormOfflineBuffer
implements IChannelOfflineDataBuffer {
    private static final int BUSY_DELAY = 300;
    private static final int BORDER_SIZE = 1;
    private static final Color minMaxColor = new Color(0.3f, 0.1f, 0.7f);
    private static final Color minMaxColorL = new Color(0.28f, 0.145f, 1.0f);
    private static final Color minMaxColorB = new Color(0.1f, 0.0f, 0.0f);
    private static final Color minMaxColorM = new Color(0.2f, 0.1f, 0.8f);
    private static final Color clippedColor = new Color(0.6f, 0.1f, 0.3f);
    private static final Color clippedColorL = new Color(0.9f, 0.145f, 0.28f);
    private static final Color clippedColorM = new Color(0.7f, 0.1f, 0.2f);
    private static final Color loudnessColor = new Color(0.2f, 0.75f, 0.65f);
    private static final Color loudnessColorL = new Color(0.23f, 0.8f, 0.8f);
    private static final Color loudnessColorM = new Color(0.2f, 0.7f, 0.7f);
    static final Color clipAreaColor = new Color(0.25f, 0.25f, 0.25f);
    private static final int XPL = 0;
    private static final int XP = 1;
    private static final int XLL = 2;
    private static final int XL = 3;
    private static final int XB = 4;
    private static final int XZ = 5;
    private static final int XPB = 6;
    private static final int XCL = 7;
    private static final int XC = 8;
    private static final int GW = 9;
    private final int width;
    private final float[] peakMins;
    private final float[] peakMaxs;
    private final float[] loudness;
    private final Color busyColor;
    private final Color backgroundColor;
    private SoftReference<BufferedImage> gradientsRef;
    private SoftReference<VolatileImage> imageRef;
    private final DirtyArea dirtyArea = new DirtyArea();
    private int offlineOffset;
    private long firstBusyTime = -1L;
    private boolean paintBusy = false;

    public WaveFormOfflineBuffer(int width, Color backgroundColor, Color busyColor) {
        this.width = width;
        this.peakMins = new float[width];
        this.peakMaxs = new float[width];
        this.loudness = new float[width];
        this.backgroundColor = backgroundColor;
        this.busyColor = busyColor;
        this.offlineOffset = 0;
    }

    public int getWidth() {
        return this.width;
    }

    public long getSmearAmount() {
        return 0L;
    }

    private int rotate(int x, boolean hiBound) {
        if (hiBound) {
            while (x < 0) {
                x += this.width;
            }
            if ((x += this.offlineOffset) > this.width) {
                x %= this.width;
            }
            return x;
        }
        x = (x + this.offlineOffset + this.width) % this.width;
        return x;
    }

    private int rotate(int x) {
        return this.rotate(x, false);
    }

    public synchronized void markDirty(int startX, int stopX) {
        this.dirtyArea.markDirty(startX, stopX);
        int cutX = this.width - this.offlineOffset;
        if (cutX > startX && cutX < stopX) {
            int dsx = this.rotate(startX, false);
            int dex = this.rotate(cutX, true);
            Arrays.fill(this.peakMins, dsx, dex, Float.NaN);
            Arrays.fill(this.peakMaxs, dsx, dex, Float.NaN);
            Arrays.fill(this.loudness, dsx, dex, Float.NaN);
            dsx = this.rotate(cutX, false);
            dex = this.rotate(stopX, true);
            Arrays.fill(this.peakMins, dsx, dex, Float.NaN);
            Arrays.fill(this.peakMaxs, dsx, dex, Float.NaN);
            Arrays.fill(this.loudness, dsx, dex, Float.NaN);
        } else {
            int dsx = this.rotate(startX, false);
            int dex = this.rotate(stopX, true);
            Arrays.fill(this.peakMins, dsx, dex, Float.NaN);
            Arrays.fill(this.peakMaxs, dsx, dex, Float.NaN);
            Arrays.fill(this.loudness, dsx, dex, Float.NaN);
        }
    }

    public synchronized boolean scroll(int deltaX) {
        if (Math.abs(deltaX) >= this.width) {
            this.markDirty(0, this.width);
            return false;
        }
        VolatileImage image = null;
        if (this.imageRef != null) {
            image = this.imageRef.get();
        }
        if (image != null && !image.contentsLost()) {
            this.offlineOffset = (this.offlineOffset + this.width - deltaX) % this.width;
            assert (this.offlineOffset >= 0 && this.offlineOffset < this.width);
            this.dirtyArea.scroll(deltaX, this.width);
            return true;
        }
        return false;
    }

    public synchronized boolean verticalChange(boolean heightOnly) {
        this.dispose();
        this.imageRef = null;
        this.gradientsRef = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(AudioChannel data, AudioChannelDataRange view, int startX, int stopX, long fileStartPos, double reduction, int height, IRefreshObserver observer) throws IOException {
        long dataLength = data.getLength();
        int x = startX;
        while (x < stopX) {
            block20: {
                block19: {
                    int dxm1;
                    int dx;
                    long startPos = fileStartPos + (long)((double)x * reduction);
                    if (startPos < 0L) {
                        startPos = 0L;
                    }
                    if (startPos >= dataLength) break block19;
                    long stopPos = fileStartPos + (long)((double)(x + 1) * reduction);
                    if (stopPos > dataLength) {
                        stopPos = dataLength;
                    }
                    if (stopPos > startPos) {
                        boolean cont;
                        WaveFormOfflineBuffer waveFormOfflineBuffer = this;
                        synchronized (waveFormOfflineBuffer) {
                            dx = this.rotate(x);
                            dxm1 = this.rotate(x - 1);
                            AudioStatistics stats = data.getStatistics(data, startPos, stopPos - startPos);
                            this.peakMins[dx] = stats.getMin();
                            this.peakMaxs[dx] = stats.getMax();
                            this.loudness[dx] = (float)Math.sqrt(stats.getSqAvg());
                            if (x > 0) {
                                if (this.peakMins[dx] > this.peakMaxs[dxm1]) {
                                    this.peakMins[dx] = this.peakMaxs[dxm1];
                                }
                                if (this.peakMaxs[dx] < this.peakMins[dxm1]) {
                                    this.peakMaxs[dx] = this.peakMins[dxm1];
                                }
                            }
                        }
                        boolean repaintDirty = false;
                        if (this.firstBusyTime >= 0L && !this.paintBusy && System.currentTimeMillis() > this.firstBusyTime + 300L) {
                            repaintDirty = true;
                            this.paintBusy = true;
                        }
                        if (!(cont = observer.refreshed(this, x, startPos, repaintDirty))) {
                            return;
                        }
                        break block20;
                    } else {
                        WaveFormOfflineBuffer waveFormOfflineBuffer = this;
                        synchronized (waveFormOfflineBuffer) {
                            dx = this.rotate(x);
                            dxm1 = this.rotate(x - 1);
                            this.peakMins[dx] = x <= 0 ? 0.0f : this.peakMins[dxm1];
                            this.peakMaxs[dx] = x <= 0 ? 0.0f : this.peakMaxs[dxm1];
                            this.loudness[dx] = x <= 0 ? 0.0f : this.loudness[dxm1];
                        }
                    }
                }
                WaveFormOfflineBuffer waveFormOfflineBuffer = this;
                synchronized (waveFormOfflineBuffer) {
                    int dx = this.rotate(x);
                    this.peakMins[dx] = 0.0f;
                    this.peakMaxs[dx] = 0.0f;
                    this.loudness[dx] = -1.0f;
                }
            }
            ++x;
        }
    }

    private BufferedImage getGradientsImage(int height, GraphicsConfiguration gc) {
        BufferedImage result;
        BufferedImage bufferedImage = result = this.gradientsRef == null ? null : this.gradientsRef.get();
        if (result == null || result.getHeight() != height) {
            if (result != null) {
                result.flush();
            }
            BufferedImage temp = new BufferedImage(9, height, 2);
            Graphics2D g = temp.createGraphics();
            AwtTools.setupHighSpeed(g);
            int mid = height / 2;
            int q1 = height / 4;
            int q3 = height * 3 / 4;
            g.setColor(minMaxColorL);
            g.fillRect(0, 0, 1, height);
            GradientPaint paint = new GradientPaint(1.0f, 0.0f, minMaxColor, 1.0f, mid, minMaxColorM);
            g.setPaint(paint);
            g.fillRect(1, 0, 1, height / 2);
            paint = new GradientPaint(1.0f, mid, minMaxColorM, 1.0f, height, minMaxColor);
            g.setPaint(paint);
            g.fillRect(1, mid, 1, height / 2);
            g.setColor(loudnessColorL);
            g.fillRect(2, 0, 1, height);
            g.setColor(loudnessColor);
            g.fillRect(3, 0, 1, height);
            paint = new GradientPaint(3.0f, q1, loudnessColor, 3.0f, mid, loudnessColorM);
            g.setPaint(paint);
            g.fillRect(3, q1, 1, mid - q1);
            paint = new GradientPaint(3.0f, mid, loudnessColorM, 3.0f, q3, loudnessColor);
            g.setPaint(paint);
            g.fillRect(3, mid, 1, q3 - mid);
            g.setColor(this.busyColor);
            g.fillRect(4, 0, 1, height);
            g.setColor(this.backgroundColor);
            g.fillRect(5, 0, 1, height);
            g.setColor(minMaxColorB);
            g.fillRect(6, 0, 1, height);
            g.setColor(clippedColorL);
            g.fillRect(7, 0, 1, height);
            paint = new GradientPaint(1.0f, 0.0f, clippedColor, 1.0f, mid, clippedColorM);
            g.setPaint(paint);
            g.fillRect(8, 0, 1, height / 2);
            paint = new GradientPaint(1.0f, mid, clippedColorM, 1.0f, height, clippedColor);
            g.setPaint(paint);
            g.fillRect(8, mid, 1, height / 2);
            g.dispose();
            result = gc.createCompatibleImage(9, height, 3);
            g = result.createGraphics();
            g.drawImage((Image)temp, 0, 0, null);
            g.dispose();
            this.gradientsRef = new SoftReference<BufferedImage>(result);
        }
        return result;
    }

    public synchronized void paint(AudioChannelDataRange view, Graphics2D gp, int startX, int stopX, int height) {
        boolean contentLost;
        AwtTools.setupHighSpeed(gp);
        do {
            VolatileImage image = this.prepareOffscreenImage(view, gp.getDeviceConfiguration(), startX, stopX, height);
            startX = 0;
            stopX = this.width;
            int cutX = this.width - this.offlineOffset;
            if (cutX > startX && cutX < stopX) {
                assert (this.width == this.rotate(cutX, true));
                gp.drawImage(image, startX, 0, cutX, height, this.rotate(startX, false), 0, this.width, height, null);
                assert (this.rotate(cutX, false) == 0);
                gp.drawImage(image, cutX, 0, stopX, height, 0, 0, this.rotate(stopX, true), height, null);
            } else {
                assert (this.rotate(stopX, true) > this.rotate(startX, false));
                gp.drawImage(image, startX, 0, stopX, height, this.rotate(startX, false), 0, this.rotate(stopX, true), height, null);
            }
            contentLost = image.contentsLost();
            if (!contentLost) continue;
            this.dirtyArea.markDirty(0, this.width);
        } while (contentLost);
    }

    private VolatileImage prepareOffscreenImage(AudioChannelDataRange view, GraphicsConfiguration gc, int startX, int stopX, int height) {
        VolatileImage image;
        boolean contentLost;
        do {
            image = this.imageRef == null ? null : this.imageRef.get();
            int imageStatus = 0;
            if (image != null) {
                imageStatus = image.validate(gc);
            }
            if (image == null || image.getWidth() != this.width || image.getHeight() != height || imageStatus == 2) {
                if (image != null) {
                    image.flush();
                }
                this.dirtyArea.markDirty(0, this.width);
                image = gc.createCompatibleVolatileImage(this.width, height, 3);
                Graphics2D g1 = image.createGraphics();
                g1.setColor(new Color(0, 0, 0));
                g1.fillRect(0, 0, this.width, height);
                g1.dispose();
                this.imageRef = new SoftReference<VolatileImage>(image);
            } else if (imageStatus == 1) {
                this.dirtyArea.markDirty(0, this.width);
            }
            if (this.dirtyArea.isDirty()) {
                int dx;
                BufferedImage gradients = this.getGradientsImage(height, gc);
                Graphics2D g = image.createGraphics();
                AwtTools.setupHighSpeed(g);
                if (this.dirtyArea.contains(startX, stopX)) {
                    g.setColor(new Color(0, 0, 0, 0));
                    g.setComposite(AlphaComposite.Src);
                    int sx = Math.max(startX, this.dirtyArea.startX);
                    int ex = Math.min(stopX, this.dirtyArea.stopX);
                    int cutX = this.width - this.offlineOffset;
                    if (cutX > sx && cutX < ex) {
                        g.fillRect(this.rotate(sx), 0, cutX - sx, height);
                        g.fillRect(this.rotate(cutX), 0, ex - cutX, height);
                    } else {
                        g.fillRect(this.rotate(sx), 0, ex - sx, height);
                    }
                }
                g.setComposite(AlphaComposite.SrcOver);
                float floor = view.getVerticalFloor();
                float ceil = view.getVerticalCeil();
                if (floor < -1.0f) {
                    int yf = this.scaleVertical(view, -1.0f, height);
                    g.setColor(clipAreaColor);
                    g.fillRect(0, height - yf, this.width, yf);
                }
                if (ceil > 1.0f) {
                    int yc = this.scaleVertical(view, 1.0f, height);
                    g.setColor(clipAreaColor);
                    g.fillRect(0, 0, this.width, height - yc);
                }
                int x = startX;
                while (x < stopX) {
                    if (this.dirtyArea.contains(x)) {
                        dx = this.rotate(x);
                        if (this.peakMins[dx] >= -1.0f && this.peakMaxs[dx] <= 1.0f) {
                            this.paintMinMaxColumn(view, g, gradients, 6, dx, height, 1);
                            this.paintMinMaxColumn(view, g, gradients, 0, dx, height, 0);
                            this.paintMinMaxColumn(view, g, gradients, 1, dx, height, -1);
                        } else {
                            this.paintMinMaxColumn(view, g, gradients, 6, dx, height, 1);
                            this.paintMinMaxColumn(view, g, gradients, 7, dx, height, 0);
                            this.paintMinMaxColumn(view, g, gradients, 8, dx, height, -1);
                        }
                    }
                    ++x;
                }
                x = startX;
                while (x < stopX) {
                    if (this.dirtyArea.contains(x)) {
                        this.paintLoudnessColumn(view, g, gradients, 2, this.rotate(x), height, 0);
                        this.paintLoudnessColumn(view, g, gradients, 3, this.rotate(x), height, -1);
                    }
                    ++x;
                }
                x = startX;
                while (x < stopX) {
                    dx = this.rotate(x);
                    float loudness = this.loudness[dx];
                    if (Float.isNaN(loudness)) {
                        if (this.paintBusy) {
                            this.dirtyArea.markDirty(x, x + 1);
                            g.drawImage(gradients, dx, 0, dx + 1, height, 4, 0, 5, height, null);
                        }
                    } else if (loudness < 0.0f) {
                        g.drawImage(gradients, dx, 0, dx + 1, height, 5, 0, 6, height, null);
                        this.dirtyArea.markClean(x);
                    } else {
                        this.dirtyArea.markClean(x);
                    }
                    ++x;
                }
                if (!this.dirtyArea.isDirty()) {
                    this.firstBusyTime = -1L;
                    this.paintBusy = false;
                } else if (this.firstBusyTime < 0L) {
                    this.firstBusyTime = System.currentTimeMillis();
                }
                g.dispose();
            }
            if (!(contentLost = image.contentsLost())) continue;
            this.dirtyArea.markDirty(0, this.width);
        } while (contentLost);
        return image;
    }

    private void paintMinMaxColumn(AudioChannelDataRange view, Graphics2D g, Image gradients, int gx, int dx, int height, int grow) {
        float peakMin = this.peakMins[dx];
        float peakMax = this.peakMaxs[dx];
        if (Float.isNaN(peakMin)) {
            return;
        }
        int minY = this.scaleVertical(view, peakMin, height) - grow;
        int maxY = this.scaleVertical(view, peakMax, height) + grow;
        if (maxY >= minY) {
            minY = this.swapVert(minY, height);
            maxY = this.swapVert(maxY, height);
            g.drawImage(gradients, dx, maxY, dx + 1, minY + 1, gx, maxY, gx + 1, minY + 1, null);
        }
    }

    private void paintLoudnessColumn(AudioChannelDataRange view, Graphics2D g, Image gradients, int gx, int dx, int height, int grow) {
        float loudness = this.loudness[dx];
        if (Float.isNaN(loudness)) {
            return;
        }
        float peakMin = this.peakMins[dx];
        float peakMax = this.peakMaxs[dx];
        int minL = this.scaleVertical(view, -loudness, height) - grow;
        int maxL = this.scaleVertical(view, loudness, height) + grow;
        if (maxL >= minL && loudness != 0.0f) {
            if (-loudness < peakMin || loudness > peakMax) {
                int minY = this.scaleVertical(view, peakMin, height) + 1;
                int maxY = this.scaleVertical(view, peakMax, height) - 1;
                minL = Math.max(minL, minY);
                maxL = Math.min(maxL, maxY);
            }
            if (maxL >= minL) {
                minL = this.swapVert(minL, height);
                maxL = this.swapVert(maxL, height);
                g.drawImage(gradients, dx, maxL, dx + 1, minL + 1, gx, maxL, gx + 1, minL + 1, null);
            }
        }
    }

    private int scaleVertical(AudioChannelDataRange view, float value, int height) {
        float floor = view.getVerticalFloor();
        float ceil = view.getVerticalCeil();
        float vertSpan = ceil - floor;
        int result = (int)((value - floor) * (float)height / vertSpan + 0.5f);
        return WaveFormOfflineBuffer.cropCoord(result, height);
    }

    private int swapVert(int y, int height) {
        return height - y;
    }

    private static int cropCoord(int coord, int max) {
        if (coord < 0) {
            return 0;
        }
        if (coord > max) {
            return max;
        }
        return coord;
    }

    public void dispose() {
        VolatileImage image;
        BufferedImage gradient;
        if (this.gradientsRef != null && (gradient = this.gradientsRef.get()) != null) {
            gradient.flush();
        }
        if (this.imageRef != null && (image = this.imageRef.get()) != null) {
            image.flush();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

