/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.help;

import ch.tachyon.sonics.gui.help.LegalInfoDialog;
import ch.tachyon.sonics.gui.help.SystemInfoDialog;
import ch.tachyon.sonics.gui.icon.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.PlatformType;

public class AboutDialog
extends JDialog {
    private JButton okButton;

    public AboutDialog(JFrame owner) {
        super(owner);
        super.setTitle("About Tachyon Sonics");
        super.setModal(true);
        super.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel aboutPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.weightx = 1.0;
        aboutPanel.setLayout(new TableLayout(2, gbc));
        JPanel outer = new JPanel();
        outer.setLayout(new FlowLayout());
        outer.add(aboutPanel);
        this.getContentPane().add((Component)outer, "Center");
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new FlowLayout(1, 20, 20));
        JLabel title = new JLabel("Tachyon Sonics");
        title.setFont(title.getFont().deriveFont(1, title.getFont().getSize2D() * 2.0f));
        title.setIcon(IconLoader.getIcon(Icons.class, "AppIcon.png", -1));
        title.setIconTextGap(10);
        titlePanel.add(title);
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        aboutPanel.add((Component)titlePanel, gbc);
        JLabel lblEdition = new JLabel("Edition");
        aboutPanel.add(lblEdition);
        JLabel valEdition = new JLabel("Free Edition");
        aboutPanel.add(valEdition);
        JLabel lblVersion = new JLabel("Version");
        aboutPanel.add(lblVersion);
        JLabel valVersion = new JLabel("0.1.0.0 (alpha)");
        aboutPanel.add(valVersion);
        JLabel lblCopyright = new JLabel("Copyright");
        aboutPanel.add(lblCopyright);
        JLabel valCopyright = new JLabel("\u00a9 2011-2013 PitchTech");
        aboutPanel.add(valCopyright);
        JLabel lblLicense = new JLabel("License");
        aboutPanel.add(lblLicense);
        JLabel valLicense = new JLabel("FW-NC");
        valLicense.setToolTipText("Freeware for non-commercial use only");
        aboutPanel.add(valLicense);
        PlatformType pt = Platform.getPlatform();
        JLabel lblOs = new JLabel();
        if (Platform.isSupportedPlatform()) {
            lblOs.setText("Optimized for");
        } else {
            lblOs.setText("Running on");
        }
        aboutPanel.add(lblOs);
        JLabel valOs = new JLabel(String.valueOf(System.getProperty("os.name")) + " (" + System.getProperty("os.arch") + ")");
        valOs.setToolTipText(System.getProperty("os.version"));
        valOs.setIcon(Platform.getPlatformIcon(pt));
        aboutPanel.add(valOs);
        JLabel lblAuthor = new JLabel("Author");
        aboutPanel.add(lblAuthor);
        JLabel valAuthor = new JLabel("Nicolas Juillerat");
        valAuthor.setToolTipText("Thanks to Philippe Lang and B\u00e9at Hirsbrunner for help and support");
        aboutPanel.add(valAuthor);
        JLabel lblMadeIn = new JLabel("Made in");
        aboutPanel.add(lblMadeIn);
        JLabel valMadeIn = new JLabel("Switzerland");
        valMadeIn.setIcon(IconLoader.getIcon(AboutDialog.class, "flag-ch.png", -1));
        aboutPanel.add(valMadeIn);
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(10, 10));
        aboutPanel.add(spacer);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BorderLayout());
        JPanel infoPanel = new JPanel();
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.weightx = 1.0;
        infoPanel.setLayout(new TableLayout(2, gbc0));
        buttonsPanel.add((Component)infoPanel, "Center");
        AbstractAction legalAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.displayLegalInfo();
            }
        };
        JButton btnLegal = new JButton(legalAction);
        btnLegal.setText("Legal Info...");
        btnLegal.setMnemonic(76);
        btnLegal.setToolTipText("Display copyright and license information");
        AwtTools.addKeyboardShortcut((AbstractButton)btnLegal, 76);
        infoPanel.add(btnLegal);
        if (Platform.isMacOsX()) {
            btnLegal.putClientProperty("JComponent.sizeVariant", "small");
        }
        AbstractAction systemAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.displaySystemInfo();
            }
        };
        JButton btnSystemInfo = new JButton(systemAction);
        btnSystemInfo.setText("System Info...");
        btnSystemInfo.setMnemonic(83);
        btnSystemInfo.setToolTipText("Display system information");
        AwtTools.addKeyboardShortcut((AbstractButton)btnSystemInfo, 83);
        infoPanel.add(btnSystemInfo);
        if (Platform.isMacOsX()) {
            btnSystemInfo.putClientProperty("JComponent.sizeVariant", "small");
        }
        JPanel okPanel = new JPanel();
        okPanel.setLayout(new FlowLayout(1, 10, 10));
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.okClicked(e);
            }
        };
        this.okButton = new JButton(okAction);
        this.okButton.setText("OK");
        this.okButton.setMnemonic(79);
        AwtTools.addKeyboardShortcut((AbstractButton)this.okButton, 27);
        AwtTools.addKeyboardShortcut((AbstractButton)this.okButton, 79);
        okPanel.add(this.okButton);
        buttonsPanel.add((Component)okPanel, "South");
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent e) {
                AboutDialog.this.okButton.requestFocusInWindow();
            }
        });
    }

    private void okClicked(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    private void displayLegalInfo() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        LegalInfoDialog dialog = new LegalInfoDialog(this);
        dialog.pack();
        AwtTools.centerWindowOn(dialog, this);
        dialog.setVisible(true);
        this.setCursor(null);
    }

    private void displaySystemInfo() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        SystemInfoDialog dialog = new SystemInfoDialog(this);
        dialog.pack();
        AwtTools.centerWindowOn(dialog, this);
        dialog.setVisible(true);
        this.setCursor(null);
    }
}

