/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.help;

import ch.tachyon.sonics.TachyonSonics;
import ch.tachyon.sonics.gui.help.PackageLegalInfo;
import ch.tachyon.sonics.gui.help.PackageType;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.io.IOUtils;
import org.corebounce.common.io.ResourceLoader;
import org.corebounce.common.utils.AppUtils;
import org.corebounce.common.utils.ClassLoaderUtils;

public class LegalInfoDialog
extends JDialog {
    private List<PackageLegalInfo> packageInfos = new ArrayList<PackageLegalInfo>();
    private PackageLegalInfo selectedPackage = null;
    private JComponent packageDetailsCmp = null;

    public LegalInfoDialog(Dialog owner) {
        super(owner, "Legal Information", true);
        super.setResizable(true);
        this.gatherPackageInfos();
        if (!this.packageInfos.isEmpty()) {
            this.selectedPackage = this.packageInfos.get(0);
        }
        super.setLayout(new BorderLayout());
        super.add((Component)this.getHead(), "North");
        super.add((Component)this.getFoot(), "South");
        super.add((Component)this.getList(), "West");
        super.add((Component)this.getDetails(), "Center");
        this.setPreferredSize(new Dimension(900, 700));
    }

    private JComponent getHead() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(3));
        JLabel label = new JLabel("<html><body><b>This application uses the following components.</b><p>Click on a component to read the corresponding legal info.</body></html>");
        label.setFont(this.getFont().deriveFont(this.getFont().getSize2D() * 1.25f));
        panel.add(label);
        return panel;
    }

    private JComponent getFoot() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1));
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LegalInfoDialog.this.close();
            }
        };
        final JButton btnClose = new JButton(closeAction);
        btnClose.setText("Close");
        btnClose.setMnemonic(67);
        AwtTools.addKeyboardShortcut((AbstractButton)btnClose, 27);
        panel.add(btnClose);
        this.getRootPane().setDefaultButton(btnClose);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                btnClose.requestFocusInWindow();
            }
        });
        return panel;
    }

    private JComponent getList() {
        JPanel result = new JPanel();
        result.setBorder(new TitledBorder("Components"));
        result.setLayout(new BorderLayout());
        final JList<Object> list = new JList<Object>(this.packageInfos.toArray());
        if (!this.packageInfos.isEmpty()) {
            list.setSelectedIndex(0);
        }
        list.setSelectionMode(0);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Object selection;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (LegalInfoDialog.this.packageDetailsCmp != null) {
                    LegalInfoDialog.this.remove(LegalInfoDialog.this.packageDetailsCmp);
                    LegalInfoDialog.this.packageDetailsCmp = null;
                }
                if ((selection = list.getSelectedValue()) instanceof PackageLegalInfo) {
                    LegalInfoDialog.this.selectedPackage = (PackageLegalInfo)selection;
                    LegalInfoDialog.this.add((Component)LegalInfoDialog.this.getDetails(), "Center");
                }
                LegalInfoDialog.this.validate();
                LegalInfoDialog.this.repaint();
            }
        });
        JScrollPane scroller = new JScrollPane(list);
        result.add((Component)scroller, "Center");
        return result;
    }

    private JComponent getDetails() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.setBorder(new TitledBorder("Details"));
        JPanel summary = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 6, 1, 6);
        gbc.anchor = 23;
        summary.setLayout(new TableLayout(2, gbc));
        this.insertLabelValue(summary, "Name", this.selectedPackage.toString());
        this.insertLabelValue(summary, "Version", this.selectedPackage.version);
        this.insertLabelValue(summary, "Description", this.selectedPackage.description);
        this.insertLabelValue(summary, "Author", this.selectedPackage.author);
        this.insertLabelValue(summary, "Vendor", this.selectedPackage.vendor);
        this.insertLabelValue(summary, "Copyright", this.selectedPackage.copyright);
        if (this.selectedPackage.type != null) {
            this.insertLabelValue(summary, "Type", this.selectedPackage.type.toString());
        }
        this.insertLabelValue(summary, "File", this.selectedPackage.jarName);
        JPanel lefter = new JPanel();
        lefter.setLayout(new BorderLayout());
        lefter.add((Component)summary, "West");
        lefter.setBorder(new EmptyBorder(6, 6, 6, 6));
        result.add((Component)lefter, "North");
        JPanel licensePanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        licensePanel.setLayout(new TableLayout(1, gbc));
        result.add((Component)licensePanel, "Center");
        this.insertTextInfo(licensePanel, this.selectedPackage.license, "License", true);
        this.insertTextInfo(licensePanel, this.selectedPackage.notice, "Notice", false);
        this.packageDetailsCmp = result;
        return result;
    }

    private void insertLabelValue(JPanel panel, String label, String value) {
        if (value == null) {
            return;
        }
        JLabel labelCmp = new JLabel(label);
        labelCmp.setFont(panel.getFont().deriveFont(1));
        panel.add(labelCmp);
        JLabel valueCmp = new JLabel(value);
        panel.add(valueCmp);
    }

    private void insertTextInfo(JPanel licensePanel, String textInfo, String title, boolean showIfNull) {
        JTextArea textArea;
        JTextComponent scrollTarget;
        if (textInfo != null) {
            if (textInfo.toLowerCase().contains("<html")) {
                JEditorPane htmlPanel = new JEditorPane();
                htmlPanel.setEditable(false);
                htmlPanel.setAutoscrolls(true);
                htmlPanel.setContentType("text/html");
                String html = textInfo.substring(textInfo.toLowerCase().indexOf("<html"));
                String pattern = "<meta http-equiv=\"Content-Type\".*?/>";
                html = html.replaceAll(pattern, "");
                pattern = "<meta http-equiv=\"Content-Type\".*?>.*?</meta>";
                html = html.replaceFirst(pattern, "");
                htmlPanel.setText(html);
                htmlPanel.setCaretPosition(0);
                scrollTarget = htmlPanel;
            } else {
                textArea = new JTextArea();
                textArea.setEditable(false);
                textArea.setLineWrap(false);
                textArea.setText(textInfo);
                textArea.setCaretPosition(0);
                scrollTarget = textArea;
            }
        } else {
            if (!showIfNull) {
                return;
            }
            textArea = new JTextArea();
            textArea.setEditable(false);
            textArea.setLineWrap(false);
            textArea.setText("Unknown");
            scrollTarget = textArea;
        }
        JScrollPane scroller = new JScrollPane(scrollTarget);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)scroller, "Center");
        panel.setBorder(new TitledBorder(title));
        licensePanel.add(panel);
    }

    /*
     * Unable to fully structure code
     */
    private void gatherPackageInfos() {
        classPaths = ClassLoaderUtils.getClassPath(TachyonSonics.class);
        pluginDir = new File(AppUtils.getApplicationDirectory(TachyonSonics.class), "plugins");
        pluginFiles = pluginDir.listFiles();
        if (pluginFiles != null) {
            var7_4 = pluginFiles;
            var6_5 = pluginFiles.length;
            var5_7 = 0;
            while (var5_7 < var6_5) {
                pluginFile = var7_4[var5_7];
                if (pluginFile.getName().endsWith(".jar")) {
                    classPaths.add(pluginFile.getAbsolutePath());
                }
                ++var5_7;
            }
        }
        for (String classPath : classPaths) {
            block51: {
                block50: {
                    file = new File(classPath);
                    info = null;
                    if (!file.isFile()) break block50;
                    info = new PackageLegalInfo();
                    info.jarName = file.getName();
                    try {
                        jarFile = new JarFile(file);
                        subs = file.getName().replace(".jar", ".txt");
                        stream = this.getClass().getResourceAsStream(subs);
                        if (stream != null) {
                            mf = new Manifest(stream);
                            info.fromMetaInf(mf.getMainAttributes());
                            IOUtils.close(stream);
                        }
                        if ((manifest = jarFile.getJarEntry("META-INF/MANIFEST.MF")) != null) {
                            stream = jarFile.getInputStream(manifest);
                            mf = new Manifest(stream);
                            info.fromMetaInf(mf.getMainAttributes());
                            IOUtils.close(stream);
                        }
                        type = PackageType.CORE;
                        if (jarFile.getJarEntry("META-INF/services/ch.tachyon.tunnel.Plugins") != null) {
                            type = PackageType.PLUGINS;
                        } else if (jarFile.getJarEntry("META-INF/services/javax.sound.sampled.spi.AudioFileReader") != null) {
                            type = PackageType.JAVASOUND_SPI;
                        } else if (jarFile.getJarEntry("META-INF/services/javax.sound.sampled.spi.AudioFileWriter") != null) {
                            type = PackageType.JAVASOUND_SPI;
                        } else if (jarFile.getJarEntry("META-INF/services/javax.sound.sampled.spi.FormatConversionProvider") != null) {
                            type = PackageType.JAVASOUND_SPI;
                        } else if (jarFile.getJarEntry("META-INF/services/org.corebounce.audio.file.FileReader") != null) {
                            type = PackageType.JAVASOUND_SPI;
                        }
                        info.type = type;
                        rootPackage = null;
                        iter = jarFile.entries();
                        while (iter.hasMoreElements()) {
                            entry = iter.nextElement();
                            if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class")) continue;
                            if (rootPackage != null) ** GOTO lbl59
                            rootPackage = entryName.substring(0, entryName.length() - ".class".length());
                            continue;
lbl-1000:
                            // 1 sources

                            {
                                rootPackage = rootPackage.substring(0, rootPackage.length() - 1);
lbl59:
                                // 2 sources

                                ** while (!entryName.startsWith((String)rootPackage))
                            }
lbl60:
                            // 1 sources

                        }
                        if (rootPackage != null && rootPackage.contains("/")) {
                            info.rootPackage = rootPackage.replace('/', '.');
                            if (info.rootPackage.endsWith(".")) {
                                info.rootPackage = info.rootPackage.substring(0, info.rootPackage.length() - 1);
                            }
                        }
                        if ((license = jarFile.getJarEntry("META-INF/LICENSE")) == null) {
                            license = jarFile.getJarEntry("LICENSE");
                        }
                        if (license == null) {
                            license = jarFile.getJarEntry("META-INF/LICENSE.txt");
                        }
                        if (license == null) {
                            license = jarFile.getJarEntry("LICENSE.txt");
                        }
                        if (license != null) {
                            stream = jarFile.getInputStream(license);
                            reader = new InputStreamReader(stream, Charset.forName("UTF-8"));
                            info.license = ResourceLoader.getResourceAsString(reader);
                            IOUtils.close(reader);
                        } else {
                            subs = file.getName().replace(".jar", ".license");
                            stream = this.getClass().getResourceAsStream(subs);
                            if (stream != null) {
                                reader = new InputStreamReader(stream, Charset.forName("UTF-8"));
                                info.license = ResourceLoader.getResourceAsString(reader);
                                IOUtils.close(reader);
                            }
                        }
                        notice = jarFile.getJarEntry("META-INF/NOTICE");
                        if (notice == null) {
                            notice = jarFile.getJarEntry("NOTICE");
                        }
                        if (notice == null) {
                            notice = jarFile.getJarEntry("META-INF/NOTICE.txt");
                        }
                        if (notice == null) {
                            notice = jarFile.getJarEntry("NOTICE.txt");
                        }
                        if (notice != null) {
                            stream = jarFile.getInputStream(notice);
                            reader = new InputStreamReader(stream, Charset.forName("UTF-8"));
                            info.notice = ResourceLoader.getResourceAsString(reader);
                            IOUtils.close(reader);
                        }
                        jarFile.close();
                    }
                    catch (IOException ex) {
                        Debug.warn((Throwable)ex);
                    }
                    break block51;
                }
                if (file.isDirectory()) {
                    info = new PackageLegalInfo();
                    info.jarName = file.getName();
                    try {
                        manifest = new File(file, "META-INF/MANIFEST.MF");
                        if (manifest.isFile()) {
                            stream = new FileInputStream(manifest);
                            mf = new Manifest(stream);
                            info.fromMetaInf(mf.getMainAttributes());
                            IOUtils.close(stream);
                        }
                        type = PackageType.CORE;
                        if (new File(file, "META-INF/services/ch.tachyon.tunnel.Plugins").isFile()) {
                            type = PackageType.PLUGINS;
                        } else if (new File(file, "META-INF/services/javax.sound.sampled.spi.AudioFileReader").isFile()) {
                            type = PackageType.JAVASOUND_SPI;
                        } else if (new File(file, "META-INF/services/javax.sound.sampled.spi.AudioFileWriter").isFile()) {
                            type = PackageType.JAVASOUND_SPI;
                        } else if (new File(file, "META-INF/services/javax.sound.sampled.spi.FormatConversionProvider").isFile()) {
                            type = PackageType.JAVASOUND_SPI;
                        }
                        info.type = type;
                        license = new File(file, "META-INF/LICENSE");
                        if (!license.isFile()) {
                            license = new File(file, "LICENSE");
                        }
                        if (!license.isFile()) {
                            license = new File(file, "META-INF/LICENSE.txt");
                        }
                        if (!license.isFile()) {
                            license = new File(file, "LICENSE.txt");
                        }
                        if (license.isFile()) {
                            stream = new FileInputStream(license);
                            reader = new InputStreamReader((InputStream)stream, Charset.forName("UTF-8"));
                            info.license = ResourceLoader.getResourceAsString(reader);
                            IOUtils.close(reader);
                        }
                        if (!(notice = new File(file, "META-INF/NOTICE")).isFile()) {
                            notice = new File(file, "NOTICE");
                        }
                        if (!notice.isFile()) {
                            notice = new File(file, "META-INF/NOTICE.txt");
                        }
                        if (!notice.isFile()) {
                            notice = new File(file, "NOTICE.txt");
                        }
                        if (notice.isFile()) {
                            stream = new FileInputStream(notice);
                            reader = new InputStreamReader((InputStream)stream, Charset.forName("UTF-8"));
                            info.notice = ResourceLoader.getResourceAsString(reader);
                            IOUtils.close(reader);
                        }
                    }
                    catch (IOException ex) {
                        Debug.warn((Throwable)ex);
                    }
                }
            }
            if (info == null || "jsmooth".equals(info.rootPackage)) continue;
            this.packageInfos.add(info);
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }
}

