/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.help;

import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.ThreadUtils;
import ch.tachyon.tunnel.utils.Utils;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.EnumControl;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.ReflectUtils;

public class SystemInfoDialog
extends JDialog {
    private static final int NB_COLUMNS = 120;
    private JTextArea area;
    private String systemInfo = SystemInfoDialog.getSystemInfo(true, true);

    public SystemInfoDialog(Dialog owner) {
        super(owner, "System Information", true);
        super.setResizable(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.area = new JTextArea();
        this.area.setEditable(false);
        this.area.setText(this.systemInfo);
        this.area.setCaretPosition(0);
        JScrollPane scroller = new JScrollPane(this.area);
        scroller.setPreferredSize(AwtTools.getTypicalDimension((Graphics2D)owner.getGraphics(), 120, 60, 0, 0));
        this.getContentPane().add((Component)scroller, "Center");
        JPanel buttonPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        buttonPanel.setLayout(new TableLayout(3, gbc));
        this.getContentPane().add((Component)buttonPanel, "South");
        AbstractAction copyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInfoDialog.this.copy();
            }
        };
        JButton btnCopy = new JButton(copyAction);
        btnCopy.setText("Copy to Clipboard");
        btnCopy.setMnemonic(79);
        btnCopy.setToolTipText("Copy the system information to the clipboard so you can paste it in a text editor");
        JPanel copyPanel = new JPanel();
        copyPanel.setLayout(new FlowLayout());
        copyPanel.add(btnCopy);
        buttonPanel.add(copyPanel);
        AbstractAction gcAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInfoDialog.this.gc(e);
            }
        };
        JButton btnGc = new JButton(gcAction);
        btnGc.setText("GC");
        btnGc.setMnemonic(71);
        btnGc.setToolTipText("Attempt to force garbage collection and refresh displayed information");
        JPanel gcPanel = new JPanel();
        gcPanel.setLayout(new FlowLayout());
        gcPanel.add(btnGc);
        buttonPanel.add(gcPanel);
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SystemInfoDialog.this.close();
            }
        };
        final JButton btnClose = new JButton(closeAction);
        btnClose.setText("Close");
        btnClose.setMnemonic(67);
        AwtTools.addKeyboardShortcut((AbstractButton)btnClose, 27);
        JPanel closePanel = new JPanel();
        closePanel.setLayout(new FlowLayout());
        closePanel.add(btnClose);
        buttonPanel.add(closePanel);
        this.getRootPane().setDefaultButton(btnClose);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                btnClose.requestFocusInWindow();
            }
        });
    }

    public static String getSystemInfo(boolean includeUserInfo, boolean includeEnv) {
        String value;
        HashSet<String> userProps = new HashSet<String>(Arrays.asList("user.dir", "user.home", "user.name"));
        StringBuilder info = new StringBuilder();
        info.append("Runtime information");
        info.append("\n Platform: ");
        info.append(Platform.getPlatform().toString());
        info.append("\n Architecture: ");
        info.append(System.getProperty("os.arch"));
        Runtime runtime = Runtime.getRuntime();
        info.append("\n Number of CPU cores: ");
        info.append(runtime.availableProcessors());
        long totalMemory = runtime.totalMemory();
        long maxMemory = runtime.maxMemory();
        long freeMemory = runtime.freeMemory();
        info.append("\n Used memory: ");
        info.append(SystemInfoDialog.formatMem(totalMemory - freeMemory));
        info.append("\n Free memory: ");
        info.append(SystemInfoDialog.formatMem(freeMemory + (maxMemory - totalMemory)));
        info.append("\n Available memory: ");
        info.append(SystemInfoDialog.formatMem(runtime.maxMemory()));
        info.append("\n Current heap size: ");
        info.append(SystemInfoDialog.formatMem(totalMemory));
        info.append("\n Java: ");
        info.append(String.valueOf(System.getProperty("java.vm.name")) + " " + System.getProperty("java.version") + " [" + System.getProperty("java.specification.version") + "]" + " (" + System.getProperty("java.vendor") + ")");
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = runtimeMxBean.getInputArguments();
            info.append("\n");
            info.append(SystemInfoDialog.wrap(" VM Arguments: " + arguments.toString()));
        }
        catch (Throwable ex) {
            Debug.error((Throwable)ex);
        }
        info.append("\n\nToolkit information");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        info.append("\n Screen resolution: ");
        info.append(toolkit.getScreenResolution());
        info.append("\n Screen size: ");
        info.append(String.valueOf(toolkit.getScreenSize().width) + "x" + toolkit.getScreenSize().height);
        info.append("\n Color model: ");
        info.append(toolkit.getColorModel());
        try {
            GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            info.append("\n Graphics memory: ");
            if (device.getAvailableAcceleratedMemory() == -1) {
                info.append("unknown");
            } else {
                info.append(SystemInfoDialog.formatMem((long)device.getAvailableAcceleratedMemory() & 0xFFFFFFFFL));
            }
            info.append("\n Bit depth: ");
            DisplayMode dm = device.getDisplayMode();
            info.append(dm == null ? "<unknown display mode>" : Integer.valueOf(dm.getBitDepth()));
            info.append("\n Refresh rate: ");
            info.append(dm == null ? "<unknown display mode>" : Integer.valueOf(dm.getRefreshRate()));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            info.append("\n " + ex.toString());
        }
        try {
            BufferCapabilities caps = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBufferCapabilities();
            info.append("\n Page flipping: ");
            info.append(caps.isPageFlipping() && caps.isFullScreenRequired());
            info.append("\n Offscreen image acceleration: ");
            info.append(caps.getBackBufferCapabilities().isAccelerated());
            info.append("\n Offscreen image volatile: ");
            info.append(caps.getBackBufferCapabilities().isTrueVolatile());
            info.append("\n Onscreen image acceleration: ");
            info.append(caps.getFrontBufferCapabilities().isAccelerated());
            info.append("\n Onscreen image volatile: ");
            info.append(caps.getFrontBufferCapabilities().isTrueVolatile());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            info.append("\n " + ex.toString());
        }
        info.append("\n\nSystem properties");
        Properties sProps = System.getProperties();
        TreeMap<String, String> props = new TreeMap<String, String>();
        for (Object key : sProps.keySet()) {
            value = sProps.getProperty(String.valueOf(key));
            props.put(SystemInfoDialog.format(key), SystemInfoDialog.format(value));
        }
        for (Object key : props.keySet()) {
            if (!includeUserInfo && userProps.contains(((String)key).toLowerCase())) continue;
            value = (String)props.get(key);
            info.append("\n");
            info.append(SystemInfoDialog.wrap(" " + (String)key + "=" + value));
        }
        if (!Platform.isBelowJava16()) {
            info.append("\n\nFilesystem Roots");
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File root = fileArray[n2];
                long usableSpace = (Long)ReflectUtils.invokeMethod(File.class, root, "getUsableSpace", null, null);
                long freeSpace = (Long)ReflectUtils.invokeMethod(File.class, root, "getFreeSpace", null, null);
                long totalSpace = (Long)ReflectUtils.invokeMethod(File.class, root, "getTotalSpace", null, null);
                info.append("\n " + root.getAbsolutePath() + " " + SystemInfoDialog.formatMem(usableSpace) + " / " + SystemInfoDialog.formatMem(freeSpace) + " / " + SystemInfoDialog.formatMem(totalSpace));
                ++n2;
            }
        }
        if (includeEnv) {
            info.append("\n\nEnvironment variables");
            Map<String, String> env = System.getenv();
            for (String key : env.keySet()) {
                String value2 = env.get(key);
                info.append("\n");
                info.append(SystemInfoDialog.wrap(" " + key + "=" + value2));
            }
        }
        info.append("\n\nAudio information");
        SystemInfoDialog.dumpJavaSoundInfo(info);
        return info.toString();
    }

    private static String format(Object obj) {
        if (obj instanceof Integer || obj instanceof Long) {
            Long value = ((Number)obj).longValue();
            DecimalFormat format = new DecimalFormat("#,##0");
            return format.format(value);
        }
        if (obj instanceof Float || obj instanceof Double) {
            Double value = ((Number)obj).doubleValue();
            DecimalFormat format = new DecimalFormat("#,##0.0##");
            return format.format(value);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            str = str.replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r");
            return str;
        }
        return String.valueOf(obj);
    }

    private static String formatMem(double value) {
        String[] suffixes = new String[]{"B", "KB", "MB", "GB", "TB"};
        int suffixIndex = 0;
        while (value >= 1300.0 && suffixIndex < suffixes.length - 1) {
            value /= 1024.0;
            ++suffixIndex;
        }
        DecimalFormat format = new DecimalFormat("#0.##");
        return format.format(value) + " " + suffixes[suffixIndex];
    }

    private static String wrap(String str) {
        int offset = 120;
        while (str.length() - offset > 0) {
            str = String.valueOf(str.substring(0, offset)) + "\n" + str.substring(offset);
            offset += 121;
        }
        return str;
    }

    private static void dumpJavaSoundInfo(StringBuilder target) {
        final StringBuffer info = new StringBuffer();
        final AtomicBoolean blocked = new AtomicBoolean(true);
        Thread soundDumper = new Thread("JavaSound Dumper"){

            public void run() {
                Mixer.Info[] mixerInfos;
                Mixer.Info[] infoArray = mixerInfos = AudioSystem.getMixerInfo();
                int n = mixerInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    Mixer.Info mixerInfo = infoArray[n2];
                    info.append("\n Mixer: " + mixerInfo);
                    Mixer mixer = AudioSystem.getMixer(mixerInfo);
                    try {
                        Line.Info[] lineInfos = mixer.getSourceLineInfo();
                        SystemInfoDialog.dumpLineInfos(mixer, lineInfos, "Output", "Capture", info);
                        lineInfos = mixer.getTargetLineInfo();
                        SystemInfoDialog.dumpLineInfos(mixer, lineInfos, "Input", "Playback", info);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        info.append("\n  *** Mixer not available: " + ex.getClass().getName() + ": " + ex.getMessage());
                    }
                    ++n2;
                }
                blocked.set(false);
            }
        };
        soundDumper.setDaemon(true);
        soundDumper.start();
        ThreadUtils.join((Thread)soundDumper, (long)8000L);
        if (blocked.get()) {
            target.append(info);
            target.append("\n Failed to get audio information (operation timed out)");
        } else if (info.length() > 0) {
            target.append(info);
        } else {
            target.append("\n No audio device found. Playback and recording are not possible on this system");
        }
    }

    private static void dumpLineInfos(Mixer mixer, Line.Info[] lineInfos, String linePrefix, String portPrefix, StringBuffer info) throws LineUnavailableException {
        Line.Info[] infoArray = lineInfos;
        int n = lineInfos.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Line.Info lineInfo = infoArray[n2];
            if (lineInfo instanceof DataLine.Info) {
                info.append("\n   " + linePrefix + " line: " + lineInfo);
                DataLine.Info dlInfo = (DataLine.Info)lineInfo;
                AudioFormat[] audioFormatArray = dlInfo.getFormats();
                n3 = audioFormatArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    AudioFormat format = audioFormatArray[n4];
                    info.append("\n     " + linePrefix + format.toString());
                    ++n4;
                }
            } else if (lineInfo instanceof Port.Info) {
                info.append("\n   " + portPrefix + " port: " + lineInfo);
            } else {
                info.append("\n   Unknown stuff: " + lineInfo);
            }
            Line line = mixer.getLine(lineInfo);
            info.append("\n     Type: " + line.getClass().getName());
            if (!(line instanceof Clip)) {
                Control[] controls;
                Control[] controlArray = controls = line.getControls();
                int n5 = controls.length;
                n3 = 0;
                while (n3 < n5) {
                    Control control = controlArray[n3];
                    SystemInfoDialog.dumpControlInfo(control, "    ", info);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private static void dumpControlInfo(Control control, String prefix, StringBuffer info) {
        StringBuilder details = new StringBuilder();
        if (control instanceof BooleanControl) {
            details.append("boolean");
        } else if (control instanceof FloatControl) {
            details.append("float");
        } else if (control instanceof CompoundControl) {
            details.append("compound");
        } else if (control instanceof EnumControl) {
            EnumControl enumControl = (EnumControl)control;
            details.append(Arrays.toString(enumControl.getValues()));
        } else {
            details.append("unknown");
        }
        info.append("\n " + prefix + control.getType() + " (" + details + ") Control: " + control);
        if (control instanceof CompoundControl) {
            CompoundControl compound = (CompoundControl)control;
            Control[] controlArray = compound.getMemberControls();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                SystemInfoDialog.dumpControlInfo(child, String.valueOf(prefix) + "  ", info);
                ++n2;
            }
        }
    }

    private void copy() {
        StringSelection ss = new StringSelection(this.systemInfo);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(ss, ss);
        JOptionPane.showMessageDialog(this, "The System Information have been copied", "Copy to Clipboard", 1);
    }

    private void gc(ActionEvent e) {
        final AbstractButton caller = (AbstractButton)e.getSource();
        caller.setEnabled(false);
        new Thread(){

            public void run() {
                Utils.forceGC();
                ThreadUtils.sleep((int)250);
                Utils.forceGC();
                ThreadUtils.sleep((int)250);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SystemInfoDialog.this.systemInfo = SystemInfoDialog.getSystemInfo(true, true);
                        SystemInfoDialog.this.area.setText(SystemInfoDialog.this.systemInfo);
                        SystemInfoDialog.this.area.setCaretPosition(0);
                        SystemInfoDialog.this.area.invalidate();
                        caller.setEnabled(true);
                    }
                });
            }
        }.start();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }
}

