/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.message;

import ch.tachyon.sonics.gui.message.MessagePanel;
import ch.tachyon.sonics.gui.message.MessageType;
import org.corebounce.common.utils.StringUtils;

public class Message {
    static MessagePanel panel;
    private MessageType type;
    private String text;
    private String details;

    public Message() {
    }

    public Message(MessageType type, String text) {
        this.type = type;
        this.text = text;
    }

    public Message(MessageType type, String text, String details) {
        this.type = type;
        this.text = text;
        this.details = details;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void publish() {
        if (panel != null) {
            panel.addMessage(this);
        }
    }

    public void popup() {
        if (panel != null) {
            panel.addMessage(this);
            panel.popupMessage(this);
        }
    }

    public static void message(MessageType type, String text) {
        Message.message(type, text, null);
    }

    public static void message(MessageType type, String text, String details) {
        Message m = new Message(type, text, details);
        m.publish();
    }

    public static void success(String text, Object ... args) {
        Message.message(MessageType.SUCCESSFUL, StringUtils.format(text, args), null);
    }

    public static void info(String text, Object ... args) {
        Message.message(MessageType.INFORMATION, StringUtils.format(text, args), null);
    }

    public static void warn(String text, Object ... args) {
        Message.message(MessageType.WARNING, StringUtils.format(text, args), null);
    }

    public static void error(String text, Object ... args) {
        Message.message(MessageType.ERROR, StringUtils.format(text, args), null);
    }
}

