/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.message;

import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.sonics.gui.message.MessageType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.corebounce.common.utils.StringUtils;

public class MessageHandler
extends Handler {
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() <= Level.INFO.intValue()) {
            return;
        }
        Message message = new Message();
        String text = "";
        if (record.getMessage() != null) {
            text = record.getParameters() != null ? StringUtils.format(record.getMessage(), record.getParameters()) : record.getMessage();
        }
        if (record.getThrown() != null) {
            Throwable ex = record.getThrown();
            text = StringUtils.isBlank(text) ? MessageHandler.ex2string(ex) : String.valueOf(MessageHandler.ex2string(ex)) + ": " + text;
            text = String.valueOf(text) + " (Internal Error)";
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            String stackTrace = writer.toString().replace("java.lang.", "").replace("java.", "").replace("javax.", "");
            String result = "<html><body>" + MessageHandler.htmlEscape(stackTrace).replace("\n", "<br>") + "</body></html>";
            message.setDetails(result);
        }
        message.setText(text);
        MessageType type = MessageType.INFORMATION;
        Level level = record.getLevel();
        if (level.equals(Level.WARNING)) {
            type = MessageType.WARNING;
        } else if (level.equals(Level.SEVERE)) {
            type = record.getThrown() == null ? MessageType.ERROR : MessageType.EXCEPTION;
        }
        message.setType(type);
        message.publish();
    }

    private static String htmlEscape(String s) {
        return s.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static String ex2string(Throwable ex) {
        String className = ex.getClass().getSimpleName();
        if (className.endsWith("Exception")) {
            className = className.substring(0, className.length() - "Exception".length());
        } else if (className.endsWith("Error")) {
            className = className.substring(0, className.length() - "Error".length());
        }
        StringBuilder result = new StringBuilder();
        boolean lastUpper = true;
        int i = 0;
        while (i < className.length()) {
            char ch = className.charAt(i);
            boolean upper = Character.isUpperCase(ch);
            if (upper && !lastUpper) {
                result.append(' ');
            }
            result.append(ch);
            lastUpper = upper;
            ++i;
        }
        return result.toString();
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

