/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.message;

import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.sonics.gui.message.MessageHandler;
import ch.tachyon.sonics.gui.message.MessageType;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.utils.IDisposable;

public class MessagePanel
extends JPanel
implements IDisposable {
    private static final int NB_MESSAGES = 4;
    private static final int ICON_SIZE = 16;
    private static final String PAD_STRING = "\u00a0";
    private static final int MIN_WIDTH = 100;
    private final MessageHandler handler = new MessageHandler();
    private List<Message> messages = new ArrayList<Message>(5);
    private final JLabel[] labels = new JLabel[4];
    private final AtomicBoolean dialogVisible = new AtomicBoolean(false);

    public MessagePanel() {
        this.setBorder(new TitledBorder("Messages"));
        this.setLayout(new BoxLayout(this, 1));
        int i = 0;
        while (i < 4) {
            this.labels[i] = new JLabel(PAD_STRING);
            this.add(this.labels[i]);
            final int index = i;
            this.labels[i].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    MessagePanel.this.labelClicked(index, e);
                }
            });
            ++i;
        }
        Message.panel = this;
        Logger.getLogger("").addHandler(this.handler);
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        return new Dimension(Math.min(100, result.width), result.height);
    }

    public Dimension getMinimumSize() {
        Dimension result = super.getMinimumSize();
        return new Dimension(Math.min(100, result.width), result.height);
    }

    private void labelClicked(int index, MouseEvent e) {
        if (index >= this.messages.size()) {
            return;
        }
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.popupMessage(this.messages.get(index));
        }
    }

    public synchronized void addMessage(Message message) {
        boolean popup;
        this.messages.add(message);
        while (this.messages.size() > 4) {
            this.messages.remove(0);
        }
        boolean bl = popup = message.getType() == MessageType.ERROR || message.getType() == MessageType.EXCEPTION;
        if (popup && !this.dialogVisible.compareAndSet(false, true)) {
            popup = false;
        }
        final Message popupMessage = popup ? message : null;
        AwtTools.invokeInSwing(new Runnable(){

            public void run() {
                MessagePanel.this.updateLabels(popupMessage);
            }
        });
    }

    private void updateLabels(Message popupMessage) {
        assert (SwingUtilities.isEventDispatchThread());
        int i = 0;
        while (i < 4) {
            if (i < this.messages.size()) {
                Message message = this.messages.get(i);
                this.labels[i].setIcon(message.getType().getIcon(16));
                this.labels[i].setText(String.valueOf(message.getText()) + PAD_STRING);
                this.labels[i].setToolTipText(message.getDetails());
            } else {
                this.labels[i].setIcon(null);
                this.labels[i].setText(PAD_STRING);
            }
            ++i;
        }
        if (popupMessage != null) {
            this.popupMessage(popupMessage);
        }
    }

    void popupMessage(Message popupMessage) {
        this.dialogVisible.set(true);
        StringBuilder message = new StringBuilder();
        message.append("<html><body>");
        message.append("<b>");
        message.append(popupMessage.getText());
        message.append("</b>");
        if (popupMessage.getDetails() != null) {
            message.append("<br><br>");
            String details = popupMessage.getDetails();
            if (details.toLowerCase().startsWith("<html>")) {
                details = details.substring("<html><body>".length());
                details = details.substring(0, details.length() - "</body></html>".length());
            }
            message.append(details.replace("\n", "<br>"));
        }
        message.append("<br><br>");
        message.append("</body></html>");
        int type = 1;
        String title = "Information";
        if (popupMessage.getType() == MessageType.WARNING) {
            type = 2;
            title = "Warning";
        } else if (popupMessage.getType() == MessageType.ERROR || popupMessage.getType() == MessageType.EXCEPTION) {
            type = 0;
            title = popupMessage.getType() == MessageType.EXCEPTION ? "Internal Error" : "Error";
        }
        JOptionPane.showMessageDialog(AwtTools.getWindow(this), message.toString(), title, type, popupMessage.getType().getIcon(32));
        this.dialogVisible.set(false);
    }

    public void dispose() {
        Logger.getLogger("").removeHandler(this.handler);
    }
}

