/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.progress;

import ch.tachyon.sonics.gui.progress.ProgressPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.TableLayout;

public class ProgressDialog
extends JDialog {
    private JPanel content;
    private int count = 0;
    private boolean packed = false;
    private ProgressPanel lastPanel;
    private static boolean firstShown = true;
    private static int lastX;
    private static int lastY;
    private static int lastW;
    private static int lastH;

    public ProgressDialog(JFrame parent) {
        super(parent, "Progress", false);
        super.setResizable(true);
        super.setDefaultCloseOperation(0);
        this.content = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 19;
        this.content.setLayout(new TableLayout(1, gbc));
        JPanel north = new JPanel();
        north.setLayout(new BorderLayout());
        north.add((Component)this.content, "First");
        JScrollPane scrollPane = new JScrollPane(north);
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)scrollPane, "Center");
        scrollPane.getHorizontalScrollBar().setUnitIncrement(12);
        scrollPane.getVerticalScrollBar().setUnitIncrement(12);
    }

    public void pack() {
        if (!this.packed) {
            super.pack();
            Dimension size = this.getContentPane().getSize();
            this.getContentPane().setPreferredSize(new Dimension(size.width * 4 / 3, size.height * 3 / 2));
            this.getContentPane().validate();
            super.pack();
            this.packed = true;
        }
    }

    public void addProgressPanel(ProgressPanel panel) {
        assert (SwingUtilities.isEventDispatchThread());
        this.content.add(panel);
        if (this.isVisible()) {
            panel.initFocus();
        }
        this.lastPanel = panel;
        super.getContentPane().validate();
        ++this.count;
    }

    public void removeProgressPanel(ProgressPanel panel) {
        assert (SwingUtilities.isEventDispatchThread());
        this.content.remove(panel);
        super.getContentPane().validate();
        super.getContentPane().repaint();
        --this.count;
        this.lastPanel = null;
    }

    public int getNbProgresses() {
        return this.count;
    }

    public void setVisible(boolean b) {
        assert (SwingUtilities.isEventDispatchThread());
        if (b) {
            if (!firstShown) {
                this.setSize(lastW, lastH);
                this.setLocation(lastX, lastY);
            }
        } else {
            firstShown = false;
            lastX = this.getLocationOnScreen().x;
            lastY = this.getLocationOnScreen().y;
            lastW = this.getWidth();
            lastH = this.getHeight();
        }
        if (!b) {
            super.paint(this.getGraphics());
        }
        super.setVisible(b);
        if (b && this.lastPanel != null) {
            this.lastPanel.initFocus();
        }
    }
}

