/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.progress;

import ch.tachyon.sonics.gui.progress.ProgressDialog;
import ch.tachyon.sonics.gui.progress.ProgressPanel;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.ThreadUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.ProgressMonitorBean;

public class ProgressManager {
    private static final long PROGRESS_POPUP_DELAY = 1000L;
    private final JFrame parent;
    private ProgressDialog progressDialog;

    public ProgressManager(JFrame parent) {
        this.parent = parent;
    }

    public IProgressMonitor createProgressMonitor(String name) {
        if (this.parent != null) {
            return new DelayedProgressMonitor(name);
        }
        return new ProgressMonitorBean();
    }

    class DelayedProgressMonitor
    implements IProgressMonitor {
        private final String name;
        private AtomicBoolean makingVisible = new AtomicBoolean(false);
        private volatile ProgressPanel progressPanel = null;
        private long startTime = System.currentTimeMillis();
        private double current = Double.NaN;
        private double total;
        private int stepNum;
        private int stepTotal;
        private volatile String text;
        private volatile Object[] args;
        private String waitingOn;
        private boolean stopped;
        private boolean cancelled;
        private boolean stoppable = true;
        private boolean cancellable = true;
        private boolean abortable = true;

        public DelayedProgressMonitor(String name) {
            this.name = name;
        }

        public void setAbortable(boolean stoppable, boolean cancellable) {
            this.stoppable = stoppable;
            this.cancellable = cancellable;
        }

        public void setProgress(double current, double total) throws OperationAbortedException {
            if (this.stopped) {
                throw new OperationAbortedException(false);
            }
            if (this.cancelled) {
                throw new OperationAbortedException(true);
            }
            this.current = current;
            this.total = total;
            this.makeVisibleIfWorth();
            if (this.progressPanel != null) {
                this.progressPanel.setProgress(current, total);
            }
        }

        public void setNoAbortProgress(double current, double total) {
            this.abortable = false;
            this.current = current;
            this.total = total;
            this.makeVisibleIfWorth();
            if (this.progressPanel != null) {
                this.progressPanel.setNoAbortProgress(current, total);
            }
        }

        public void setStep(int current, int total) {
            this.stepNum = current;
            this.stepTotal = total;
            this.makeVisibleIfWorth();
            if (this.progressPanel != null) {
                this.progressPanel.setStep(current, total);
            }
        }

        public void setText(String text, Object ... args) {
            this.text = text;
            this.args = args;
            this.makeVisibleIfWorth();
            if (this.progressPanel != null) {
                this.progressPanel.setText(text, args);
            }
        }

        public void setWaitingOn(String name) throws OperationAbortedException {
            this.waitingOn = name;
            this.makeVisibleIfWorth();
            if (this.progressPanel != null) {
                this.progressPanel.setWaitingOn(name);
            }
        }

        public void stop() {
            this.stopped = true;
            if (this.progressPanel != null) {
                this.progressPanel.stop();
            }
        }

        private boolean isWorthMakingVisible() {
            long now = System.currentTimeMillis();
            if (now > this.startTime + 2000L) {
                return true;
            }
            if (now > this.startTime + 1000L) {
                if (Double.isNaN(this.current) || Double.isNaN(this.total)) {
                    return true;
                }
                if (this.current < this.total * 0.75) {
                    return true;
                }
            }
            return false;
        }

        private void makeVisibleIfWorth() {
            if (this.makingVisible.get() || this.progressPanel != null) {
                return;
            }
            Platform.yield();
            if (this.isWorthMakingVisible()) {
                if (!this.makingVisible.compareAndSet(false, true)) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProgressPanel progressPanel = new ProgressPanel(DelayedProgressMonitor.this.startTime, DelayedProgressMonitor.this.stoppable, DelayedProgressMonitor.this.cancellable);
                        if (ProgressManager.this.progressDialog == null) {
                            ProgressManager.this.progressDialog = new ProgressDialog(ProgressManager.this.parent);
                            this.setupProgress(progressPanel);
                            ProgressManager.this.progressDialog.addProgressPanel(progressPanel);
                            ProgressManager.this.progressDialog.pack();
                            AwtTools.centerWindowOn(ProgressManager.this.progressDialog, ProgressManager.this.parent);
                            ProgressManager.this.progressDialog.setVisible(true);
                        } else {
                            this.setupProgress(progressPanel);
                            ProgressManager.this.progressDialog.addProgressPanel(progressPanel);
                            if (!ProgressManager.this.progressDialog.isVisible()) {
                                ProgressManager.this.progressDialog.setVisible(true);
                            }
                        }
                        DelayedProgressMonitor.this.progressPanel = progressPanel;
                        progressPanel.setText(DelayedProgressMonitor.this.text, DelayedProgressMonitor.this.args);
                        DelayedProgressMonitor.this.makingVisible.set(false);
                    }

                    private void setupProgress(ProgressPanel progressPanel) {
                        try {
                            progressPanel.setAbortable(DelayedProgressMonitor.this.stoppable, DelayedProgressMonitor.this.cancellable);
                            if (DelayedProgressMonitor.this.abortable && (DelayedProgressMonitor.this.stoppable || DelayedProgressMonitor.this.cancellable)) {
                                progressPanel.setProgress(DelayedProgressMonitor.this.current, DelayedProgressMonitor.this.total);
                            } else {
                                progressPanel.setNoAbortProgress(DelayedProgressMonitor.this.current, DelayedProgressMonitor.this.total);
                            }
                        }
                        catch (OperationAbortedException ex) {
                            Debug.error((Throwable)ex);
                        }
                        progressPanel.setStep(DelayedProgressMonitor.this.stepNum, DelayedProgressMonitor.this.stepTotal);
                        if (DelayedProgressMonitor.this.text != null) {
                            progressPanel.setText(DelayedProgressMonitor.this.text, DelayedProgressMonitor.this.args);
                        }
                        progressPanel.initWaitingOn(DelayedProgressMonitor.this.waitingOn);
                        progressPanel.init(DelayedProgressMonitor.this.name);
                    }
                });
            }
        }

        public void reset() {
            this.startTime = System.currentTimeMillis();
            this.current = Double.NaN;
            if (this.progressPanel != null) {
                this.progressPanel.reset();
            }
        }

        public void dispose() {
            while (this.makingVisible.get()) {
                ThreadUtils.sleep((int)100);
            }
            if (this.progressPanel != null) {
                AwtTools.invokeAndWait(new Runnable(){

                    public void run() {
                        ProgressManager.this.progressDialog.removeProgressPanel(DelayedProgressMonitor.this.progressPanel);
                        DelayedProgressMonitor.this.progressPanel = null;
                        if (ProgressManager.this.progressDialog.getNbProgresses() == 0) {
                            ProgressManager.this.progressDialog.setVisible(false);
                            ProgressManager.this.progressDialog.dispose();
                            ProgressManager.this.progressDialog = null;
                        }
                    }
                });
            }
        }
    }
}

