/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.progress;

import ch.tachyon.tunnel.utils.Monitor;
import ch.tachyon.tunnel.utils.ThreadUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.gui.JUnshrinkablePanel;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.StringUtils;

public class ProgressPanel
extends JPanel
implements IProgressMonitor {
    private static final long YIELD_PERIOD = 10L;
    private static final long REFRESH_PERIOD = 100L;
    private JProgressBar progressBar;
    private JLabel waitingForLabel;
    private CardLayout progressCards;
    private JPanel cardPanel;
    private JLabel label;
    private JLabel progressLabel;
    private long startTime;
    private double dblPercent = -1.0;
    private int intPercent = -1;
    private int stepNum;
    private int nbSteps;
    private String text;
    private String waitingOn;
    private long lastRefreshTime;
    private long lastRemaining;
    private long elapsedSinceLast;
    private long undefinedTime;
    private JButton pauseButton;
    private JButton stopButton;
    private JButton cancelButton;
    private boolean paused = false;
    private boolean stopped = false;
    private boolean cancelled = false;
    private boolean stoppable = true;
    private boolean cancellable = true;
    private boolean abortable = true;
    private long pauseStartTime;
    private final Object stateLock = new Monitor("stateLock");

    public ProgressPanel(long startTime, boolean stoppable, boolean cancellable) {
        this.startTime = startTime;
        this.lastRefreshTime = startTime;
        this.stoppable = stoppable;
        this.cancellable = cancellable;
    }

    public void init(String name) {
        super.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        super.add(panel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.setLayout(new TableLayout(2, gbc));
        TitledBorder titledBorder = new TitledBorder(name);
        panel.setBorder(titledBorder);
        this.label = new JLabel();
        gbc.gridwidth = 2;
        panel.add((Component)this.label, gbc);
        gbc.gridwidth = 1;
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = new Insets(0, 4, 0, 4);
        gbc2.fill = 1;
        gbc2.weightx = 1.0;
        JPanel panel2 = new JPanel();
        panel2.setLayout(new TableLayout(2, gbc2));
        panel.add((Component)panel2, gbc);
        this.progressBar = new JProgressBar(0, 100);
        this.waitingForLabel = new JLabel("");
        this.waitingForLabel.setIcon(IconLoader.getIcon(ProgressPanel.class, "Waiting.png", 16));
        this.cardPanel = new JPanel();
        this.progressCards = new CardLayout();
        this.cardPanel.setLayout(this.progressCards);
        this.cardPanel.add((Component)this.progressBar, "progressBar");
        this.cardPanel.add((Component)this.waitingForLabel, "waitingForLabel");
        panel2.add((Component)this.cardPanel, gbc2);
        this.progressLabel = new JLabel();
        JUnshrinkablePanel plPanel = new JUnshrinkablePanel();
        plPanel.setLayout(new BorderLayout());
        plPanel.add(this.progressLabel);
        this.progressLabel.setToolTipText("Progress and estimated time remaining");
        gbc2.weightx = 0.0;
        panel2.add((Component)plPanel, gbc2);
        gbc.weightx = 0.0;
        JToolBar actionToolBar = new JToolBar(0);
        actionToolBar.setFloatable(false);
        actionToolBar.setOpaque(false);
        panel.add((Component)actionToolBar, gbc);
        AbstractAction pauseAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ProgressPanel.this.pause();
            }
        };
        this.pauseButton = new JButton(pauseAction);
        this.pauseButton.setMnemonic('p');
        this.pauseButton.putClientProperty("JButton.buttonType", "toolbar");
        AwtTools.addKeyboardShortcut((AbstractButton)this.pauseButton, 80);
        AwtTools.addKeyboardShortcut((AbstractButton)this.pauseButton, 19);
        actionToolBar.add(this.pauseButton);
        this.refreshButtonStatus();
        AbstractAction stopAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ProgressPanel.this.stop();
            }
        };
        this.stopButton = new JButton(stopAction);
        this.stopButton.setIcon(IconLoader.getImageIcon(ProgressPanel.class, "Stop.png", 16, 16));
        this.stopButton.setToolTipText("<html><body><b>Stop this operation</b><p>Audio processed so far will be kept<p><small><i>Shortcut key: </i>Alt+S</small></body></html>");
        this.stopButton.setMnemonic('s');
        this.stopButton.putClientProperty("JButton.buttonType", "toolbar");
        this.stopButton.setEnabled(this.stoppable && this.abortable);
        this.stopButton.setVisible(false);
        AwtTools.addKeyboardShortcut((AbstractButton)this.stopButton, 83);
        AwtTools.addKeyboardShortcut((AbstractButton)this.stopButton, 65480);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ProgressPanel.this.cancel();
            }
        };
        this.cancelButton = new JButton(cancelAction);
        this.cancelButton.setIcon(IconLoader.getImageIcon(ProgressPanel.class, "Cancel.png", 16, 16));
        this.cancelButton.setToolTipText("<html><body><b>Cancel this operation</b><p>Audio processed so far will be undone<p><small><i>Shortcut key: </i>Alt+C</small></body></html>");
        this.cancelButton.setMnemonic('c');
        this.cancelButton.putClientProperty("JButton.buttonType", "toolbar");
        this.cancelButton.setEnabled(this.cancellable && this.abortable);
        AwtTools.addKeyboardShortcut((AbstractButton)this.cancelButton, 67);
        AwtTools.addKeyboardShortcut((AbstractButton)this.cancelButton, 27);
        actionToolBar.add(this.cancelButton);
        this.lastRefreshTime = System.currentTimeMillis();
        this.refresh0(this.lastRefreshTime, this.lastRefreshTime);
    }

    void initFocus() {
        if (this.cancellable && this.abortable) {
            this.cancelButton.requestFocusInWindow();
        } else if (this.stoppable && this.abortable) {
            this.stopButton.requestFocusInWindow();
        } else {
            this.pauseButton.requestFocusInWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.stopped) {
                boolean bl = this.paused = !this.paused;
                if (this.paused) {
                    this.pauseStartTime = System.currentTimeMillis();
                } else {
                    this.startTime += System.currentTimeMillis() - this.pauseStartTime;
                }
            }
            this.stateLock.notifyAll();
        }
        this.refreshButtonStatus();
    }

    private void refreshButtonStatus() {
        if (this.stopped || this.cancelled) {
            this.pauseButton.setEnabled(false);
            this.stopButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.progressBar.setValue(0);
            this.progressBar.setIndeterminate(true);
            this.label.setEnabled(true);
            this.progressLabel.setEnabled(true);
        } else if (!this.paused) {
            this.pauseButton.setIcon(IconLoader.getImageIcon(ProgressPanel.class, "Pause.png", 16, 16));
            this.pauseButton.setToolTipText("<html><body><b>Temporarily pause this operation</b><p>The operation can be resumed at any time<p><small><i>Shortcut key: </i>Alt+P</small></body></html>");
            this.progressBar.setEnabled(true);
            this.waitingForLabel.setEnabled(true);
            this.label.setEnabled(true);
            this.progressLabel.setEnabled(true);
        } else {
            this.pauseButton.setIcon(IconLoader.getImageIcon(ProgressPanel.class, "Resume.png", 16, 16));
            this.pauseButton.setToolTipText("<html><body><b>Resume this operation</b><p><small><i>Shortcut key: </i>Alt+P</small></body></html>");
            this.progressBar.setEnabled(false);
            this.waitingForLabel.setEnabled(false);
            this.label.setEnabled(false);
            this.progressLabel.setEnabled(false);
        }
        this.refresh0(System.currentTimeMillis(), this.lastRefreshTime);
    }

    public void stop() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressPanel.this.stop0();
            }
        });
    }

    public void cancel() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressPanel.this.cancel0();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop0() {
        assert (SwingUtilities.isEventDispatchThread());
        Object object = this.stateLock;
        synchronized (object) {
            this.stopped = true;
            this.paused = false;
            this.stateLock.notifyAll();
        }
        this.refreshButtonStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel0() {
        assert (SwingUtilities.isEventDispatchThread());
        Object object = this.stateLock;
        synchronized (object) {
            this.cancelled = true;
            this.paused = false;
            this.stateLock.notify();
        }
        this.refreshButtonStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAbortable(boolean stoppable, boolean cancellable) {
        Object object = this.stateLock;
        synchronized (object) {
            this.stoppable = stoppable;
            this.cancellable = cancellable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(double current, double total) throws OperationAbortedException {
        Object object = this.stateLock;
        synchronized (object) {
            this.abortable = true;
            while (this.paused) {
                ThreadUtils.wait((Object)this.stateLock);
            }
            if (this.stopped) {
                throw new OperationAbortedException(false);
            }
            if (this.cancelled) {
                throw new OperationAbortedException(true);
            }
        }
        this.updateProgress(current, total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoAbortProgress(double current, double total) {
        Object object = this.stateLock;
        synchronized (object) {
            this.abortable = false;
            while (this.paused) {
                ThreadUtils.wait((Object)this.stateLock);
            }
        }
        this.updateProgress(current, total);
    }

    private void updateProgress(double current, double total) {
        if (Double.isNaN(current) || Double.isNaN(total)) {
            this.dblPercent = -1.0;
        } else {
            this.dblPercent = current * 100.0 / total + 0.5;
            this.intPercent = (int)this.dblPercent;
            if (this.intPercent < 0) {
                this.intPercent = 0;
            }
            if (this.intPercent > 100) {
                this.intPercent = 100;
            }
        }
        this.refresh();
    }

    public void setStep(int current, int total) {
        this.stepNum = current;
        this.nbSteps = total;
        this.refresh();
    }

    public void setText(String text, Object ... args) {
        if (text == null) {
            return;
        }
        this.text = StringUtils.format(text, args);
        this.refresh();
    }

    void initWaitingOn(String name) {
        this.waitingOn = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaitingOn(String name) throws OperationAbortedException {
        this.waitingOn = name;
        if (this.progressBar != null) {
            this.refresh();
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.stopped) {
                throw new OperationAbortedException(false);
            }
            if (this.cancelled) {
                throw new OperationAbortedException(true);
            }
        }
    }

    private void refresh() {
        long now = System.currentTimeMillis();
        if (now < this.lastRefreshTime + 10L) {
            return;
        }
        Platform.yield();
        if (now < this.lastRefreshTime + 100L) {
            return;
        }
        final long now0 = now;
        final long last0 = this.lastRefreshTime;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressPanel.this.refresh0(now0, last0);
            }
        });
        this.lastRefreshTime = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh0(long now, long lastRefreshTime) {
        assert (SwingUtilities.isEventDispatchThread());
        this.elapsedSinceLast = now - lastRefreshTime;
        if (this.intPercent < 0 || this.dblPercent < 0.0 || this.stopped || this.cancelled) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.intPercent);
        }
        if (this.waitingOn == null) {
            this.progressCards.first(this.cardPanel);
        } else {
            this.progressCards.last(this.cardPanel);
        }
        StringBuilder textBuilder = new StringBuilder();
        if (this.text != null) {
            textBuilder.append(this.text);
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.stopped) {
                textBuilder.append(" (Stopped)");
            } else if (this.cancelled) {
                textBuilder.append(" (Cancelled)");
            } else if (this.paused) {
                textBuilder.append(" (Paused)");
            }
            if (this.waitingOn != null) {
                this.waitingForLabel.setText("Waiting for \"" + this.waitingOn + "\"");
                this.waitingForLabel.setToolTipText("Processing will only start when \"" + this.waitingOn + "\" finishes");
            }
            if (this.stopButton != null && this.stopButton.isEnabled() != (this.stoppable && this.abortable)) {
                this.stopButton.setEnabled(this.stoppable && this.abortable);
            }
            if (this.cancelButton != null && this.cancelButton.isEnabled() != (this.cancellable && this.abortable)) {
                this.cancelButton.setEnabled(this.cancellable && this.abortable);
            }
        }
        this.label.setText(textBuilder.toString());
        this.label.repaint();
        StringBuilder message = new StringBuilder();
        if ((double)this.intPercent >= 0.0) {
            if (message.length() > 0) {
                message.append(" - ");
            }
            message.append(this.intPercent);
            message.append('%');
        }
        if (this.nbSteps > 1) {
            if (message.length() > 0) {
                message.append(" ");
            }
            message.append("(");
            message.append(this.stepNum);
            message.append("/");
            message.append(this.nbSteps);
            message.append(")");
        }
        if (this.intPercent > 0 && this.dblPercent > 0.0) {
            if (message.length() > 0) {
                message.append(" - ");
            }
            long elapsed = now - this.startTime - this.undefinedTime;
            long estimated = (long)((double)elapsed * 100.0 / this.dblPercent);
            long remaining = estimated - elapsed;
            long remaining0 = this.lastRemaining - this.elapsedSinceLast;
            if (remaining > 0L) {
                double ratio;
                if (remaining0 > 0L && Math.abs(remaining - remaining0) < 1000L) {
                    remaining = remaining0;
                }
                if ((ratio = (double)this.lastRemaining / (double)remaining) >= 0.8 && ratio < 1.25) {
                    remaining = Math.min(remaining, this.lastRemaining);
                }
            }
            if (remaining < 0L) {
                remaining = 0L;
            }
            this.lastRemaining = remaining;
            long seconds = (remaining + 999L) / 1000L;
            int secs = (int)(seconds % 60L);
            int mins = (int)(seconds / 60L % 60L);
            int hours = (int)(seconds / 3600L % 24L);
            long days = seconds / 86400L;
            if (days > 0L) {
                message.append(days);
                message.append("d");
            }
            if (days > 0L || hours > 0) {
                message.append(hours);
                message.append(":");
            }
            message.append(mins / 10);
            message.append(mins % 10);
            message.append(":");
            message.append(secs / 10);
            message.append(secs % 10);
        } else if (this.dblPercent < 0.0) {
            this.undefinedTime += this.elapsedSinceLast;
        }
        this.progressLabel.setText(message.toString());
        this.repaint();
    }

    public void reset() {
        this.lastRefreshTime = this.startTime = System.currentTimeMillis();
        this.undefinedTime = 0L;
        this.intPercent = -1;
        this.dblPercent = -1.0;
        this.lastRemaining = 0L;
    }

    public void dispose() {
    }
}

