/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.selectors;

import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionsCombinator {
    private final AudioFile file;
    private SelectionInfo selection;
    private boolean isCombining;
    private List<ISelection> prevSelections = null;
    private TimeRangeSelection prevExtendingSelection = null;
    private boolean hadIntersection = false;

    public SelectionsCombinator(AudioFile file, boolean isCombining, TimeRangeSelection selection) {
        this.file = file;
        this.selection = file.getSelection();
        this.isCombining = isCombining;
        SelectionInfo selInfo = file.getSelection();
        this.prevSelections = new ArrayList<ISelection>();
        for (ISelection sel : selInfo.getSelections()) {
            ISelection clone = sel.clone();
            if (sel == selection) {
                this.prevExtendingSelection = (TimeRangeSelection)clone;
            }
            this.prevSelections.add(clone);
        }
    }

    public boolean isCombining() {
        return this.isCombining;
    }

    public void combineWithCurrentSelection(TimeRangeSelection trSel) {
        if (this.intersectsCurrent(trSel)) {
            List<ISelection> newSelections = this.combineCurrentWith(trSel);
            this.selection.clear();
            this.selection.addSelections(newSelections);
        } else if (!this.selection.getSelections().contains(trSel)) {
            this.selection.addSelection(trSel);
        }
    }

    private boolean intersectsCurrent(TimeRangeSelection newSel) {
        if (!this.isCombining) {
            return false;
        }
        if (this.hadIntersection) {
            return true;
        }
        for (ISelection selection : this.prevSelections) {
            TimeRangeSelection trSel;
            if (!(selection instanceof TimeRangeSelection) || selection == newSel || selection == this.prevExtendingSelection || !newSel.intersects(trSel = (TimeRangeSelection)selection)) continue;
            this.hadIntersection = true;
            return true;
        }
        return false;
    }

    private List<ISelection> combineCurrentWith(TimeRangeSelection newSel) {
        ArrayList<ISelection> result = new ArrayList<ISelection>();
        ArrayList<Long> points = new ArrayList<Long>();
        for (ISelection selection : this.prevSelections) {
            if (selection == newSel || selection == this.prevExtendingSelection) continue;
            if (selection instanceof TimeRangeSelection) {
                TimeRangeSelection tr = (TimeRangeSelection)selection;
                points.add(tr.getStartPosition());
                points.add(tr.getStopPosition());
                continue;
            }
            result.add(selection);
        }
        points.add(newSel.getStartPosition());
        points.add(newSel.getStopPosition());
        assert (points.size() % 2 == 0);
        Collections.sort(points);
        Iterator iter = points.iterator();
        while (iter.hasNext()) {
            long start = (Long)iter.next();
            long stop = (Long)iter.next();
            if (stop <= start) continue;
            result.add(new TimeRangeSelection(this.selection, start, stop, this.file.getAllChannelsMask()));
        }
        return result;
    }

    public void cancel() {
        this.file.getSelection().clear();
        for (ISelection sel : this.prevSelections) {
            this.file.getSelection().addSelection(sel);
        }
    }
}

