/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.selectors;

import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.sonics.gui.selectors.SelectionsCombinator;
import java.awt.event.MouseEvent;
import org.corebounce.common.gui.AwtTools;

public class TimeRangeSelector {
    private AudioFile audioFile;
    private SelectionInfo selection;
    private AudioChannel channel;
    private int startDragX;
    private boolean dragStarted;
    private long prevStartPos = Long.MAX_VALUE;
    private long prevStopPos = Long.MIN_VALUE;
    private SelectionsCombinator combinator;
    private TimeRangeSelection dragSelection;

    public void setCurrentChannel(AudioChannel channel) {
        this.channel = channel;
        this.audioFile = channel.getFile();
        this.selection = this.audioFile.getSelection();
    }

    private long toLocation(int xCoord, int roundPos) {
        return this.channel.getView().getPanel().fromXCoord(xCoord, roundPos);
    }

    private int toPixel(long location, int roundPos) {
        return this.channel.getView().getPanel().toXCoord(location, roundPos);
    }

    public void mousePressed(MouseEvent event) {
        long startPos;
        if (event.getButton() == 3) {
            this.cancelSelection();
            return;
        }
        this.prevStartPos = Long.MAX_VALUE;
        this.prevStopPos = Long.MIN_VALUE;
        this.dragStarted = false;
        this.combinator = null;
        if (event.getButton() != 1) {
            return;
        }
        this.startDragX = event.getX();
        long stopPos = startPos = this.toLocation(this.startDragX, 0);
        long cursorPosition = Math.max(0L, Math.min(this.audioFile.getLength(), startPos));
        this.selection.setCursorPosition(cursorPosition);
        this.dragSelection = null;
        if (AwtTools.isContiguousMultiSelect(event)) {
            long pos = this.toLocation(this.startDragX, 0);
            TimeRangeSelection closest = null;
            long closestDistance = Long.MAX_VALUE;
            for (ISelection sel : this.selection.getSelections()) {
                TimeRangeSelection candidate;
                long distance;
                if (!(sel instanceof TimeRangeSelection) || (distance = Math.min(Math.abs((candidate = (TimeRangeSelection)sel).getStartPosition() - pos), Math.abs(candidate.getStopPosition() - pos))) >= closestDistance) continue;
                closestDistance = distance;
                closest = candidate;
            }
            if (closest != null) {
                this.dragSelection = closest;
                if (Math.abs(pos - closest.getStartPosition()) < Math.abs(pos - closest.getStopPosition())) {
                    long lockedPos;
                    this.prevStartPos = lockedPos = closest.getStopPosition();
                    this.prevStopPos = lockedPos;
                    stopPos = lockedPos;
                    startPos = this.toLocation(this.startDragX, -1);
                    this.startDragX = this.toPixel(lockedPos, -1);
                } else {
                    long lockedPos;
                    this.prevStartPos = lockedPos = closest.getStartPosition();
                    this.prevStopPos = lockedPos;
                    startPos = lockedPos;
                    stopPos = this.toLocation(this.startDragX, 1);
                    this.startDragX = this.toPixel(lockedPos, 1);
                }
            }
        }
        if (this.dragSelection == null) {
            this.dragSelection = new TimeRangeSelection(this.selection, startPos, stopPos, this.audioFile.getAllChannelsMask());
            this.selection.addSelection(this.dragSelection);
        } else {
            this.dragSelection.setRange(startPos, stopPos, true);
        }
        this.combinator = new SelectionsCombinator(this.audioFile, AwtTools.isMultiSelect(event), this.dragSelection);
        this.combinator.combineWithCurrentSelection(this.dragSelection);
    }

    private void cancelSelection() {
        if (this.combinator != null) {
            this.combinator.cancel();
            this.combinator = null;
            this.dragSelection = null;
        }
    }

    public void mouseDragged(MouseEvent event) {
        long stopPos;
        if (this.combinator == null) {
            return;
        }
        int stopDragX = event.getX();
        if (stopDragX != this.startDragX && !this.dragStarted) {
            if (!this.combinator.isCombining()) {
                this.selection.clear();
                this.selection.addSelection(this.dragSelection);
            }
            this.dragStarted = true;
        }
        if (!this.dragStarted) {
            return;
        }
        int startX = Math.min(this.startDragX, stopDragX);
        int stopX = Math.max(this.startDragX, stopDragX);
        long startPos = Math.min(this.toLocation(startX, -1), this.prevStartPos);
        if (startPos < 0L) {
            startPos = 0L;
        }
        if ((stopPos = Math.max(this.toLocation(stopX, 1), this.prevStopPos)) > this.audioFile.getLength()) {
            stopPos = this.audioFile.getLength();
        }
        this.dragSelection.setRange(startPos, stopPos, true);
        this.combinator.combineWithCurrentSelection(this.dragSelection);
    }

    public void mouseReleased(MouseEvent event) {
        this.mouseDragged(event);
        if (this.combinator == null) {
            return;
        }
        if (this.dragSelection.isEmpty()) {
            this.selection.removeSelection(this.dragSelection);
        } else {
            this.dragSelection.setRange(this.dragSelection.getStartPosition(), this.dragSelection.getStopPosition(), false);
            this.combinator.combineWithCurrentSelection(this.dragSelection);
        }
        this.selection.setCursorPosition(this.dragSelection.getStartPosition());
        this.combinator = null;
        this.dragSelection = null;
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getButton() == 1) {
            if (event.getClickCount() == 2) {
                this.selection.clear();
                this.selection.setCursorPosition(0L);
            } else if (event.getClickCount() == 3) {
                this.selection.clear();
                TimeRangeSelection trSel = new TimeRangeSelection(this.selection, 0L, this.audioFile.getLength(), this.audioFile.getAllChannelsMask());
                this.selection.addSelection(trSel);
            }
        }
    }
}

