/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.toolbox;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.action.MenuGroupBase;
import ch.tachyon.sonics.action.effect.EffectActionBase;
import ch.tachyon.sonics.core.Effect;
import ch.tachyon.sonics.core.IToolboxItem;
import ch.tachyon.sonics.gui.toolbox.TreeStructurePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.gui.PopupMenuListener;
import org.corebounce.common.gui.TableLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolTreePanel
extends JPanel {
    private static final String EFFECT_GROUP_NAME = "Transformations";
    private static final Set<String> EXPANDED = new HashSet<String>(Arrays.asList("Transformations"));
    private final List<MenuGroupBase> menus;
    private final List<Effect> effects;
    private final Controller controller;
    private final Map<IToolboxItem, Collection<JComponent>> lines = new HashMap<IToolboxItem, Collection<JComponent>>();
    private final Set<IToolboxItem> expandedNodes = new HashSet<IToolboxItem>();
    private Map<IToolboxItem, String> structurePrefixes;
    private final ButtonGroup group = new ButtonGroup();
    private Icon pluginIcon;

    public ToolTreePanel(List<MenuGroupBase> menus, List<Effect> effects, Controller controller) {
        this.menus = menus;
        this.effects = effects;
        this.controller = controller;
        this.init();
    }

    private void init() {
        this.pluginIcon = IconLoader.getImageIcon(ToolTreePanel.class, "Plugin.png", 16, 16);
        int depthE = ToolTreePanel.getDepth(this.effects) + 1;
        int depthM = ToolTreePanel.getDepth(this.menus);
        int depth = Math.max(depthE, depthM);
        int nbColumns = depth + 2;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        this.setLayout(new TableLayout(nbColumns, gbc));
        int i = 0;
        while (i < this.menus.size()) {
            ActionBase action = this.menus.get(i);
            this.addAction(action, 0, gbc, nbColumns, false, null);
            ++i;
        }
    }

    public static int getDepth(List<? extends IToolboxItem> effects) {
        int result = 0;
        for (IToolboxItem iToolboxItem : effects) {
            int depth = ToolTreePanel.getDepth(iToolboxItem);
            if (depth <= result) continue;
            result = depth;
        }
        return result;
    }

    public static int getDepth(IToolboxItem item) {
        int result = 1;
        if (item.getChildren() != null) {
            for (IToolboxItem child : item.getChildren()) {
                int subDepth = 1 + ToolTreePanel.getDepth(child);
                if (subDepth <= result) continue;
                result = subDepth;
            }
        }
        return result;
    }

    private void addEffect(final Effect effect, int level, GridBagConstraints gbc, int nbColumns, boolean isLastRoot, Controller controller) {
        JLabel label;
        JPanel panel;
        int nbRemaining = nbColumns;
        String effectName = effect.getName();
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        String treeStruct = this.getStructurePrefix(effect, isLastRoot);
        assert (treeStruct.length() == level);
        GridBagConstraints gbc2 = (GridBagConstraints)gbc.clone();
        gbc2.fill = 1;
        int i = 0;
        while (i < level) {
            TreeStructurePanel tPanel = new TreeStructurePanel(treeStruct);
            super.add((Component)tPanel, gbc2);
            components.add(tPanel);
            --nbRemaining;
            ++i;
        }
        String lastStruct = treeStruct.substring(level - 1, level);
        TreeStructurePanel lPanel1 = new TreeStructurePanel(lastStruct);
        super.add((Component)lPanel1, gbc2);
        components.add(lPanel1);
        --nbRemaining;
        TreeStructurePanel lPanel2 = null;
        if (effect.isCategory()) {
            lPanel2 = new TreeStructurePanel("F");
            super.add((Component)lPanel2, gbc2);
            components.add(lPanel2);
            --nbRemaining;
            lPanel1.setExpanded(false);
            lPanel2.setExpanded(false);
        }
        ArrayList<JComponent> popupComponents = new ArrayList<JComponent>();
        GridBagConstraints gbc3 = (GridBagConstraints)gbc.clone();
        gbc3.gridwidth = nbRemaining;
        if (effect.isCategory()) {
            gbc3.gridwidth = nbRemaining - 1;
            JLabel label2 = new JLabel();
            label2.setText(String.valueOf(effectName) + " ");
            label2.setToolTipText("Click to open or close this group");
            label2.setFont(this.getFont().deriveFont(1));
            label2.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
            label2.setCursor(Cursor.getPredefinedCursor(12));
            super.add((Component)label2, gbc3);
            components.add(label2);
            JLabel spacer = new JLabel();
            super.add((Component)spacer, gbc2);
            components.add(spacer);
        } else if (effect.isRadioButton()) {
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JRadioButton radio = new JRadioButton();
            this.group.add(radio);
            panel.add((Component)radio, "Before");
            popupComponents.add(radio);
            label = new JLabel();
            label.setText(effectName);
            label.setIcon(this.pluginIcon);
            this.assignLabelTo(label, radio);
            panel.add((Component)label, "Center");
            popupComponents.add(label);
            super.add((Component)panel, gbc3);
            components.add(panel);
        } else if (effect.isCheckbox()) {
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JCheckBox checkBox = new JCheckBox();
            panel.add((Component)checkBox, "Before");
            popupComponents.add(checkBox);
            label = new JLabel();
            label.setText(effectName);
            label.setIcon(this.pluginIcon);
            this.assignLabelTo(label, checkBox);
            panel.add((Component)label, "Center");
            popupComponents.add(label);
            super.add((Component)panel, gbc3);
            components.add(panel);
        } else if (effect.isToggle()) {
            gbc3.gridwidth = nbRemaining - 1;
            JToggleButton button = new JToggleButton();
            button.setText(effectName);
            button.setToolTipText("<html><body>This effect has not been implemented yet</body></html>");
            button.setIcon(this.pluginIcon);
            button.setHorizontalAlignment(10);
            button.putClientProperty("JButton.buttonType", "toggle");
            JComponent cmp = this.addMargins(button);
            super.add((Component)cmp, gbc3);
            components.add(cmp);
            popupComponents.add(button);
            JLabel spacer = new JLabel();
            super.add((Component)spacer, gbc2);
            components.add(spacer);
        } else {
            EffectActionBase<?> action = EffectActionBase.createActionFor(effect);
            action.setController(controller);
            gbc3.gridwidth = nbRemaining - 1;
            AbstractButton button = action.createButton(false);
            if (button.getIcon() == null) {
                button.setIcon(this.pluginIcon);
            }
            button.setHorizontalAlignment(10);
            JComponent cmp = this.addMargins(button);
            super.add((Component)cmp, gbc3);
            components.add(cmp);
            popupComponents.add(button);
            JLabel spacer = new JLabel();
            super.add((Component)spacer, gbc2);
            components.add(spacer);
        }
        if (!effect.isCategory()) {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem mSettings = new JMenuItem("Settings...");
            mSettings.setIcon(IconLoader.getIcon(ToolTreePanel.class, "Settings.png", 16));
            mSettings.setToolTipText("Change settings for this tool");
            popupMenu.add(mSettings);
            JMenuItem mInfo = new JMenuItem("Information...", IconLoader.getIcon(ToolTreePanel.class, "Information.png", 16));
            mInfo.setToolTipText("Show information and help for this tool");
            popupMenu.add(mInfo);
            PopupMenuListener popupListener = new PopupMenuListener(popupMenu);
            for (JComponent cmp : popupComponents) {
                cmp.addMouseListener(popupListener);
            }
            AwtTools.addDetachedComponent(popupMenu);
        }
        this.lines.put(effect, components);
        if (EXPANDED.contains(effectName)) {
            this.expandedNodes.add(effect);
            lPanel1.setExpanded(true);
            lPanel2.setExpanded(true);
        } else if (effect.getParent() != null && !EXPANDED.contains(effect.getParent().getName())) {
            for (JComponent cmp : components) {
                cmp.setVisible(false);
            }
        }
        if (effect.isCategory()) {
            for (JComponent cmp : components) {
                cmp.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (e.isConsumed()) {
                            return;
                        }
                        if (e.getButton() == 1) {
                            ToolTreePanel.this.toggle(effect);
                        }
                    }
                });
            }
        }
        if (effect.isCategory()) {
            for (Effect child : effect.getEffectChildren()) {
                this.addEffect(child, level + 1, gbc, nbColumns, isLastRoot, controller);
            }
        }
    }

    private AbstractButton addAction(final ActionBase action, int level, GridBagConstraints gbc, int nbColumns, boolean isLastRoot, String currentCategory) {
        AbstractButton result = null;
        int nbRemaining = nbColumns;
        String actionName = action.getText();
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        String treeStruct = this.getStructurePrefix(action, isLastRoot);
        assert (treeStruct.length() == level + 1);
        GridBagConstraints gbc2 = (GridBagConstraints)gbc.clone();
        gbc2.fill = 1;
        int i = 0;
        while (i < level) {
            String struct = treeStruct.substring(i, i + 1);
            TreeStructurePanel tPanel = new TreeStructurePanel(struct);
            super.add((Component)tPanel, gbc2);
            components.add(tPanel);
            --nbRemaining;
            ++i;
        }
        String lastStruct = treeStruct.substring(level, level + 1);
        TreeStructurePanel lPanel1 = new TreeStructurePanel(lastStruct);
        super.add((Component)lPanel1, gbc2);
        components.add(lPanel1);
        --nbRemaining;
        TreeStructurePanel lPanel2 = null;
        if (action.isCategory()) {
            lPanel2 = new TreeStructurePanel("F");
            super.add((Component)lPanel2, gbc2);
            components.add(lPanel2);
            --nbRemaining;
            lPanel1.setExpanded(false);
            lPanel2.setExpanded(false);
        }
        ArrayList<AbstractButton> popupComponents = new ArrayList<AbstractButton>();
        GridBagConstraints gbc3 = (GridBagConstraints)gbc.clone();
        gbc3.gridwidth = nbRemaining;
        if (action.isCategory()) {
            gbc3.gridwidth = nbRemaining - 1;
            JLabel label = new JLabel();
            label.setText(String.valueOf(actionName) + " ");
            label.setToolTipText("Click to open or close this group");
            label.setFont(this.getFont().deriveFont(1));
            label.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
            label.setCursor(Cursor.getPredefinedCursor(12));
            super.add((Component)label, gbc3);
            components.add(label);
            JLabel spacer = new JLabel();
            super.add((Component)spacer, gbc2);
            components.add(spacer);
        } else {
            action.setController(this.controller);
            gbc3.gridwidth = nbRemaining - 1;
            AbstractButton button = action.createButton(false);
            button.setHorizontalAlignment(10);
            Iterator cmp = this.addMargins(button);
            super.add((Component)((Object)cmp), gbc3);
            components.add((JComponent)((Object)cmp));
            popupComponents.add(button);
            JLabel spacer = new JLabel();
            super.add((Component)spacer, gbc2);
            components.add(spacer);
            result = button;
        }
        this.lines.put(action, components);
        if (EXPANDED.contains(actionName)) {
            this.expandedNodes.add(action);
            lPanel1.setExpanded(true);
            lPanel2.setExpanded(true);
        } else if (action.getParent() != null && !EXPANDED.contains(action.getParent().getName())) {
            for (JComponent cmp : components) {
                cmp.setVisible(false);
            }
        }
        if (action.isCategory()) {
            for (JComponent cmp : components) {
                cmp.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (e.isConsumed()) {
                            return;
                        }
                        if (e.getButton() == 1) {
                            ToolTreePanel.this.toggle(action);
                        }
                    }
                });
            }
        }
        if (action.isCategory()) {
            ButtonGroup group = null;
            int index = 0;
            for (IToolboxItem child : action.getChildren()) {
                if (child == null) continue;
                ActionBase childAction = (ActionBase)child;
                AbstractButton button = this.addAction(childAction, level + 1, gbc, nbColumns, isLastRoot, null);
                if (childAction.getDisplayType() == ActionDisplayType.RADIO) {
                    if (group == null) {
                        group = new ButtonGroup();
                    }
                    group.add(button);
                }
                if (++index != 1 || !action.getText().equals(EFFECT_GROUP_NAME)) continue;
                int j = 0;
                while (j < this.effects.size()) {
                    Effect effect = this.effects.get(j);
                    this.addEffect(effect, 1, gbc, nbColumns, false, this.controller);
                    ++j;
                }
            }
        }
        return result;
    }

    public String getStructurePrefix(IToolboxItem item, boolean isLastRoot) {
        if (this.structurePrefixes == null) {
            this.structurePrefixes = new HashMap<IToolboxItem, String>();
            Iterator<IToolboxItem> iterator = this.menus.iterator();
            while (iterator.hasNext()) {
                IToolboxItem iToolboxItem;
                this.fillStructurePrefixes(iToolboxItem, "", 0, (iToolboxItem = (IToolboxItem)iterator.next()) == this.menus.get(this.menus.size() - 1));
            }
            for (IToolboxItem iToolboxItem : this.effects) {
                this.fillStructurePrefixes(iToolboxItem, "", 0, false);
            }
        }
        return this.structurePrefixes.get(item);
    }

    private void fillStructurePrefixes(IToolboxItem item, String prefix, int indent, boolean isLast) {
        StringBuilder curPrefix = new StringBuilder();
        curPrefix.append(prefix);
        String nextPrefix = prefix;
        if (isLast) {
            curPrefix.append("\u2514");
            nextPrefix = String.valueOf(nextPrefix) + " ";
        } else {
            curPrefix.append("\u251c");
            nextPrefix = String.valueOf(nextPrefix) + "\u2502";
        }
        String structurePrefix = curPrefix.toString();
        this.structurePrefixes.put(item, structurePrefix);
        if (item.getChildren() != null) {
            int lastIndex = item.getChildren().size() - 1;
            int i = 0;
            while (i <= lastIndex) {
                IToolboxItem child = item.getChildren().get(i);
                if (child != null) {
                    this.fillStructurePrefixes(child, nextPrefix, indent + 1, i == lastIndex);
                }
                ++i;
            }
        }
    }

    private void assignLabelTo(JLabel label, final JToggleButton toggle) {
        label.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.getButton() == 1) {
                    toggle.setSelected(!toggle.isSelected());
                }
            }
        });
    }

    private JComponent addMargins(JComponent cmp) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(0, 0, 2, 0));
        panel.add(cmp);
        return panel;
    }

    public List<Effect> getEffects() {
        return this.effects;
    }

    private void toggle(IToolboxItem effect) {
        if (!effect.isCategory()) {
            return;
        }
        boolean isExpanded = this.expandedNodes.contains(effect);
        if (isExpanded) {
            this.toggle(effect, false);
            this.expandedNodes.remove(effect);
        } else {
            this.toggle(effect, true);
            this.expandedNodes.add(effect);
        }
        this.validate();
    }

    private void toggle(IToolboxItem effect, boolean expanded) {
        Collection<JComponent> components = this.lines.get(effect);
        for (JComponent cmp : components) {
            TreeStructurePanel tsp;
            if (!(cmp instanceof TreeStructurePanel) || (tsp = (TreeStructurePanel)cmp).isExpanded() == null) continue;
            tsp.setExpanded(expanded);
            tsp.repaint();
        }
        this.toggle(effect.getChildren(), expanded);
        if (effect.getName().equals(EFFECT_GROUP_NAME)) {
            this.toggle(new ArrayList<IToolboxItem>(this.effects), expanded);
        }
    }

    private void toggle(List<IToolboxItem> children, boolean expanded) {
        for (IToolboxItem child : children) {
            if (child == null) continue;
            Collection<JComponent> components = this.lines.get(child);
            for (JComponent cmp : components) {
                cmp.setVisible(expanded);
            }
            if (!child.isCategory() || expanded && !this.expandedNodes.contains(child)) continue;
            this.toggle(child.getChildren(), expanded);
        }
    }
}

