/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.toolbox;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.EditMenu;
import ch.tachyon.sonics.action.HelpMenu;
import ch.tachyon.sonics.action.MenuBar;
import ch.tachyon.sonics.action.MenuGroupBase;
import ch.tachyon.sonics.action.TransportMenu;
import ch.tachyon.sonics.action.ViewMenu;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolboxBuilder {
    public static final String TRANSFORMATIONS_GROUP = "Transformations";

    public static List<MenuGroupBase> buildToolbox(MenuBar menuBar) {
        ArrayList<MenuGroupBase> result = new ArrayList<MenuGroupBase>();
        result.add(menuBar.getFileMenu());
        Controller controller = menuBar.getController();
        MenuGroupBase viewBox = new MenuGroupBase(controller, "View");
        result.add(viewBox);
        MenuGroupBase zoomBox = viewBox.addMenu("Zoom");
        ViewMenu viewMenu = menuBar.getViewMenu();
        zoomBox.addItem(viewMenu.getFitFileAction());
        zoomBox.addItem(viewMenu.getFitSelectionAction());
        zoomBox.addItem(viewMenu.getZoomSelectionStartAction());
        zoomBox.addItem(viewMenu.getZoomSelectionStopAction());
        zoomBox.addItem(viewMenu.getZoomInAction());
        zoomBox.addItem(viewMenu.getZoomOutAction());
        zoomBox.addItem(viewMenu.getFitHorzAction());
        MenuGroupBase verticalBox = viewBox.addMenu("Vertical");
        verticalBox.addItem(viewMenu.getZoomInVertAction());
        verticalBox.addItem(viewMenu.getZoomOutVertAction());
        verticalBox.addItem(viewMenu.getFitVertAction());
        viewBox.addItem(viewMenu.getViewTypeAction());
        MenuGroupBase selectionBox = viewBox.addMenu("Selection");
        EditMenu editMenu = menuBar.getEditMenu();
        selectionBox.addItem(editMenu.getSelectAllAction());
        selectionBox.addItem(editMenu.getSelectVisibleAction());
        selectionBox.addItem(editMenu.getToggleSelectionAction());
        selectionBox.addItem(editMenu.getDeselectAllAction());
        MenuGroupBase transformationBox = new MenuGroupBase(controller, TRANSFORMATIONS_GROUP);
        result.add(transformationBox);
        MenuGroupBase editBox = transformationBox.addMenu("Edit");
        editBox.addItem(editMenu.getCutAction());
        editBox.addItem(editMenu.getCopyAction());
        editBox.addItem(editMenu.getPasteAction());
        editBox.addItem(editMenu.getPasteSpecialAction());
        editBox.addItem(editMenu.getTrimAction());
        editBox.addItem(editMenu.getSilenceAction());
        editBox.addItem(editMenu.getDeleteAction());
        transformationBox.addItem(editMenu.getUndoAction());
        transformationBox.addItem(editMenu.getRedoAction());
        MenuGroupBase transportBox = new MenuGroupBase(controller, "Transport");
        result.add(transportBox);
        TransportMenu transportMenu = menuBar.getTransportMenu();
        transportBox.addItem(transportMenu.getStopAction());
        transportBox.addItem(transportMenu.getSkipToStartAction());
        transportBox.addItem(transportMenu.getSeekBackwardAction());
        transportBox.addItem(transportMenu.getPlayAction());
        transportBox.addItem(transportMenu.getPauseAction());
        transportBox.addItem(transportMenu.getSeekForwardAction());
        transportBox.addItem(transportMenu.getSkipToEndAction());
        MenuGroupBase trOptionsBox = transportBox.addMenu("Playback");
        trOptionsBox.addItem(transportMenu.getLoopAction());
        trOptionsBox.addItem(transportMenu.getPlaySelectionAction());
        trOptionsBox.addItem(transportMenu.getScrollingAction());
        transportBox.addItem(transportMenu.getRecordAction());
        MenuGroupBase helpBox = new MenuGroupBase(controller, "Help");
        result.add(helpBox);
        helpBox.addItem(editMenu.getPreferencesAction());
        HelpMenu helpMenu = menuBar.getHelpMenu();
        helpBox.addItem(helpMenu.getUserManualAction());
        helpBox.addItem(helpMenu.getKeyboardShortcutsAction());
        helpBox.addItem(helpMenu.getCheckForUpdatesAction());
        helpBox.addItem(helpMenu.getAboutAction());
        return result;
    }
}

