/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.toolbox;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.MenuBar;
import ch.tachyon.sonics.action.MenuGroupBase;
import ch.tachyon.sonics.core.Effect;
import ch.tachyon.sonics.core.EffectLoader;
import ch.tachyon.sonics.gui.toolbox.ToolTreePanel;
import ch.tachyon.sonics.gui.toolbox.ToolboxBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.utils.Platform;

public class ToolboxPanel
extends JPanel {
    private JTextField searchField;
    private int width = -1;

    public ToolboxPanel(Controller controller, MenuBar menus) {
        this.setBorder(new TitledBorder("Toolbox"));
        this.setLayout(new BorderLayout());
        JPanel searchPanel = this.createSearchPanel();
        this.add((Component)searchPanel, "North");
        JComponent tools = this.createToolsPanel(menus, controller);
        this.add((Component)tools, "Center");
    }

    private JPanel createSearchPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        panel.setLayout(new TableLayout(3, gbc));
        JLabel label = new JLabel("Search: ");
        panel.add(label);
        this.searchField = new JTextField();
        if (Platform.isMacOsX()) {
            this.searchField.putClientProperty("JTextField.variant", "search");
            label.setVisible(false);
        }
        this.searchField.setToolTipText("Type keywords to search");
        gbc.weightx = 1.0;
        panel.add((Component)this.searchField, gbc);
        JToolBar clearToolbar = new JToolBar();
        clearToolbar.setFloatable(false);
        clearToolbar.setBorderPainted(false);
        clearToolbar.setOpaque(false);
        AbstractAction clear = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        clear.putValue("SmallIcon", IconLoader.getImageIcon(this.getClass(), "Clear.png", 16, 16));
        clear.putValue("ShortDescription", "<html><body>Clear search<p>(Display all plugins)</body></html>");
        JButton clearButton = new JButton(clear);
        clearButton.putClientProperty("JButton.buttonType", "toolbar");
        clearToolbar.add(clearButton);
        if (!Platform.isMacOsX()) {
            panel.add(clearToolbar);
        }
        return panel;
    }

    private JComponent createToolsPanel(MenuBar menus, Controller controller) {
        List<Effect> effects = null;
        try {
            effects = EffectLoader.loadEffects();
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot load plugins", ex);
        }
        List<MenuGroupBase> toolBoxStructure = ToolboxBuilder.buildToolbox(menus);
        ToolTreePanel result = new ToolTreePanel(toolBoxStructure, effects, controller);
        JPanel lefter = new JPanel();
        lefter.setLayout(new BorderLayout());
        lefter.add((Component)result, "West");
        JPanel topper = new JPanel();
        topper.setLayout(new BorderLayout());
        topper.add((Component)lefter, "North");
        JScrollPane scroller = new JScrollPane(topper);
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        scroller.getHorizontalScrollBar().setUnitIncrement(16);
        return scroller;
    }

    public void setWidth(int width) {
        this.width = width;
        this.revalidate();
    }

    public void resetWidth() {
        this.width = -1;
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.width > 0) {
            result = new Dimension(this.width, result.height);
        }
        return result;
    }
}

