/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.toolbox;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.ILafListener;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.StringUtils;

public class TreeStructurePanel
extends JLabel
implements ILafListener {
    private static final Map<String, String> nativeIcons = new HashMap<String, String>();
    private static final Map<String, String> customIcons = new HashMap<String, String>();
    private static final Map<String, Icon> icons = new HashMap<String, Icon>();
    private final String struct;
    private Boolean expanded;
    private Icon icon;
    private boolean useNativeIcons;
    private static int maxWidth = 0;

    static {
        nativeIcons.put("\u251cO", "Tree.expandedIcon");
        nativeIcons.put("\u251cC", "Tree.collapsedIcon");
        nativeIcons.put("\u2514O", "Tree.expandedIcon");
        nativeIcons.put("\u2514C", "Tree.collapsedIcon");
        nativeIcons.put("FO", "Tree.openIcon");
        nativeIcons.put("FC", "Tree.closedIcon");
        customIcons.put("\u251cO", "CollapseArrow.png");
        customIcons.put("\u251cC", "ExpandArrow.png");
        customIcons.put("\u2514O", "CollapseArrow.png");
        customIcons.put("\u2514C", "ExpandArrow.png");
        customIcons.put("FO", "FolderOpen.png");
        customIcons.put("FC", "FolderClosed.png");
    }

    public TreeStructurePanel(String struct) {
        this.struct = struct;
        super.setHorizontalAlignment(0);
        super.setIconTextGap(0);
        AwtTools.addPostLafListener(this);
        this.useNativeIcons = this.useNativeIcons();
    }

    public Boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(Boolean expanded) {
        this.expanded = expanded;
        this.icon = null;
    }

    private String getFullStruct() {
        String result = this.struct;
        if (this.expanded != null) {
            result = this.expanded != false ? String.valueOf(result) + "O" : String.valueOf(result) + "C";
        }
        return result;
    }

    protected void paintComponent(Graphics g) {
        this.lookupIcon();
        super.setIcon(this.icon);
        super.paintComponent(g);
    }

    private void lookupIcon() {
        String struct = this.getFullStruct();
        if (this.icon == null && StringUtils.isNotBlank(struct)) {
            this.icon = icons.get(struct);
            if (this.icon == null) {
                String key;
                if (this.useNativeIcons && (key = nativeIcons.get(struct)) != null) {
                    this.icon = UIManager.getIcon(key);
                    if (this.icon != null && this.icon.getIconWidth() > 4) {
                        icons.put(struct, this.icon);
                    } else {
                        this.icon = null;
                    }
                }
                if (this.icon == null) {
                    String name = customIcons.get(struct);
                    if (name == null) {
                        return;
                    }
                    this.icon = IconLoader.getIcon(TreeStructurePanel.class, name, -1);
                    icons.put(struct, this.icon);
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        int width;
        this.lookupIcon();
        int n = width = this.icon == null ? 16 : this.icon.getIconWidth();
        if (width > maxWidth) {
            maxWidth = width;
        }
        return new Dimension(maxWidth, 16);
    }

    public void lookAndFeelChanged(String lafClassName) {
        icons.clear();
        maxWidth = 0;
        this.icon = null;
        this.revalidate();
        this.repaint();
        this.useNativeIcons = this.useNativeIcons();
    }

    public boolean useNativeIcons() {
        boolean result;
        LookAndFeel laf = UIManager.getLookAndFeel();
        String lafName = laf.getName().toLowerCase();
        boolean bl = result = lafName.contains("mac os") || lafName.startsWith("cde") || lafName.startsWith("metal") || lafName.startsWith("substance") || lafName.contains("windows") && (laf.getClass().getSimpleName().toLowerCase().contains("windowsclassic") || Platform.isBelowJava16());
        if (result) {
            super.setVerticalAlignment(0);
        } else {
            super.setVerticalAlignment(1);
        }
        return result;
    }
}

