/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.utils;

public class AntiDelayBuffer {
    private final int size;
    private final float[] buffer;
    private int index = 0;
    private int latency;

    public AntiDelayBuffer(int latency, int size) {
        this.latency = latency;
        this.size = size;
        this.buffer = new float[size];
    }

    public boolean process(float[] samples) {
        if (samples.length != this.size) {
            throw new IllegalArgumentException();
        }
        if (samples.length <= this.latency) {
            this.latency -= samples.length;
            return false;
        }
        if (this.latency > 0) {
            int i = this.latency;
            while (i < samples.length) {
                this.buffer[this.index++] = samples[i];
                ++i;
            }
            this.latency = 0;
            return false;
        }
        assert (this.latency == 0);
        int i = 0;
        while (i < samples.length) {
            this.buffer[this.index] = samples[i];
            samples[i] = this.buffer[i];
            this.index = (this.index + 1) % this.buffer.length;
            ++i;
        }
        return true;
    }
}

