/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp;

import java.util.Arrays;

public class MaxBuffer {
    private int size;
    private float[] values;
    private int index;
    private float max;

    public MaxBuffer(int size, float initValues) {
        this.size = size;
        this.values = new float[size];
        this.index = 0;
        Arrays.fill(this.values, initValues);
        this.max = initValues;
    }

    public float push(float value) {
        float old = this.values[this.index];
        this.values[this.index] = value;
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        if (value > this.max) {
            this.max = value;
        } else if (old == this.max && this.values[this.index] != this.max) {
            this.max = this.recalc();
        }
        return this.max;
    }

    public double push(double value) {
        return this.push((float)value);
    }

    private float recalc() {
        float result = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i] > result) {
                result = this.values[i];
            }
            ++i;
        }
        return result;
    }

    public void raiseBy(float amount) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.values[n] = this.values[n] + amount;
        }
        this.max += amount;
    }

    public float getMax() {
        return this.max;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size == this.size) {
            return;
        }
        float[] old = this.values;
        this.size = size;
        this.values = new float[size];
        int min = size < old.length ? size : old.length;
        int offset = size - min;
        int i = 0;
        while (i < min) {
            this.values[i + offset] = old[(this.index + i) % old.length];
            ++i;
        }
        if (size < old.length) {
            this.max = this.recalc();
        }
        this.index = 0;
    }

    public void resetTo(float value) {
        Arrays.fill(this.values, value);
        this.max = value;
        this.index = 0;
    }
}

