/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.fft;

import java.util.Map;
import java.util.Random;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.UnityRoots;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.struct.WeakCacheMap;

public class BooFFT
implements Cloneable {
    private final int length;
    private final int log;
    private static final float sqrthalf = 0.70710677f;
    private Cmplx[] d16;
    private Cmplx[] d32;
    private Cmplx[] d64;
    private Cmplx[] d128;
    private Cmplx[] d256;
    private Cmplx[] d512;
    protected Cmplx[][] roots;
    private Cmplx[] work;
    private Cmplx[] workScrambled;
    private static final ThreadLocal<Map<Integer, BooFFT>> instanceCache = new ThreadLocal<Map<Integer, BooFFT>>(){

        @Override
        protected Map<Integer, BooFFT> initialValue() {
            return new WeakCacheMap<Integer, BooFFT>();
        }
    };

    public static synchronized BooFFT getInstance(int length) {
        Map<Integer, BooFFT> ffts = instanceCache.get();
        BooFFT result = ffts.get(length);
        if (result == null) {
            result = new BooFFT(length);
            ffts.put(length, result);
        }
        return result;
    }

    public static synchronized BooFFT getPrivateInstance(int length) {
        BooFFT instance = BooFFT.getInstance(length);
        return instance.clone();
    }

    protected BooFFT(int length) {
        if ((length & length - 1) != 0) {
            throw new IllegalArgumentException("lenght must be a power of 2");
        }
        this.length = length;
        this.log = BooFFT.log2(length);
        UnityRoots generator = UnityRoots.getInstance();
        this.roots = new Cmplx[(this.log < 10 ? 10 : this.log) + 2][];
        int i = this.roots.length - 1;
        while (i >= 10) {
            int div = i == this.log + 1 ? 4 : 8;
            int size = 1 << i;
            this.roots[i] = generator.getRoots(size, size / div);
            --i;
        }
        this.d512 = this.fillRoots(generator, 512, 9);
        this.d256 = this.fillRoots(generator, 256, 8);
        this.d128 = this.fillRoots(generator, 128, 7);
        this.d64 = this.fillRoots(generator, 64, 6);
        this.d32 = this.fillRoots(generator, 32, 5);
        this.d16 = this.fillRoots(generator, 16, 4);
        this.fillRoots(generator, 8, 3);
        this.fillRoots(generator, 4, 2);
        this.initPrivateData();
    }

    private void initPrivateData() {
        this.work = Cmplx.newArray(this.length);
        this.workScrambled = new Cmplx[this.length];
        int i = 0;
        while (i < this.length) {
            this.workScrambled[this.replace((int)i, (int)this.length)] = this.work[i];
            ++i;
        }
    }

    private int replace(int i, int n) {
        if (n <= 2) {
            return i;
        }
        int m = n / 2;
        if (i < m) {
            return this.replace(i, m) * 2;
        }
        if ((i -= m) < (m /= 2)) {
            return this.replace(i, m) * 4 + 1;
        }
        return this.replace(i -= m, m) * 4 - 1 & n - 1;
    }

    private Cmplx[] fillRoots(UnityRoots generator, int size, int log) {
        Cmplx[] result = generator.getRoots(size, size / 4);
        this.roots[log] = result;
        return result;
    }

    public int size() {
        return this.length;
    }

    protected final void butterfly(Cmplx a0, Cmplx a1, Cmplx a2, Cmplx a3, float wre, float wim) {
        float t5 = a2.re * wre + a2.im * wim;
        float t6 = a2.im * wre - a2.re * wim;
        float t7 = a3.re * wre - a3.im * wim;
        float t8 = a3.im * wre + a3.re * wim;
        float t1 = t5 + t7;
        float t2 = t6 + t8;
        float t3 = t6 - t8;
        float t4 = t7 - t5;
        a2.re = a0.re - t1;
        a2.im = a0.im - t2;
        a3.re = a1.re - t3;
        a3.im = a1.im - t4;
        a0.re += t1;
        a0.im += t2;
        a1.re += t3;
        a1.im += t4;
    }

    protected final void butterflyHalf(Cmplx a0, Cmplx a1, Cmplx a2, Cmplx a3) {
        float t5 = (a2.re + a2.im) * 0.70710677f;
        float t6 = (a2.im - a2.re) * 0.70710677f;
        float t7 = (a3.re - a3.im) * 0.70710677f;
        float t8 = (a3.im + a3.re) * 0.70710677f;
        float t1 = t5 + t7;
        float t2 = t6 + t8;
        float t3 = t6 - t8;
        float t4 = t7 - t5;
        a2.re = a0.re - t1;
        a2.im = a0.im - t2;
        a3.re = a1.re - t3;
        a3.im = a1.im - t4;
        a0.re += t1;
        a0.im += t2;
        a1.re += t3;
        a1.im += t4;
    }

    protected final void butterflyFirst(Cmplx a0, Cmplx a1, Cmplx a2, Cmplx a3) {
        float t1 = a2.re + a3.re;
        float t2 = a2.im + a3.im;
        float t3 = a2.im - a3.im;
        float t4 = a3.re - a2.re;
        a2.re = a0.re - t1;
        a2.im = a0.im - t2;
        a3.re = a1.re - t3;
        a3.im = a1.im - t4;
        a0.re += t1;
        a0.im += t2;
        a1.re += t3;
        a1.im += t4;
    }

    private final void pass(Cmplx[] a, int a0, Cmplx[] w, int n2) {
        int a1 = n2 + a0;
        int a2 = a1 + n2;
        int a3 = a2 + n2;
        this.butterflyFirst(a[a0], a[a1], a[a2], a[a3]);
        int k = n2 - 1;
        int b = 1;
        do {
            this.butterfly(a[b + a0], a[b + a1], a[b + a2], a[b + a3], w[b].re, w[b].im);
            ++b;
        } while (--k > 0);
    }

    protected final void pass2(Cmplx[] a, int a0, Cmplx[] w, int n) {
        int a1 = 2 * n + a0;
        int a2 = 4 * n + a0;
        int a3 = 6 * n + a0;
        this.butterflyFirst(a[a0], a[a1], a[a2], a[a3]);
        int wb = 1;
        do {
            this.butterfly(a[++a0], a[++a1], a[++a2], a[++a3], w[wb].re, w[wb].im);
        } while (++wb < n);
        this.butterflyHalf(a[++a0], a[++a1], a[++a2], a[++a3]);
        --wb;
        do {
            this.butterfly(a[++a0], a[++a1], a[++a2], a[++a3], w[wb].im, w[wb].re);
        } while (--wb > 0);
    }

    private final void fft2(Cmplx[] a, int off) {
        Cmplx a0 = a[off];
        Cmplx a1 = a[off + 1];
        float t1 = a0.re + a1.re;
        float t2 = a0.im + a1.im;
        float t3 = a0.re - a1.re;
        float t4 = a0.im - a1.im;
        a0.re = t1;
        a0.im = t2;
        a1.re = t3;
        a1.im = t4;
    }

    private final void fft2_xy(Cmplx[] a, int off) {
        Cmplx a0_x = a[off];
        Cmplx a1_x = a[off + 1];
        float t1_x = a0_x.re + a1_x.re;
        Cmplx a0_y = a[off + 2];
        float t2_x = a0_x.im + a1_x.im;
        Cmplx a1_y = a[off + 3];
        float t3_x = a0_x.re - a1_x.re;
        float t4_x = a0_x.im - a1_x.im;
        a0_x.re = t1_x;
        float t1_y = a0_y.re + a1_y.re;
        a0_x.im = t2_x;
        float t2_y = a0_y.im + a1_y.im;
        a1_x.re = t3_x;
        float t3_y = a0_y.re - a1_y.re;
        a1_x.im = t4_x;
        float t4_y = a0_y.im - a1_y.im;
        a0_y.re = t1_y;
        a0_y.im = t2_y;
        a1_y.re = t3_y;
        a1_y.im = t4_y;
    }

    private final void fft4(Cmplx[] a, int off) {
        Cmplx a0 = a[off];
        Cmplx a1 = a[off + 1];
        Cmplx a2 = a[off + 2];
        Cmplx a3 = a[off + 3];
        float t1 = a0.re + a1.re;
        float t2 = a0.re - a1.re;
        float t3 = a0.im + a1.im;
        float t4 = a0.im - a1.im;
        float t5 = a2.re + a3.re;
        float t6 = a2.re - a3.re;
        float t7 = a2.im + a3.im;
        float t8 = a2.im - a3.im;
        a0.re = t1 + t5;
        a0.im = t3 + t7;
        a1.re = t2 + t8;
        a1.im = t4 - t6;
        a2.re = t1 - t5;
        a2.im = t3 - t7;
        a3.re = t2 - t8;
        a3.im = t4 + t6;
    }

    private final void fft8(Cmplx[] a, int off) {
        this.fft4(a, off);
        this.fft2_xy(a, off + 4);
        this.butterflyFirst(a[off + 0], a[off + 2], a[off + 4], a[off + 6]);
        this.butterflyHalf(a[off + 1], a[off + 3], a[off + 5], a[off + 7]);
    }

    private final void fft16(Cmplx[] a, int off) {
        this.fft8(a, off);
        this.fft4(a, off + 8);
        this.fft4(a, off + 12);
        this.pass(a, off, this.d16, 4);
    }

    private final void fft32(Cmplx[] a, int off) {
        this.fft16(a, off);
        this.fft8(a, off + 16);
        this.fft8(a, off + 24);
        this.pass(a, off, this.d32, 8);
    }

    private final void fft64(Cmplx[] a, int off) {
        this.fft32(a, off);
        this.fft16(a, off + 32);
        this.fft16(a, off + 48);
        this.pass(a, off, this.d64, 16);
    }

    private final void fft128(Cmplx[] a, int off) {
        this.fft64(a, off);
        this.fft32(a, off + 64);
        this.fft32(a, off + 96);
        this.pass(a, off, this.d128, 32);
    }

    private final void fft256(Cmplx[] a, int off) {
        this.fft128(a, off);
        this.fft64(a, off + 128);
        this.fft64(a, off + 192);
        this.pass(a, off, this.d256, 64);
    }

    private final void fft512(Cmplx[] a, int off) {
        this.fft256(a, off);
        this.fft128(a, off + 256);
        this.fft128(a, off + 384);
        this.pass(a, off, this.d512, 128);
    }

    protected void fftN(Cmplx[] a, int off, int log) {
        switch (log) {
            case 1: {
                this.fft2(a, off);
                break;
            }
            case 2: {
                this.fft4(a, off);
                break;
            }
            case 3: {
                this.fft8(a, off);
                break;
            }
            case 4: {
                this.fft16(a, off);
                break;
            }
            case 5: {
                this.fft32(a, off);
                break;
            }
            case 6: {
                this.fft64(a, off);
                break;
            }
            case 7: {
                this.fft128(a, off);
                break;
            }
            case 8: {
                this.fft256(a, off);
                break;
            }
            case 9: {
                this.fft512(a, off);
                break;
            }
            default: {
                if (log < 1) {
                    return;
                }
                this.fftBig(a, off, log);
            }
        }
    }

    protected void fftBig(Cmplx[] a, int off, int log) {
        int size = 1 << log;
        int size4 = size / 4;
        this.fftN(a, off, log - 1);
        this.fftN(a, off + size4 + size4, log - 2);
        this.fftN(a, off + size4 + size4 + size4, log - 2);
        this.pass2(a, off, this.roots[log], size / 8);
    }

    public static int log2(int value) {
        int log = 0;
        if (value >= 65536) {
            log += 16;
            value >>>= 16;
        }
        if (value >= 256) {
            log += 8;
            value >>>= 8;
        }
        if (value >= 16) {
            log += 4;
            value >>>= 4;
        }
        if (value >= 4) {
            log += 2;
            value >>>= 2;
        }
        if (value >= 2) {
            ++log;
        }
        return log;
    }

    public void forwC2C(Cmplx[] src, Cmplx[] dst) {
        if (src.length != this.length || dst.length != this.length) {
            throw new IllegalArgumentException("The size of the arrays must match the size of this FFT");
        }
        this.fromCmplx(src, this.workScrambled);
        this.fft(this.work);
        this.fix(this.work, dst, this.length);
    }

    public void backC2C(Cmplx[] src, Cmplx[] dst) {
        if (src.length != this.length || dst.length != this.length) {
            throw new IllegalArgumentException("The size of the arrays must match the size of this FFT");
        }
        this.unfix(src, this.workScrambled);
        this.fft(this.work);
        this.toCmplx(this.work, dst);
    }

    public void forwR2C(float[] r, Cmplx[] f) {
        if (r.length != this.length * 2 || f.length != this.length + 1) {
            throw new IllegalArgumentException("The size of the arrays must match the size of this FFT");
        }
        this.fromReal(r, this.workScrambled);
        this.fft(this.work);
        this.realFix(this.work, f);
    }

    public void forwR2C(float[] r1, float[] r2, Cmplx[] f) {
        if (r1.length + r2.length != this.length * 2 || f.length != this.length + 1) {
            throw new IllegalArgumentException("The size of the arrays must match the size of this FFT");
        }
        this.fromReal(r1, r2, this.workScrambled);
        this.fft(this.work);
        this.realFix(this.work, f);
    }

    public void backC2R(Cmplx[] f, float[] r) {
        if (r.length != this.length * 2 || f.length != this.length + 1) {
            throw new IllegalArgumentException("The size of the arrays must match the size of this FFT");
        }
        this.realUnfix(f, this.workScrambled);
        this.fft(this.work);
        this.toReal(this.work, r);
    }

    protected void fft(Cmplx[] a) {
        this.fftN(a, 0, this.log);
    }

    protected void fromCmplx(Cmplx[] src, Cmplx[] aScrambled) {
        assert (src.length == aScrambled.length);
        int i = 0;
        while (i < aScrambled.length) {
            aScrambled[i].im = src[i].re;
            aScrambled[i].re = src[i].im;
            ++i;
        }
    }

    protected void toCmplx(Cmplx[] a, Cmplx[] dst) {
        assert (a.length == dst.length);
        int i = 0;
        while (i < a.length) {
            dst[i].re = a[i].re;
            dst[i].im = a[i].im;
            ++i;
        }
    }

    protected void fix(Cmplx[] a, Cmplx[] r, float scaleFactor) {
        float scale = 1.0f / scaleFactor;
        int i = 0;
        while (i < this.length) {
            r[i].im = a[i].re * scale;
            r[i].re = a[i].im * scale;
            ++i;
        }
    }

    protected void unfix(Cmplx[] r, Cmplx[] aScrambled) {
        int i = 0;
        while (i < this.length) {
            aScrambled[i].set(r[i]);
            ++i;
        }
    }

    protected void fromReal(float[] r, Cmplx[] aScrambled) {
        assert (aScrambled.length * 2 == r.length);
        int j = 0;
        int i = 0;
        while (i < this.length) {
            aScrambled[i].im = r[j++];
            aScrambled[i].re = r[j++];
            ++i;
        }
    }

    protected void fromReal(float[] r1, float[] r2, Cmplx[] aScrambled) {
        assert (aScrambled.length * 2 == r1.length + r2.length);
        int i = 0;
        int j = 0;
        while (j < r1.length) {
            aScrambled[i].im = r1[j + 0];
            aScrambled[i].re = r1[j + 1];
            ++i;
            j += 2;
        }
        j = 0;
        while (j < r2.length) {
            aScrambled[i].im = r1[j + 0];
            aScrambled[i].re = r1[j + 1];
            ++i;
            j += 2;
        }
    }

    protected void toReal(Cmplx[] a, float[] r) {
        assert (a.length * 2 == r.length);
        int j = 0;
        int i = 0;
        while (i < this.length) {
            r[j++] = a[i].re;
            r[j++] = a[i].im;
            ++i;
        }
    }

    protected void realFix(Cmplx[] a, Cmplx[] r) {
        this.realFix(a, r, this.length);
    }

    protected void realFix(Cmplx[] a, Cmplx[] r, float scale) {
        boolean dc = false;
        int nq = this.length / 2;
        float scale1 = 1.0f / scale;
        float scale2 = scale1 / 2.0f;
        Cmplx[] w = this.roots[this.log + 1];
        r[0].re = (a[0].im + a[0].re) * scale1;
        r[0].im = 0.0f;
        r[this.length].re = (a[0].im - a[0].re) * scale1;
        r[this.length].im = 0.0f;
        int i = 1;
        int j = this.length - 1;
        while (i < nq) {
            Cmplx ai = a[i];
            Cmplx aj = a[j];
            Cmplx wi = w[i];
            float t1 = ai.im + aj.im;
            float t2 = ai.re - aj.re;
            float t3 = aj.re + ai.re;
            float t4 = aj.im - ai.im;
            float t5 = t3 * wi.re - t4 * wi.im;
            float t6 = t3 * wi.im + t4 * wi.re;
            r[i].re = (t1 + t5) * scale2;
            r[i].im = (t6 + t2) * scale2;
            r[j].re = (t1 - t5) * scale2;
            r[j].im = (t6 - t2) * scale2;
            ++i;
            --j;
        }
        r[nq].re = a[nq].im * scale1;
        r[nq].im = a[nq].re * scale1;
    }

    protected void realUnfix(Cmplx[] r, Cmplx[] aScrambled) {
        boolean dc = false;
        int nq = this.length / 2;
        Cmplx[] w = this.roots[this.log + 1];
        aScrambled[0].re = (r[0].re + r[this.length].re) / 2.0f;
        aScrambled[0].im = (r[0].re - r[this.length].re) / 2.0f;
        int i = 1;
        int j = this.length - 1;
        while (i < nq) {
            Cmplx ri = r[i];
            Cmplx rj = r[j];
            Cmplx wi = w[i];
            float t1 = ri.re + rj.re;
            float t2 = ri.im - rj.im;
            float t3 = ri.re - rj.re;
            float t4 = ri.im + rj.im;
            float t5 = t4 * wi.im + t3 * wi.re;
            float t6 = t4 * wi.re - t3 * wi.im;
            aScrambled[i].re = (t1 - t6) / 2.0f;
            aScrambled[i].im = (t5 + t2) / 2.0f;
            aScrambled[j].re = (t1 + t6) / 2.0f;
            aScrambled[j].im = (t5 - t2) / 2.0f;
            ++i;
            --j;
        }
        aScrambled[nq].re = r[nq].re;
        aScrambled[nq].im = r[nq].im;
    }

    public BooFFT clone() {
        try {
            BooFFT result = (BooFFT)super.clone();
            result.initPrivateData();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public static void main(String[] args) {
        int Log = 11;
        int Size = 2048;
        BooFFT fft = new BooFFT(2048);
        Cmplx[] spectrum = Cmplx.newArray(2049);
        float[] samples = new float[4096];
        float[] check = new float[4096];
        Random random = new Random(0L);
        System.out.println("Checking real transform accuracy");
        int i = 0;
        while (i < samples.length) {
            samples[i] = random.nextFloat() * 2.0f - 1.0f;
            check[i] = samples[i];
            ++i;
        }
        fft.forwR2C(samples, spectrum);
        fft.backC2R(spectrum, samples);
        float maxErr = 0.0f;
        float avgErr = 0.0f;
        int i2 = 0;
        while (i2 < 4096) {
            float diff = samples[i2] - check[i2];
            float err = diff < 0.0f ? -diff : diff;
            avgErr += err;
            if (err > maxErr) {
                maxErr = err;
            }
            ++i2;
        }
        System.out.println("Max error: " + maxErr + " (" + AudioMath.levelToDb(maxErr) + "dB)");
        System.out.println("Avg error: " + (avgErr /= 4096.0f) + " (" + AudioMath.levelToDb(avgErr) + "dB)");
        i2 = 0;
        while (i2 < samples.length) {
            samples[i2] = 0.0f;
            ++i2;
        }
        System.out.println("Testing speed (real forward+backward FFT of size 4096 (real numbers), this takes about 15 seconds)...");
        Thread.currentThread().setPriority(10);
        long start = System.currentTimeMillis();
        long stop = 0L;
        do {
            int i3 = 0;
            while (i3 < 100) {
                fft.forwR2C(samples, spectrum);
                fft.backC2R(spectrum, samples);
                ++i3;
            }
        } while ((stop = System.currentTimeMillis()) < start + 5000L);
        start = System.currentTimeMillis();
        stop = 0L;
        long count = 0L;
        do {
            int i4 = 0;
            while (i4 < 100) {
                fft.forwR2C(samples, spectrum);
                fft.backC2R(spectrum, samples);
                ++i4;
            }
            count += 100L;
        } while ((stop = System.currentTimeMillis()) < start + 10000L);
        double time = (double)(stop - start) * 1000.0 / (double)count;
        System.out.println("Duration of real forward+backward FFT (microseconds): " + time);
        Cmplx[] source = Cmplx.newArray(2048);
        Cmplx[] dest = Cmplx.newArray(2048);
        System.out.println("Testing speed (complex forward+backward FFT of size 2048 (complex numbers), this takes about 15 seconds)...");
        Thread.currentThread().setPriority(10);
        long start2 = System.currentTimeMillis();
        long stop2 = 0L;
        do {
            int i5 = 0;
            while (i5 < 100) {
                fft.forwC2C(source, dest);
                fft.backC2C(dest, source);
                ++i5;
            }
        } while ((stop2 = System.currentTimeMillis()) < start2 + 5000L);
        start2 = System.currentTimeMillis();
        stop2 = 0L;
        long count2 = 0L;
        do {
            int i6 = 0;
            while (i6 < 100) {
                fft.forwC2C(source, dest);
                fft.backC2C(dest, source);
                ++i6;
            }
            count2 += 100L;
        } while ((stop2 = System.currentTimeMillis()) < start2 + 10000L);
        double time2 = (double)(stop2 - start2) * 1000.0 / (double)count2;
        System.out.println("Duration of complex forward+backward FFT (microseconds): " + time2);
    }
}

