/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.fft;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Random;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class StftBenchmark {
    private static final int BENCHMARK_DURATION = 20;
    private static final int BLOCKS = 10000;
    private final int blockSize;
    private final int hopSize;
    private final int olaSize;
    private float[] input;
    private float[] output;
    private int ioIndex;
    private BooFFT fft;
    private float[] ioBuffer;
    private float[] splitBuffer;
    private int splitIndex;
    private float[] analysisWindow;
    private float[] synthesisWindow;
    private float[] correctionWindow;
    private float[] processBuffer;
    private Cmplx[] spectrum;
    private float[] filter;
    private float[] olaBuffer;
    private int olaIndex;

    public StftBenchmark(int blockSize, int overlap) {
        this.blockSize = blockSize;
        this.hopSize = blockSize / overlap;
        this.olaSize = blockSize - this.hopSize;
        Random rnd = new Random();
        this.input = new float[this.hopSize * 10000];
        int i = 0;
        while (i < this.input.length) {
            this.input[i] = rnd.nextFloat() - 0.5f;
            ++i;
        }
        this.output = new float[this.hopSize * 10000];
        this.fft = BooFFT.getInstance(blockSize / 2);
        this.ioBuffer = new float[this.hopSize];
        this.splitBuffer = new float[this.olaSize];
        this.analysisWindow = new float[blockSize];
        Windows.fillWindow(this.analysisWindow, Windows.HannCoefs);
        this.synthesisWindow = new float[blockSize];
        Windows.fillWindow(this.synthesisWindow, Windows.HannCoefs);
        this.correctionWindow = new float[this.hopSize];
        Windows.fillInverseWindow(this.analysisWindow, this.synthesisWindow, this.correctionWindow, blockSize, this.hopSize);
        this.processBuffer = new float[blockSize];
        this.spectrum = Cmplx.newArray(blockSize / 2 + 1);
        this.filter = new float[blockSize / 2 + 1];
        Arrays.fill(this.filter, 1.0f);
        this.olaBuffer = new float[this.olaSize];
    }

    private void onePass() {
        int i = 0;
        while (i < this.hopSize) {
            this.ioBuffer[i] = this.input[i + this.ioIndex];
            ++i;
        }
        i = 0;
        while (i < this.olaSize) {
            this.processBuffer[i] = this.splitBuffer[(i + this.splitIndex) % this.olaSize];
            ++i;
        }
        i = 0;
        while (i < this.hopSize) {
            this.processBuffer[i + this.olaSize] = this.ioBuffer[i];
            ++i;
        }
        i = 0;
        while (i < this.hopSize) {
            this.splitBuffer[(i + this.splitIndex) % this.olaSize] = this.ioBuffer[i];
            ++i;
        }
        this.splitIndex = (this.splitIndex + this.hopSize) % this.olaSize;
        i = 0;
        while (i < this.blockSize) {
            int n = i;
            this.processBuffer[n] = this.processBuffer[n] * this.analysisWindow[i];
            ++i;
        }
        this.fft.forwR2C(this.processBuffer, this.spectrum);
        i = 0;
        while (i < this.spectrum.length) {
            this.spectrum[i].mul(this.filter[i]);
            ++i;
        }
        this.fft.backC2R(this.spectrum, this.processBuffer);
        i = 0;
        while (i < this.blockSize) {
            int n = i;
            this.processBuffer[n] = this.processBuffer[n] * this.synthesisWindow[i];
            ++i;
        }
        i = 0;
        while (i < this.hopSize) {
            this.ioBuffer[i] = (this.olaBuffer[(i + this.olaIndex) % this.olaSize] + this.processBuffer[i]) * this.correctionWindow[i];
            ++i;
        }
        this.olaIndex = (this.olaIndex + this.hopSize) % this.olaSize;
        i = 0;
        while (i < this.olaSize - this.hopSize) {
            int n = (i + this.olaIndex) % this.olaSize;
            this.olaBuffer[n] = this.olaBuffer[n] + this.processBuffer[i + this.hopSize];
            ++i;
        }
        i = this.olaSize - this.hopSize;
        while (i < this.olaSize) {
            this.olaBuffer[(i + this.olaIndex) % this.olaSize] = this.processBuffer[i + this.hopSize];
            ++i;
        }
        i = 0;
        while (i < this.hopSize) {
            this.output[i + this.ioIndex] = this.ioBuffer[i];
            ++i;
        }
        this.ioIndex = (this.ioIndex + this.hopSize) % this.output.length;
    }

    public int benchmark() {
        long start = System.currentTimeMillis();
        long stop = start + 20000L;
        long nbPass = 0L;
        while (System.currentTimeMillis() < stop) {
            this.onePass();
            ++nbPass;
        }
        long duration = System.currentTimeMillis() - start;
        return (int)(nbPass * 1000L / duration);
    }

    public int getNbPerSecondForRealtime(int sampleRate) {
        return (sampleRate + this.hopSize - 1) / this.hopSize;
    }

    public static void main(String[] args) {
        int BLOCK_SIZE = 2048;
        int OVERLAP = 4;
        int SAMPLE_RATE = 44100;
        System.out.println("Creating benchmark...");
        StftBenchmark benchmark = new StftBenchmark(2048, 4);
        System.out.println("Benchmark started. Duration is about 20s");
        int nbPass = benchmark.benchmark();
        System.out.println();
        System.out.println("Number of pass per second: " + nbPass);
        int nbRealtime = benchmark.getNbPerSecondForRealtime(44100);
        System.out.println("Realtime @ 44.1kHz mono: " + nbRealtime);
        double ratio = (double)nbPass / (double)nbRealtime;
        System.out.println("Ratio: " + new DecimalFormat("#0.00").format(ratio) + " x realtime");
    }
}

