/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import java.util.Arrays;
import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.IResetable;
import org.corebounce.common.dsp.resample.SincLiBuffer;

public class FastSincLiConvolvedAudioSource
implements IAudioSource,
IResetable {
    private final IAudioSource source;
    private final SincLiBuffer sincBuffer;
    private final int nbZeroCross;
    private final double step;
    private final float amplitudeCorrection;
    private final int bufferSize;
    private final int historySize;
    private final float[] buffer;
    private int eosIndex;
    private double index;
    private static final float fPI = (float)Math.PI;
    private final float startOffset;
    private final float deltaOffset;

    public FastSincLiConvolvedAudioSource(IAudioSource source, int nbSamplesPerZeroCross, int nbZeroCross, float kaiserAttenuationDb, float stretch, int bufferSize, double srcStep, float amplitudeCorrection) {
        this.source = source;
        this.sincBuffer = new SincLiBuffer(nbSamplesPerZeroCross, nbZeroCross, kaiserAttenuationDb, stretch);
        this.nbZeroCross = nbZeroCross;
        this.bufferSize = bufferSize;
        this.historySize = nbZeroCross * 2 + 1;
        this.buffer = new float[bufferSize + this.historySize];
        this.amplitudeCorrection = amplitudeCorrection;
        this.step = srcStep;
        this.index = (double)(bufferSize + this.historySize - nbZeroCross) - this.step;
        this.eosIndex = this.buffer.length - nbZeroCross;
        this.startOffset = (float)(-nbZeroCross) * (float)Math.PI * this.sincBuffer.getScaleFactor();
        this.deltaOffset = (float)Math.PI * this.sincBuffer.getScaleFactor();
    }

    public void reset() {
        Arrays.fill(this.buffer, 0.0f);
        this.index = (double)(this.bufferSize + this.historySize - this.nbZeroCross) - this.step;
        this.eosIndex = this.buffer.length - this.nbZeroCross;
        if (this.source instanceof IResetable) {
            ((IResetable)((Object)this.source)).reset();
        }
    }

    public int getSamples(float[] target, int start, int count) {
        int sourceIndex = 0;
        int i = 0;
        while (i < count) {
            float sinc;
            float sample;
            this.index += this.step;
            sourceIndex = (int)(this.index + 0.5);
            float sincShift = (float)(this.index - (double)sourceIndex) * this.deltaOffset;
            float result = 0.0f;
            float sincOffset = this.startOffset + sincShift;
            sourceIndex -= this.prefetch(sourceIndex + this.nbZeroCross);
            int offset = -this.nbZeroCross;
            while (offset < 0) {
                sample = this.buffer[sourceIndex - offset];
                sinc = this.sincBuffer.getPreScaled(-sincOffset);
                result += sample * sinc;
                sincOffset += this.deltaOffset;
                ++offset;
            }
            float sample2 = this.buffer[sourceIndex];
            float sinc2 = this.sincBuffer.getPreScaled(sincOffset > 0.0f ? sincOffset : -sincOffset);
            result += sample2 * sinc2;
            sincOffset += this.deltaOffset;
            offset = 1;
            while (offset <= this.nbZeroCross) {
                sample = this.buffer[sourceIndex - offset];
                sinc = this.sincBuffer.getPreScaled(sincOffset);
                result += sample * sinc;
                sincOffset += this.deltaOffset;
                ++offset;
            }
            target[start + i] = result * this.amplitudeCorrection;
            ++i;
        }
        if (sourceIndex < this.eosIndex) {
            return target.length;
        }
        sourceIndex = (int)(this.index + this.step + 0.5);
        return Math.max((int)((double)target.length - (double)(sourceIndex - this.eosIndex) / this.step + 0.5), 0);
    }

    private int prefetch(int maxIndex) {
        int result = 0;
        while (maxIndex >= this.buffer.length) {
            this.fetchNextBuffer();
            maxIndex -= this.bufferSize;
            result += this.bufferSize;
        }
        return result;
    }

    private void fetchNextBuffer() {
        System.arraycopy(this.buffer, this.bufferSize, this.buffer, 0, this.historySize);
        this.eosIndex += this.source.getSamples(this.buffer, this.historySize, this.bufferSize);
        this.index -= (double)this.bufferSize;
        this.eosIndex -= this.bufferSize;
    }
}

