/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.FastSincLiConvolvedAudioSource;
import org.corebounce.common.dsp.resample.IResampler;

public class FastSincResampler
implements IResampler {
    private final FastSincLiConvolvedAudioSource source;
    private final int latency;

    public FastSincResampler(IAudioSource source, double ratio, int nbSamplesPerZeroCross, int nbZeroCross, float kaiserAttenuationDb, float antiAliasing, int bufferSize) {
        if (nbZeroCross < 1) {
            throw new IllegalArgumentException();
        }
        float amplitudeCorrection = (float)Math.min(ratio, 1.0);
        float sincStretch = 1.0f / amplitudeCorrection;
        double srcStep = 1.0 / ratio;
        this.source = new FastSincLiConvolvedAudioSource(source, nbSamplesPerZeroCross, nbZeroCross, kaiserAttenuationDb, sincStretch, bufferSize, srcStep, amplitudeCorrection);
        this.latency = nbZeroCross;
    }

    public void reset() {
        this.source.reset();
    }

    public int resample(float[] output) {
        return this.source.getSamples(output, 0, output.length);
    }

    public int getLatency() {
        return this.latency;
    }
}

