/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.FastSincResampler;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.LinearResampler;
import org.corebounce.common.dsp.resample.PolyphaseResampler;
import org.corebounce.common.dsp.resample.SampleAndHoldResampler;
import org.corebounce.common.dsp.resample.SweepableLinearResampler;
import org.corebounce.common.dsp.resample.SweepableSincResampler;
import org.corebounce.common.math.Fraction;

public class ResamplerFactory {
    private static final int SINC_UPSAMPLE_FACTOR_LOW = 64;
    private static final int SINC_NB_ZERO_CROSS_LOW = 4;
    private static final float SINC_KAISER_FACTOR_LOW = 50.0f;
    private static final int SINC_UPSAMPLE_FACTOR_MED = 256;
    private static final int SINC_NB_ZERO_CROSS_MED = 13;
    private static final float SINC_KAISER_FACTOR_MED = 80.0f;
    private static final int SINC_UPSAMPLE_FACTOR_HIGH = 1024;
    private static final int SINC_NB_ZERO_CROSS_HIGH = 40;
    private static final float SINC_KAISER_FACTOR_HIGH = 120.0f;
    private static final int SINC_UPSAMPLE_FACTOR_ULTRA = 4096;
    private static final int SINC_NB_ZERO_CROSS_ULTRA = 80;
    private static final float SINC_KAISER_FACTOR_ULTRA = 144.0f;
    public static final int MIN_QUALITY = 0;
    public static final int MEDIUM_QUALITY = 2;
    public static final int MAX_QUALITY = 5;

    public static IResampler getResampler(IAudioSource source, double ratio, int quality) {
        return ResamplerFactory.getResampler(source, ratio, quality, false, 8192);
    }

    public static IResampler getResampler(IAudioSource source, double ratio, int quality, boolean sweepable) {
        return ResamplerFactory.getResampler(source, ratio, quality, sweepable, 8192);
    }

    public static IResampler getResampler(IAudioSource source, double ratio, int quality, boolean sweepable, int bufferSize) {
        switch (quality) {
            case 0: {
                return new SampleAndHoldResampler(source, ratio, bufferSize);
            }
            case 1: {
                return new SweepableLinearResampler(source, ratio, bufferSize);
            }
            case 2: {
                if (sweepable) {
                    return new SweepableSincResampler(source, ratio, 64, 4, 50.0f, 1.0f, bufferSize);
                }
                return new FastSincResampler(source, ratio, 64, 4, 50.0f, 1.0f, bufferSize);
            }
            case 3: {
                if (sweepable) {
                    return new SweepableSincResampler(source, ratio, 256, 13, 80.0f, 1.0f, bufferSize);
                }
                return new FastSincResampler(source, ratio, 256, 13, 80.0f, 1.0f, bufferSize);
            }
            case 4: {
                if (sweepable) {
                    return new SweepableSincResampler(source, ratio, 1024, 40, 120.0f, 1.0f, bufferSize);
                }
                return new FastSincResampler(source, ratio, 1024, 40, 120.0f, 1.0f, bufferSize);
            }
            case 5: {
                if (sweepable) {
                    return new SweepableSincResampler(source, ratio, 4096, 80, 144.0f, 1.0f, bufferSize);
                }
                return new FastSincResampler(source, ratio, 4096, 80, 144.0f, 1.0f, bufferSize);
            }
        }
        throw new IllegalArgumentException("quality must be between 0 and 5");
    }

    public static IResampler getResampler(IAudioSource source, Fraction ratio, int quality, int bufferSize) {
        if (ratio.getExtNum() >= 256L || ratio.getDenom() >= 256L) {
            throw new IllegalArgumentException("Numerator and denominator must be less than 256");
        }
        switch (quality) {
            case 0: {
                return new SampleAndHoldResampler(source, ratio.doubleValue(), bufferSize);
            }
            case 1: {
                return new LinearResampler(source, ratio, bufferSize);
            }
            case 2: {
                return new PolyphaseResampler(source, ratio, 4, 50.0f, 1.0f, bufferSize);
            }
            case 3: {
                return new PolyphaseResampler(source, ratio, 13, 80.0f, 1.0f, bufferSize);
            }
            case 4: {
                return new PolyphaseResampler(source, ratio, 40, 120.0f, 1.0f, bufferSize);
            }
            case 5: {
                return new PolyphaseResampler(source, ratio, 80, 144.0f, 1.0f, bufferSize);
            }
        }
        throw new IllegalArgumentException("quality must be between 0 and 5");
    }
}

