/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import java.util.Arrays;
import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.IResetable;
import org.corebounce.common.dsp.resample.SincLiBuffer;
import org.corebounce.common.math.Fraction;

public class SincConvolvedAudioSource
implements IAudioSource,
IResetable {
    private final IAudioSource source;
    private final SincLiBuffer sincBuffer;
    private final int nbZeroCross;
    private final int denom;
    private final int step;
    private final float amplitudeCorrection;
    private final int bufferSize;
    private final int historySize;
    private final float[] buffer;
    private int eosIndex;
    private int index;
    private final int halfDenom;

    public SincConvolvedAudioSource(IAudioSource source, Fraction srcStep, int nbZeroCross, float kaiserAttenuationDb, int bufferSize, float stretch, float amplitudeCorrection) {
        this.source = source;
        int nbSamplesPerZeroCross = (int)srcStep.getDenom();
        this.sincBuffer = new SincLiBuffer(nbSamplesPerZeroCross, nbZeroCross, kaiserAttenuationDb, stretch);
        this.nbZeroCross = nbZeroCross;
        this.amplitudeCorrection = amplitudeCorrection;
        this.bufferSize = bufferSize;
        this.historySize = nbZeroCross * 2 + 1;
        this.buffer = new float[bufferSize + this.historySize];
        this.denom = (int)srcStep.getDenom();
        this.step = (int)srcStep.getExtNum();
        this.index = (bufferSize + this.historySize - nbZeroCross) * this.denom - this.step;
        this.eosIndex = this.buffer.length - nbZeroCross;
        this.halfDenom = (this.denom - 1) / 2;
    }

    public void reset() {
        Arrays.fill(this.buffer, 0.0f);
        this.index = (this.bufferSize + this.historySize - this.nbZeroCross) * this.denom - this.step;
        this.eosIndex = this.buffer.length - this.nbZeroCross;
        if (this.source instanceof IResetable) {
            ((IResetable)((Object)this.source)).reset();
        }
    }

    public int getSamples(float[] target, int start, int count) {
        int sourceIndex = 0;
        int i = 0;
        while (i < count) {
            float sinc;
            float sample;
            this.index += this.step;
            sourceIndex = (this.index + this.halfDenom) / this.denom;
            int sincShift = this.index - sourceIndex * this.denom;
            float result = 0.0f;
            int sincOffset = -this.nbZeroCross * this.denom + sincShift;
            sourceIndex -= this.prefetch(sourceIndex + this.nbZeroCross);
            int offset = this.nbZeroCross;
            while (offset > 0) {
                sample = this.buffer[sourceIndex + offset];
                sinc = this.sincBuffer.getPos(-sincOffset);
                result += sample * sinc;
                sincOffset += this.denom;
                --offset;
            }
            float sample2 = this.buffer[sourceIndex];
            float sinc2 = this.sincBuffer.get(sincOffset);
            result += sample2 * sinc2;
            sincOffset += this.denom;
            offset = 1;
            while (offset <= this.nbZeroCross) {
                sample = this.buffer[sourceIndex - offset];
                sinc = this.sincBuffer.getPos(sincOffset);
                result += sample * sinc;
                sincOffset += this.denom;
                ++offset;
            }
            target[start + i] = result * this.amplitudeCorrection;
            ++i;
        }
        if (sourceIndex <= this.eosIndex) {
            return target.length;
        }
        sourceIndex = (this.index + this.step + this.halfDenom) / this.denom;
        return Math.max(target.length - ((sourceIndex - this.eosIndex) * this.denom + this.step / 2) / this.step, 0);
    }

    private int prefetch(int maxIndex) {
        int result = 0;
        while (maxIndex >= this.buffer.length) {
            this.fetchNextBuffer();
            maxIndex -= this.bufferSize;
            result += this.bufferSize;
        }
        return result;
    }

    private void fetchNextBuffer() {
        System.arraycopy(this.buffer, this.buffer.length - this.historySize, this.buffer, 0, this.historySize);
        this.eosIndex += this.source.getSamples(this.buffer, this.historySize, this.bufferSize);
        this.index -= this.bufferSize * this.denom;
        this.eosIndex -= this.bufferSize;
    }
}

