/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountedInputStream
extends FilterInputStream {
    private long position = 0L;
    private long mark = 0L;

    public CountedInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        ++this.position;
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result > 0) {
            this.position += (long)result;
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        if (result > 0) {
            this.position += (long)result;
        }
        return result;
    }

    public long skip(long n) throws IOException {
        long result = super.skip(n);
        this.position += result;
        return result;
    }

    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.position;
    }

    public synchronized void reset() throws IOException {
        super.reset();
        this.position = this.mark;
    }

    public long getPosition() {
        return this.position;
    }
}

