/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.io;

import ch.tachyon.tunnel.utils.Pair;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.corebounce.common.io.TempFileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryLoader {
    private static final Set<Pair<Class<?>, String>> loadedLibraries = new HashSet();

    public static synchronized void loadLibrary(Class<?> forClass, String libName) throws IOException {
        Pair key = new Pair(forClass, (Object)libName);
        if (loadedLibraries.contains(key)) {
            return;
        }
        loadedLibraries.add(key);
        libName = System.mapLibraryName(libName);
        InputStream input = null;
        OutputStream output = null;
        File tempFile = null;
        try {
            String suffix;
            String prefix;
            input = forClass.getResourceAsStream(libName);
            if (input == null) {
                throw new UnsatisfiedLinkError("Library not found for " + forClass + ": " + libName);
            }
            BufferedInputStream binput = new BufferedInputStream(input);
            int sepPos = libName.lastIndexOf(".");
            if (sepPos < 0) {
                prefix = libName;
                suffix = null;
            } else {
                prefix = libName.substring(0, sepPos);
                suffix = libName.substring(sepPos);
            }
            tempFile = TempFileManager.createTempFile(prefix, suffix);
            output = new FileOutputStream(tempFile);
            BufferedOutputStream boutput = new BufferedOutputStream(output);
            byte[] data = new byte[32768];
            int read = binput.read(data);
            while (read > 0) {
                boutput.write(data, 0, read);
                read = binput.read(data);
            }
            boutput.flush();
            boutput.close();
            output = null;
            binput.close();
            input = null;
            System.load(tempFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
            if (tempFile != null) {
                TempFileManager.deleteTempFile(tempFile);
            }
            throw throwable;
        }
        if (input != null) {
            input.close();
        }
        if (output != null) {
            output.close();
        }
        if (tempFile != null) {
            TempFileManager.deleteTempFile(tempFile);
        }
    }
}

