/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.io;

import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Utils;
import java.util.ArrayList;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prefs {
    private static final int MAX_BYTE_ARRAY_LENGTH = 6144;
    private static Package curPackage = null;
    private static Preferences curPrefs = null;

    private static Preferences prefs(Class<?> clazz) {
        Package pack = clazz.getPackage();
        if (!pack.equals(curPackage)) {
            curPackage = pack;
            curPrefs = Preferences.userNodeForPackage(clazz);
        }
        return curPrefs;
    }

    public static String getString(Class<?> clazz, String key, String def) {
        String part;
        String result = Prefs.prefs(clazz).get(key, null);
        if (result != null) {
            return result;
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while ((part = Prefs.prefs(clazz).get(String.valueOf(key) + "." + index, null)) != null) {
            builder.append(part);
            ++index;
        }
        if (index == 0) {
            return def;
        }
        return builder.toString();
    }

    public static void putString(Class<?> clazz, String key, String value) {
        int index = 0;
        if (value.length() <= 8192) {
            Prefs.prefs(clazz).put(key, value);
        } else {
            Prefs.prefs(clazz).remove(key);
            int offset = 0;
            while (offset < value.length()) {
                int amount = Math.min(value.length() - offset, 8192);
                Prefs.prefs(clazz).put(String.valueOf(key) + "." + index, value.substring(offset, offset + amount));
                offset += amount;
                ++index;
            }
            if (index > 10) {
                Debug.warn((String)"Class {0} has put a long preference value for key {1}, length: {2}", (Object[])new Object[]{clazz.getSimpleName(), key, value.length()});
            }
        }
        while (Prefs.prefs(clazz).get(String.valueOf(key) + "." + index, null) != null) {
            Prefs.prefs(clazz).remove(String.valueOf(key) + "." + index);
            ++index;
        }
    }

    public static long getLong(Class<?> clazz, String key, long def) {
        return Prefs.prefs(clazz).getLong(key, def);
    }

    public static void putLong(Class<?> clazz, String key, long value) {
        Prefs.prefs(clazz).putLong(key, value);
    }

    public static int getInt(Class<?> clazz, String key, int def) {
        return Prefs.prefs(clazz).getInt(key, def);
    }

    public static void putInt(Class<?> clazz, String key, int value) {
        Prefs.prefs(clazz).putInt(key, value);
    }

    public static float getFloat(Class<?> clazz, String key, float def) {
        return Prefs.prefs(clazz).getFloat(key, def);
    }

    public static void putFloat(Class<?> clazz, String key, float value) {
        Prefs.prefs(clazz).putFloat(key, value);
    }

    public static double getDouble(Class<?> clazz, String key, double def) {
        return Prefs.prefs(clazz).getDouble(key, def);
    }

    public static void putDouble(Class<?> clazz, String key, double value) {
        Prefs.prefs(clazz).putDouble(key, value);
    }

    public static boolean getBoolean(Class<?> clazz, String key, boolean def) {
        return Prefs.prefs(clazz).getBoolean(key, def);
    }

    public static void putBoolean(Class<?> clazz, String key, boolean value) {
        Prefs.prefs(clazz).putBoolean(key, value);
    }

    public static void remove(Class<?> clazz, String key) {
        Prefs.prefs(clazz).remove(key);
    }

    private static byte[] getByteArray(Class<?> clazz, String key) {
        return Prefs.prefs(clazz).getByteArray(key, null);
    }

    private static void putByteArray(Class<?> clazz, String key, byte[] value) {
        assert (value.length <= 6144);
        Prefs.prefs(clazz).putByteArray(key, value);
    }

    public static <E> E getObject(Class<?> clazz, String key, E def, Class<E> type) {
        byte[] data = Prefs.getByteArray(clazz, key);
        if (data != null) {
            try {
                return (E)Utils.fromByteArray((byte[])data, type);
            }
            catch (Exception ex) {
                return def;
            }
        }
        ArrayList<byte[]> parts = new ArrayList<byte[]>();
        int length = 0;
        int index = 0;
        byte[] part = null;
        while ((part = Prefs.getByteArray(clazz, String.valueOf(key) + "." + index)) != null) {
            parts.add(part);
            length += part.length;
            ++index;
        }
        if (parts.isEmpty()) {
            return def;
        }
        data = new byte[length];
        int offset = 0;
        for (byte[] item : parts) {
            System.arraycopy(item, 0, data, offset, item.length);
            offset += item.length;
        }
        try {
            return (E)Utils.fromByteArray((byte[])data, type);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static <E> void putObject(Class<?> clazz, String key, E value) {
        int index = 0;
        byte[] data = Utils.toByteArray(value);
        if (data.length <= 6144) {
            Prefs.putByteArray(clazz, key, data);
        } else {
            Prefs.remove(clazz, key);
            int offset = 0;
            while (offset < data.length) {
                int amount = Math.min(data.length - offset, 6144);
                byte[] block = new byte[amount];
                System.arraycopy(data, offset, block, 0, amount);
                Prefs.putByteArray(clazz, String.valueOf(key) + "." + index, block);
                offset += amount;
                ++index;
            }
            if (index > 10) {
                Debug.warn((String)"Class {0} has put a long preference value for key {1}, length: {2}", (Object[])new Object[]{clazz.getSimpleName(), key, data.length});
            }
        }
        Prefs.prefs(clazz).putByteArray(key, Utils.toByteArray(value));
        while (Prefs.prefs(clazz).get(String.valueOf(key) + "." + index, null) != null) {
            Prefs.prefs(clazz).remove(String.valueOf(key) + "." + index);
            ++index;
        }
    }
}

