/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import ch.tachyon.tunnel.utils.ThreadUtils;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

public class ProgressMonitorBean
implements IProgressMonitor {
    private int currentStep;
    private int totalSteps;
    private String text;
    private Object[] textArgs;
    private boolean stoppable;
    private boolean cancellable;
    private boolean abortable;
    private double currentProgress;
    private double totalProgress;
    private String waitingOn;
    private boolean stopped;

    public synchronized void setStep(int current, int total) {
        this.currentStep = current;
        this.totalSteps = total;
    }

    public synchronized void setText(String text, Object ... args) {
        this.text = text;
        this.textArgs = args;
    }

    public synchronized void setAbortable(boolean stoppable, boolean cancellable) {
        this.stoppable = stoppable;
        this.cancellable = cancellable;
    }

    public synchronized void setProgress(double current, double total) throws OperationAbortedException {
        while (this.waitingOn != null && !this.stopped) {
            ThreadUtils.wait((Object)this);
        }
        this.currentProgress = current;
        this.totalProgress = total;
        this.abortable = true;
        if (this.stopped) {
            throw new OperationAbortedException(false);
        }
    }

    public synchronized void setNoAbortProgress(double current, double total) {
        while (this.waitingOn != null && !this.stopped) {
            ThreadUtils.wait((Object)this);
        }
        this.currentProgress = current;
        this.totalProgress = total;
        this.abortable = false;
    }

    public synchronized void setWaitingOn(String name) {
        this.waitingOn = name;
        this.notifyAll();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public synchronized void reset() {
    }

    public synchronized void dispose() {
    }

    public synchronized int getCurrentStep() {
        return this.currentStep;
    }

    public synchronized int getTotalSteps() {
        return this.totalSteps;
    }

    public synchronized String getText() {
        return this.text;
    }

    public synchronized Object[] getTextArgs() {
        return this.textArgs;
    }

    public synchronized boolean isStoppable() {
        return this.stoppable;
    }

    public synchronized boolean isCancellable() {
        return this.cancellable;
    }

    public synchronized boolean isAbortable() {
        return this.abortable;
    }

    public synchronized double getCurrentProgress() {
        return this.currentProgress;
    }

    public synchronized double getTotalProgress() {
        return this.totalProgress;
    }

    public synchronized String getWaitingOn() {
        return this.waitingOn;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }
}

