/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Graphics;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinFileChooserUI
extends MetalFileChooserUI
implements NapkinPainter {
    private final NapkinFileView fileView = new NapkinFileView();

    public static ComponentUI createUI(JComponent c) {
        return new NapkinFileChooserUI((JFileChooser)c);
    }

    private NapkinFileChooserUI(JFileChooser c) {
        super(c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
    }

    public void update(Graphics g, JComponent c) {
        NapkinUtil.update(g, c, this);
    }

    public void superPaint(Graphics g, JComponent c, NapkinTheme theme) {
        super.update(g, c);
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    private class NapkinFileView
    extends BasicFileChooserUI.BasicFileView {
        private final Map<String, Icon> pathIconCache;

        private NapkinFileView() {
            super(NapkinFileChooserUI.this);
            this.pathIconCache = new HashMap<String, Icon>();
        }

        public Icon getCachedIcon(File f) {
            return this.pathIconCache.get(f.getPath());
        }

        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            icon = this.getDefaultIcon(f);
            this.cacheIcon(f, icon);
            return icon;
        }

        public void cacheIcon(File f, Icon icon) {
            this.pathIconCache.put(f.getPath(), icon);
        }

        public void clearIconCache() {
            this.pathIconCache.clear();
        }

        public Icon getDefaultIcon(File f) {
            Icon icon;
            FileSystemView fsv = NapkinFileChooserUI.this.getFileChooser().getFileSystemView();
            if (fsv.isFloppyDrive(f)) {
                icon = UIManager.getIcon("FileView.floppyDriveIcon");
            } else if (fsv.isDrive(f)) {
                icon = UIManager.getIcon("FileView.hardDriveIcon");
            } else if (fsv.isComputerNode(f)) {
                icon = UIManager.getIcon("FileView.computerIcon");
            } else if (f.isDirectory()) {
                icon = UIManager.getIcon("FileView.directoryIcon");
            } else {
                icon = fsv.getSystemIcon(f);
                if (icon == null) {
                    icon = UIManager.getIcon("FileView.fileIcon");
                }
            }
            return icon;
        }
    }
}

