/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.borders.NapkinBoxBorder;
import net.sourceforge.napkinlaf.borders.NapkinLineBorder;
import net.sourceforge.napkinlaf.borders.NapkinSelectedBorder;
import net.sourceforge.napkinlaf.util.AlphaColorUIResource;
import net.sourceforge.napkinlaf.util.ComponentWalker;
import net.sourceforge.napkinlaf.util.NapkinConstants;
import net.sourceforge.napkinlaf.util.NapkinDebug;
import net.sourceforge.napkinlaf.util.NapkinIconFactory;
import net.sourceforge.napkinlaf.util.NapkinUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NapkinLookAndFeel
extends BasicLookAndFeel {
    private static final String[] UI_TYPES = new String[]{"ButtonUI", "CheckBoxMenuItemUI", "CheckBoxUI", "ColorChooserUI", "ComboBoxUI", "DesktopIconUI", "DesktopPaneUI", "EditorPaneUI", "FileChooserUI", "FormattedTextFieldUI", "InternalFrameUI", "LabelUI", "ListUI", "MenuBarUI", "MenuItemUI", "MenuUI", "OptionPaneUI", "PanelUI", "PasswordFieldUI", "PopupMenuSeparatorUI", "PopupMenuUI", "ProgressBarUI", "RadioButtonMenuItemUI", "RadioButtonUI", "RootPaneUI", "ScrollBarUI", "ScrollPaneUI", "SeparatorUI", "SliderUI", "SpinnerUI", "SplitPaneUI", "TabbedPaneUI", "TableHeaderUI", "TableUI", "TextAreaUI", "TextFieldUI", "TextPaneUI", "ToggleButtonUI", "ToolBarSeparatorUI", "ToolBarUI", "ToolTipUI", "TreeUI", "ViewportUI"};

    public NapkinLookAndFeel() {
        new JLabel();
    }

    @Override
    public String getDescription() {
        return "The Napkin Look and Feel";
    }

    @Override
    public String getID() {
        return "Napkin";
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String cName = NapkinLookAndFeel.class.getName();
        String basicPackageName = cName.replace("NapkinLookAndFeel", "Napkin");
        String[] stringArray = UI_TYPES;
        int n = UI_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String uiType = stringArray[n2];
            String uiClass = String.valueOf(basicPackageName) + uiType;
            table.put(uiType, uiClass);
            ++n2;
        }
        HashSet keys = new HashSet(table.keySet());
        keys.removeAll(Arrays.asList(UI_TYPES));
        if (keys.size() != 0) {
            System.out.println("keys we didn't overwrite: " + keys);
        }
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        table.put("textHighlight", theme.getHighlightColor());
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        NapkinLookAndFeel.overrideComponentDefaults(table);
        UIDefaults.ActiveValue checkBoxButtonIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createCheckBoxIcon();
            }
        };
        UIDefaults.ActiveValue checkedMenuItemIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createCheckedMenuItemIcon();
            }
        };
        UIDefaults.ActiveValue radioButtonIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createRadioButtonIcon();
            }
        };
        UIDefaults.ActiveValue underlineBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinLineBorder(false);
            }
        };
        UIDefaults.ActiveValue selectBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinSelectedBorder();
            }
        };
        UIDefaults.ActiveValue downArrowIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(5, 8);
            }
        };
        UIDefaults.ActiveValue rightArrowIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(3, 8);
            }
        };
        UIDefaults.ActiveValue closeIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createXIcon(15);
            }
        };
        UIDefaults.ActiveValue minIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(1, 10);
            }
        };
        UIDefaults.ActiveValue iconIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(5, 10);
            }
        };
        NapkinLookAndFeel.setupActions(table);
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        NapkinTheme popupTheme = theme.getPopupTheme();
        Object[] objectArray = new Object[144];
        objectArray[0] = "RadioButton.textIconGap";
        objectArray[1] = 0;
        objectArray[2] = "RadioButton.icon";
        objectArray[3] = radioButtonIcon;
        objectArray[4] = "RadioButtonMenuItem.textIconGap";
        objectArray[5] = 0;
        objectArray[6] = "RadioButtonMenuItem.checkIcon";
        objectArray[7] = radioButtonIcon;
        objectArray[8] = "CheckBox.textIconGap";
        objectArray[9] = 0;
        objectArray[10] = "CheckBox.icon";
        objectArray[11] = checkBoxButtonIcon;
        objectArray[12] = "CheckBoxMenuItem.textIconGap";
        objectArray[13] = 0;
        objectArray[14] = "CheckBoxMenuItem.checkIcon";
        objectArray[15] = checkedMenuItemIcon;
        objectArray[16] = "Menu.arrowIcon";
        objectArray[17] = rightArrowIcon;
        objectArray[18] = "OptionPane.messageAreaBorder";
        objectArray[20] = "TabbedPane.contentBorderInsets";
        objectArray[21] = NapkinBoxBorder.LARGE_DEFAULT_INSETS;
        objectArray[22] = "Tree.openIcon";
        objectArray[23] = downArrowIcon;
        objectArray[24] = "Tree.closedIcon";
        objectArray[25] = rightArrowIcon;
        objectArray[26] = "Tree.hash";
        objectArray[27] = theme.getPenColor();
        objectArray[28] = "Tree.collapsedIcon";
        objectArray[30] = "Tree.expandedIcon";
        objectArray[32] = "Tree.leafIcon";
        objectArray[34] = "Tree.selectionBorderColor";
        objectArray[36] = "TextField.caretForeground";
        objectArray[37] = theme.getPenColor();
        objectArray[38] = "TextArea.caretForeground";
        objectArray[39] = theme.getPenColor();
        objectArray[40] = "TextField.border";
        objectArray[41] = underlineBorder;
        objectArray[42] = "PasswordField.border";
        objectArray[43] = underlineBorder;
        objectArray[44] = "Menu.border";
        objectArray[46] = "MenuBar.border";
        objectArray[48] = "PopupMenu.border";
        objectArray[50] = "ToolTip.border";
        objectArray[52] = "DesktopIcon.border";
        objectArray[54] = "ToggleButton.border";
        objectArray[55] = selectBorder;
        objectArray[56] = "InternalFrame.border";
        objectArray[57] = new BorderUIResource(new EmptyBorder(3, 3, 3, 3));
        objectArray[58] = "PopupMenu.foreground";
        objectArray[59] = popupTheme.getPenColor();
        objectArray[60] = "ToolTip.foreground";
        objectArray[61] = popupTheme.getPenColor();
        objectArray[62] = "CheckBoxMenuItem.foreground";
        objectArray[63] = popupTheme.getPenColor();
        objectArray[64] = "CheckBoxMenuItem.selectionForeground";
        objectArray[65] = popupTheme.getSelectionColor();
        objectArray[66] = "RadioButtonMenuItem.foreground";
        objectArray[67] = popupTheme.getPenColor();
        objectArray[68] = "RadioButtonMenuItem.selectionForeground";
        objectArray[69] = popupTheme.getSelectionColor();
        objectArray[70] = "MenuItem.foreground";
        objectArray[71] = popupTheme.getPenColor();
        objectArray[72] = "MenuItem.selectionForeground";
        objectArray[73] = popupTheme.getSelectionColor();
        objectArray[74] = "InternalFrame.maximizeIcon";
        objectArray[76] = "InternalFrame.minimizeIcon";
        objectArray[77] = minIcon;
        objectArray[78] = "InternalFrame.iconifyIcon";
        objectArray[79] = iconIcon;
        objectArray[80] = "InternalFrame.closeIcon";
        objectArray[81] = closeIcon;
        objectArray[82] = "InternalFrame.closeButtonToolTip";
        objectArray[83] = "Close";
        objectArray[84] = "InternalFrame.iconButtonToolTip";
        objectArray[85] = "Minimise";
        objectArray[86] = "InternalFrame.restoreButtonToolTip";
        objectArray[87] = "Restore";
        objectArray[88] = "InternalFrame.maxButtonToolTip";
        objectArray[89] = "Maximise";
        objectArray[90] = "InternalFrame.activeTitleForeground";
        objectArray[91] = popupTheme.getSelectionColor();
        objectArray[92] = "InternalFrame.inactiveTitleForeground";
        objectArray[93] = popupTheme.getPenColor();
        objectArray[94] = "SplitPaneDivider.border";
        objectArray[96] = "SplitPane.dividerSize";
        objectArray[97] = 9;
        objectArray[98] = "FileChooser.upFolderIcon";
        objectArray[99] = NapkinLookAndFeel.sketchedIcon("UpFolder");
        objectArray[100] = "FileChooser.detailsViewIcon";
        objectArray[101] = NapkinLookAndFeel.sketchedIcon("DetailsView");
        objectArray[102] = "FileChooser.listViewIcon";
        objectArray[103] = NapkinLookAndFeel.sketchedIcon("ListView");
        objectArray[104] = "FileChooser.newFolderIcon";
        objectArray[105] = NapkinLookAndFeel.sketchedIcon("NewFolder");
        objectArray[106] = "FileChooser.homeFolderIcon";
        objectArray[107] = NapkinLookAndFeel.sketchedIcon("HomeFolder");
        objectArray[108] = "FileChooser.lookInLabelText";
        objectArray[109] = "Look in:";
        objectArray[110] = "FileChooser.saveInLabelText";
        objectArray[111] = "Save in:";
        objectArray[112] = "FileChooser.fileNameLabelText";
        objectArray[113] = "File Name(s):";
        objectArray[114] = "FileChooser.filesOfTypeLabelText";
        objectArray[115] = "Of Type(s):";
        objectArray[116] = "FileChooser.upFolderToolTipText";
        objectArray[117] = "Up One Level";
        objectArray[118] = "FileChooser.homeFolderToolTipText";
        objectArray[119] = "Home Folder";
        objectArray[120] = "FileChooser.newFolderToolTipText";
        objectArray[121] = "New Folder";
        objectArray[122] = "FileChooser.listViewButtonToolTipText";
        objectArray[123] = "List View";
        objectArray[124] = "FileChooser.detailsViewButtonToolTipText";
        objectArray[125] = "Details View";
        objectArray[126] = "FileView.directoryIcon";
        objectArray[127] = NapkinLookAndFeel.sketchedIcon("Directory");
        objectArray[128] = "FileView.fileIcon";
        objectArray[129] = NapkinLookAndFeel.sketchedIcon("File");
        objectArray[130] = "FileView.computerIcon";
        objectArray[131] = NapkinLookAndFeel.sketchedIcon("Computer");
        objectArray[132] = "FileView.hardDriveIcon";
        objectArray[133] = NapkinLookAndFeel.sketchedIcon("HardDrive");
        objectArray[134] = "FileView.floppyDriveIcon";
        objectArray[135] = NapkinLookAndFeel.sketchedIcon("FloppyDrive");
        objectArray[136] = "OptionPane.errorIcon";
        objectArray[137] = NapkinLookAndFeel.sketchedIcon("Error");
        objectArray[138] = "OptionPane.informationIcon";
        objectArray[139] = NapkinLookAndFeel.sketchedIcon("Information");
        objectArray[140] = "OptionPane.warningIcon";
        objectArray[141] = NapkinLookAndFeel.sketchedIcon("Warning");
        objectArray[142] = "OptionPane.questionIcon";
        objectArray[143] = NapkinLookAndFeel.sketchedIcon("Question");
        Object[] napkinDefaults = objectArray;
        table.putDefaults(napkinDefaults);
    }

    private static Object sketchedIcon(final String templateName) {
        return new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createSketchedIcon(templateName);
            }
        };
    }

    private static void setupActions(UIDefaults table) {
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        Object[] actionDefaults = new Object[]{"TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", fieldInputMap, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap};
        table.putDefaults(actionDefaults);
    }

    private static void overrideComponentDefaults(UIDefaults table) {
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        Map<String, Font> fontMap = NapkinLookAndFeel.fontNameMap(theme);
        UIDefaults.ActiveValue drawnBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinBoxBorder();
            }
        };
        UIDefaults.ActiveValue compoundBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                NapkinBoxBorder outside = new NapkinBoxBorder();
                BasicBorders.MarginBorder inside = new BasicBorders.MarginBorder();
                return new CompoundBorder(outside, inside);
            }
        };
        AlphaColorUIResource clear = new AlphaColorUIResource(NapkinConstants.CLEAR);
        for (Map.Entry entry : table.entrySet()) {
            Object val;
            String key = (String)entry.getKey();
            Object res = NapkinLookAndFeel.propVal(key, "font", val = entry.getValue(), table);
            if (res != null) {
                if (!(res instanceof FontUIResource)) continue;
                FontUIResource resource = (FontUIResource)res;
                String name = resource.getFontName();
                Font font = fontMap.get(name);
                if (font != null) {
                    entry.setValue(font);
                    continue;
                }
                System.err.println("unknown font: " + name + " for " + key);
                continue;
            }
            res = NapkinLookAndFeel.propVal(key, "border", val, table);
            if (res != null) {
                if (!(res instanceof UIResource) && (!(val instanceof UIResource) || !(res instanceof BevelBorder) && !(res instanceof EtchedBorder) && !(res instanceof LineBorder) && !(res instanceof CompoundBorder))) continue;
                if (!(res instanceof CompoundBorder)) {
                    entry.setValue(drawnBorder);
                    continue;
                }
                entry.setValue(compoundBorder);
                continue;
            }
            if (key.contains("Text") || key.startsWith("Password") || key.startsWith("Editor")) continue;
            if (key.endsWith(".foreground") || key.endsWith("BorderColor") || key.endsWith(".caretForeground") || key.endsWith(".acceleratorForeground") || key.endsWith(".disabledForeground") || key.endsWith(".inactiveForeground") || key.endsWith(".inactiveTitleForeground") || key.endsWith(".textForeground")) {
                entry.setValue(theme.getPenColor());
                continue;
            }
            if (key.endsWith(".background") || key.endsWith(".selectionBackground") || key.endsWith(".textBackground")) {
                entry.setValue(clear);
                continue;
            }
            if (!key.endsWith(".selectionForeground") && !key.endsWith(".activeTitleForeground") && !key.endsWith("SelectionForeground")) continue;
            entry.setValue(theme.getSelectionColor());
        }
    }

    private static Map<String, Font> fontNameMap(NapkinTheme theme) {
        Font dialogPlain = theme.getTextFont();
        Font dialogBold = theme.getBoldTextFont();
        Font serifPlain = theme.getTextFont();
        Font sansSerifPlain = theme.getTextFont();
        Font monospacedPlain = theme.getFixedFont();
        HashMap<String, Font> fromName = new HashMap<String, Font>();
        fromName.put("dialogBold", dialogBold);
        fromName.put("dialogPlain", dialogPlain);
        fromName.put("monospacedPlain", monospacedPlain);
        fromName.put("sansSerifPlain", sansSerifPlain);
        fromName.put("serifPlain", serifPlain);
        fromName.put("Dialog.plain", dialogPlain);
        fromName.put("Dialog", dialogPlain);
        fromName.put("Dialog.bold", dialogBold);
        fromName.put("Serif.plain", serifPlain);
        fromName.put("Serif", serifPlain);
        fromName.put("SansSerif.plain", sansSerifPlain);
        fromName.put("SansSerif", sansSerifPlain);
        fromName.put("MonoSpaced.plain", monospacedPlain);
        fromName.put("MonoSpaced", monospacedPlain);
        fromName.put("Monospaced.plain", monospacedPlain);
        fromName.put("Monospaced", monospacedPlain);
        InputStream fonts = NapkinLookAndFeel.class.getResourceAsStream("resources/fonts.properties");
        if (fonts != null) {
            try {
                try {
                    Properties props = new Properties();
                    props.load(fonts);
                    fonts.close();
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String fontName = (String)entry.getKey();
                        Font font = (Font)fromName.get(entry.getValue());
                        if (font == null) {
                            System.err.println("unknown font: " + fontName);
                            continue;
                        }
                        fromName.put(fontName, font);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    NapkinUtil.tryClose(fonts);
                }
            }
            finally {
                NapkinUtil.tryClose(fonts);
            }
        }
        return fromName;
    }

    private static Object propVal(String key, String prop, Object val, UIDefaults table) {
        int propLen;
        int keyLen = key.length();
        int prePos = keyLen - (propLen = prop.length()) - 1;
        if (prePos <= 0) {
            return null;
        }
        boolean match = false;
        if (key.endsWith(prop) && key.charAt(prePos) == '.') {
            match = true;
        } else if (key.endsWith(prop.substring(1)) && key.charAt(prePos + 1) == Character.toUpperCase(prop.charAt(0))) {
            match = true;
        }
        if (!match) {
            return null;
        }
        return NapkinLookAndFeel.extractVal(val, table);
    }

    private static Object extractVal(Object val, UIDefaults table) {
        if (val instanceof UIDefaults.LazyValue) {
            val = ((UIDefaults.LazyValue)val).createValue(table);
        } else if (val instanceof UIDefaults.ActiveValue) {
            val = ((UIDefaults.ActiveValue)val).createValue(table);
        }
        return val;
    }

    public static void main(String[] args) {
    }

    static class DumpVisitor
    implements ComponentWalker.Visitor {
        private final PrintStream out;

        DumpVisitor(PrintStream out) {
            this.out = out;
        }

        public boolean visit(Component c, int depth) {
            int i = 0;
            while (i < depth) {
                this.out.print(i % 2 == 0 ? (char)'|' : '.');
                this.out.print(' ');
                ++i;
            }
            String desc = NapkinDebug.descFor(c);
            this.out.print(desc);
            this.out.print(": ");
            this.out.print(c.isOpaque());
            this.out.println();
            return true;
        }
    }
}

