/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import net.sourceforge.napkinlaf.NapkinKnownTheme;
import net.sourceforge.napkinlaf.NapkinLookAndFeel;
import net.sourceforge.napkinlaf.NapkinThemeColor;
import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.sketchers.DraftSketcher;
import net.sourceforge.napkinlaf.sketch.sketchers.JotSketcher;
import net.sourceforge.napkinlaf.util.AlphaColorUIResource;
import net.sourceforge.napkinlaf.util.NapkinBackground;
import net.sourceforge.napkinlaf.util.NapkinFont;

public class NapkinTheme {
    private final String name;
    private final String description;
    private final Map<NapkinThemeColor, Color> colors = new EnumMap<NapkinThemeColor, Color>(NapkinThemeColor.class);
    private final Font textFont;
    private final Font boldTextFont;
    private final Font fixedFont;
    private final AbstractSketcher sketcher;
    private final NapkinBackground paper;
    private final NapkinBackground erasure;
    private Map<NapkinKnownTheme, NapkinTheme> variants = new EnumMap<NapkinKnownTheme, NapkinTheme>(NapkinKnownTheme.class);

    public NapkinTheme(String name, String description, Color penColor, Color checkColor, Color radioColor, Color highlightColor, Color selectionColor, Font textFont, Font boldTextFont, Font fixedFont, AbstractSketcher sketcher, NapkinBackground paper, NapkinBackground erasure, NapkinBackground popupPaper) {
        this(name, description, penColor, checkColor, radioColor, highlightColor, selectionColor, textFont, boldTextFont, fixedFont, sketcher, paper, erasure, new NapkinTheme(String.valueOf(name) + "Popup", String.valueOf(description) + " (popup)", penColor, checkColor, radioColor, highlightColor, selectionColor, textFont, boldTextFont, fixedFont, sketcher, popupPaper, erasure, null));
    }

    public NapkinTheme(String name, String description, Color penColor, Color checkColor, Color radioColor, Color highlightColor, Color selectionColor, Font textFont, Font boldTextFont, Font fixedFont, AbstractSketcher sketcher, NapkinBackground paper, NapkinBackground erasure, NapkinTheme popupTheme) {
        this.name = name;
        this.description = description;
        this.colors.put(NapkinThemeColor.PEN_COLOR, NapkinTheme.uiResource(penColor));
        this.colors.put(NapkinThemeColor.CHECK_COLOR, NapkinTheme.uiResource(checkColor));
        this.colors.put(NapkinThemeColor.RADIO_COLOR, NapkinTheme.uiResource(radioColor));
        this.colors.put(NapkinThemeColor.HIGHLIGHT_COLOR, NapkinTheme.uiResource(highlightColor));
        this.colors.put(NapkinThemeColor.SELECTION_COLOR, NapkinTheme.uiResource(selectionColor));
        this.colors.put(NapkinThemeColor.BACKGROUND_COLOR, NapkinTheme.uiResource(paper.getMeanColor()));
        this.textFont = NapkinTheme.uiResource(textFont);
        this.boldTextFont = NapkinTheme.uiResource(boldTextFont);
        this.fixedFont = NapkinTheme.uiResource(fixedFont);
        this.sketcher = sketcher;
        this.paper = paper;
        this.erasure = erasure;
        this.variants.put(NapkinKnownTheme.BASIC_THEME, this);
        this.variants.put(NapkinKnownTheme.POPUP_THEME, popupTheme);
        if (popupTheme != null) {
            popupTheme.variants = this.variants;
        }
    }

    private static Color uiResource(Color color) {
        if (color instanceof UIResource) {
            return color;
        }
        return new AlphaColorUIResource(color);
    }

    private static Font uiResource(Font font) {
        if (font instanceof UIResource) {
            return font;
        }
        Font result = new FontUIResource(font);
        if (!result.getFontName().equals(font.getFontName())) {
            result = new NapkinFont(font);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Color getPenColor() {
        return this.colors.get((Object)NapkinThemeColor.PEN_COLOR);
    }

    public Color getCheckColor() {
        return this.colors.get((Object)NapkinThemeColor.CHECK_COLOR);
    }

    public Color getRadioColor() {
        return this.colors.get((Object)NapkinThemeColor.RADIO_COLOR);
    }

    public Color getHighlightColor() {
        return this.colors.get((Object)NapkinThemeColor.HIGHLIGHT_COLOR);
    }

    public Color getSelectionColor() {
        return this.colors.get((Object)NapkinThemeColor.SELECTION_COLOR);
    }

    public Color getBackgroundColor() {
        return this.colors.get((Object)NapkinThemeColor.BACKGROUND_COLOR);
    }

    public Color getColor(NapkinThemeColor which) {
        return this.colors.get((Object)which);
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public Font getBoldTextFont() {
        return this.boldTextFont;
    }

    public Font getFixedFont() {
        return this.fixedFont;
    }

    public AbstractSketcher getSketcher() {
        return this.sketcher;
    }

    public NapkinBackground getPaper() {
        return this.paper;
    }

    public NapkinBackground getErasureMask() {
        return this.erasure;
    }

    public NapkinTheme getPopupTheme() {
        return this.getTheme(NapkinKnownTheme.POPUP_THEME);
    }

    public NapkinTheme getBasicTheme() {
        return this.getTheme(NapkinKnownTheme.BASIC_THEME);
    }

    public NapkinTheme getTheme(NapkinKnownTheme which) {
        return this.variants.get((Object)which);
    }

    public String toString() {
        return this.name;
    }

    public static class Manager {
        private static final Map<String, NapkinTheme> themes = new HashMap<String, NapkinTheme>();
        private static NapkinTheme currentTheme;
        private static final String DEFAULT_THEME = "napkin";
        private static final Class<NapkinLookAndFeel> THIS_CLASS;
        private static final Logger LOG;

        static {
            THIS_CLASS = NapkinLookAndFeel.class;
            LOG = LogManager.getLogManager().getLogger(THIS_CLASS.getName());
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Manager.setup();
                    return null;
                }
            });
        }

        private static void setup() {
            String themeName;
            Color checkGreen = Color.GREEN.darker();
            Font scrawl = Manager.tryToLoadFont("FeltTipRoman.ttf");
            Font scrawlBold = Manager.tryToLoadFont("FeltTipRoman-Bold.ttf");
            Font fixed = Manager.tryToLoadFont("1942.ttf");
            Font augie = Manager.tryToLoadFont("augie.ttf");
            NapkinTheme def = new NapkinTheme(DEFAULT_THEME, "Default theme", Color.BLACK, checkGreen, new Color(0xF50000), new Color(0, 255, 255, 128), checkGreen, scrawl.deriveFont(0, 15.0f), scrawlBold.deriveFont(1, 15.0f), fixed.deriveFont(0, 15.0f), (AbstractSketcher)new JotSketcher(), new NapkinBackground("/net/sourceforge/napkinlaf/resources/napkin.jpg"), new NapkinBackground("/net/sourceforge/napkinlaf/resources/erasure.png"), new NapkinBackground("/net/sourceforge/napkinlaf/resources/postit.jpg", 80, 80, 50, 40));
            Manager.addTheme(def);
            Manager.addTheme(new NapkinTheme("debug", "Debug theme", def.getPenColor(), def.getCheckColor(), def.getRadioColor(), def.getHighlightColor(), def.getSelectionColor(), def.getTextFont(), def.getBoldTextFont(), def.getFixedFont(), (AbstractSketcher)new JotSketcher(), new NapkinBackground("/net/sourceforge/napkinlaf/resources/testPaper.jpg", 0, 0, 10, 10), def.getErasureMask(), new NapkinBackground("/net/sourceforge/napkinlaf/resources/testPostit.jpg", 0, 0, 10, 10)));
            Color blueprintInk = new Color(15199730);
            Color blueprintHighlight = new Color(9025005);
            Font blueFont = augie.deriveFont(0, 13.0f);
            Manager.addTheme(new NapkinTheme("blueprint", "Blueprint", Color.white, blueprintInk, blueprintInk, blueprintHighlight, blueprintInk, blueFont, blueFont, def.getFixedFont(), (AbstractSketcher)new DraftSketcher(), new NapkinBackground("/net/sourceforge/napkinlaf/resources/blueprint-bg.jpg"), def.getErasureMask(), def.getPopupTheme()));
            try {
                themeName = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("net.sourceforge.napkinlaf.theme", Manager.DEFAULT_THEME);
                    }
                });
            }
            catch (SecurityException e) {
                e.printStackTrace();
                themeName = null;
            }
            if (themeName == null) {
                themeName = DEFAULT_THEME;
            }
            if ((currentTheme = Manager.getTheme(themeName)) == null) {
                currentTheme = Manager.getTheme(DEFAULT_THEME);
            }
        }

        public static String[] themeNames() {
            return themes.keySet().toArray(new String[themes.size()]);
        }

        public static NapkinTheme getTheme(String name) {
            return themes.get(name);
        }

        public static NapkinTheme getDefaultTheme() {
            return Manager.getTheme(DEFAULT_THEME);
        }

        public static NapkinTheme getCurrentTheme() {
            return currentTheme;
        }

        public static void setCurrentTheme(NapkinTheme theme) {
            currentTheme = theme != null ? theme : Manager.getDefaultTheme();
        }

        public static void setCurrentTheme(String themeName) {
            NapkinTheme theme = Manager.getTheme(themeName);
            if (theme == null) {
                throw new IllegalArgumentException("unknown theme");
            }
            Manager.setCurrentTheme(theme);
        }

        public static void addTheme(NapkinTheme theme) {
            themes.put(theme.getName(), theme);
        }

        private static Font tryToLoadFont(String fontName) {
            try {
                String fontRes = "/net/sourceforge/napkinlaf/resources/" + fontName;
                InputStream fontDef = NapkinLookAndFeel.class.getResourceAsStream(fontRes);
                if (fontDef == null) {
                    throw new NullPointerException("Could not find font resource \"" + fontName + "\"\n\t\tin \"" + fontRes + "\"\n\t\tfor \"" + NapkinLookAndFeel.class.getName() + "\"\n\t\ttry: " + NapkinLookAndFeel.class.getResource(fontRes));
                }
                Font font = Font.createFont(0, fontDef);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                try {
                    Method rf = ge.getClass().getMethod("registerFont", Font.class);
                    rf.invoke((Object)ge, font);
                }
                catch (NoSuchMethodException rf) {
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                return font;
            }
            catch (FontFormatException e) {
                LOG.log(Level.WARNING, "getting font " + fontName, e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "getting font " + fontName, e);
            }
            return null;
        }
    }
}

