/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.dev;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.napkinlaf.dev.GeneratorTest;
import net.sourceforge.napkinlaf.dev.RandomValueSpinner;
import net.sourceforge.napkinlaf.dev.SpringUtilities;
import net.sourceforge.napkinlaf.shapes.DrawnBoxGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnCubicLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnQuadLineGenerator;
import net.sourceforge.napkinlaf.util.RandomValueSource;

class BoxTest
extends GeneratorTest
implements GeneratorTest.Drawer {
    private final DrawnBoxGenerator gen;
    private final RandomValueSpinner begXSpin;
    private final RandomValueSpinner endYSpin;
    private final RandomValueSpinner startAdjustSpin;
    private final RandomValueSpinner sizeXSpin;
    private final RandomValueSpinner sizeYSpin;
    private final RandomValueSource[] spinners;
    private final Side[] sides;
    private JComponent drawing;
    private static final String[] TYPE_NAMES = new String[]{"cubic", "quad", "straight"};
    private static final Class[] TYPES;
    private static final String[] SIDE_NAMES;

    static {
        Class[] classArray = new Class[3];
        classArray[0] = DrawnCubicLineGenerator.class;
        classArray[1] = DrawnQuadLineGenerator.class;
        TYPES = classArray;
        String[] stringArray = new String[5];
        stringArray[1] = "top";
        stringArray[2] = "left";
        stringArray[3] = "bottom";
        stringArray[4] = "right";
        SIDE_NAMES = stringArray;
    }

    BoxTest(DrawnCubicLineGenerator cubic, DrawnQuadLineGenerator quad) {
        this.gen = new DrawnBoxGenerator(cubic, quad);
        this.begXSpin = new RandomValueSpinner("x", this.gen.getCorner().getX(), -5.0, 5.0, 100);
        this.endYSpin = new RandomValueSpinner("y", this.gen.getCorner().getY(), -5.0, 5.0, 100);
        this.startAdjustSpin = new RandomValueSpinner("adj", this.gen.getStartAdjust(), 0.0, 10.0, 100, false);
        this.sizeXSpin = new RandomValueSpinner("width", this.gen.getSize().getX(), 0.0, 100.0, 100, false);
        this.sizeYSpin = new RandomValueSpinner("height", this.gen.getSize().getY(), 0.0, 100.0, 100, false);
        this.spinners = new RandomValueSource[]{this.begXSpin, this.endYSpin, this.widthSpin};
        this.sides = new Side[4];
        int i = 0;
        while (i < this.sides.length) {
            this.sides[i] = new Side(SIDE_NAMES[i], i);
            this.gen.setGenerator(i, DrawnCubicLineGenerator.class);
            ++i;
        }
        this.rebuild();
    }

    public void generate(AffineTransform matrix) {
        this.gen.generate(matrix);
    }

    public void rebuild() {
        this.generate(null);
    }

    public RandomValueSource[] getSpinners() {
        return this.spinners;
    }

    public String getName() {
        return "Box";
    }

    public JComponent getDrawing() {
        if (this.drawing == null) {
            this.drawing = new Drawing();
        }
        return this.drawing;
    }

    public JComponent getControls() {
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.setAlignmentY(1.0f);
        controls.add(BoxTest.controlSet("Corner", this.begXSpin, this.endYSpin, this.startAdjustSpin));
        controls.add(BoxTest.controlSet("Size", this.sizeXSpin, this.sizeYSpin));
        controls.add(BoxTest.controlSet("Line", this.widthSpin));
        JPanel typeControl = new JPanel();
        typeControl.setBorder(new TitledBorder("Side types"));
        typeControl.setLayout(new SpringLayout());
        Side[] sideArray = this.sides;
        int n = this.sides.length;
        int n2 = 0;
        while (n2 < n) {
            Side side = sideArray[n2];
            typeControl.add(side.show);
            typeControl.add(side.selector);
            ++n2;
        }
        SpringUtilities.makeCompactGrid(typeControl, 2, 4, 0, 0, 0, 0);
        controls.add(typeControl);
        controls.add(Box.createVerticalGlue());
        return controls;
    }

    static /* synthetic */ String[] access$0() {
        return TYPE_NAMES;
    }

    private class Drawing
    extends JLabel {
        Drawing() {
            int space = 50;
            this.setBorder(new EmptyBorder(space, space, space, space));
        }

        protected void paintComponent(Graphics g1) {
            Graphics2D g = (Graphics2D)g1;
            double mid = (double)this.getHeight() / 2.0 - BoxTest.this.sizeYSpin.get() / 2.0;
            g.translate(50.0, mid);
            Graphics2D lineG = BoxTest.lineGraphics(g, (float)BoxTest.this.widthSpin.get());
            Graphics2D markG = BoxTest.markGraphics(g);
            BoxTest.mark(markG, ZERO, ZERO, BoxTest.this.sizeXSpin, BoxTest.this.sizeYSpin);
            int i = 0;
            while (i < 4) {
                this.showSide(lineG, BoxTest.this.sides[i], BoxTest.this.gen.getSide(i));
                ++i;
            }
            BoxTest.mark(markG, BoxTest.this.begXSpin, ZERO, true);
            BoxTest.mark(markG, ZERO, BoxTest.this.endYSpin, true);
        }

        private void showSide(Graphics2D lineG, Side side, Shape shape) {
            if (side.show.isSelected()) {
                lineG.draw(shape);
            }
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            return new Dimension(200, 500);
        }
    }

    private class Side {
        private final JComboBox selector = new JComboBox<String>(BoxTest.access$0());
        private final JCheckBox show;

        Side(String name, final int which) {
            this.selector.addActionListener(REPAINT_ACTION);
            this.selector.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BoxTest.this.gen.setGenerator(which, TYPES[Side.this.selector.getSelectedIndex()]);
                }
            });
            this.show = new JCheckBox(name, true);
            this.show.addActionListener(REPAINT_ACTION);
        }
    }
}

