/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.dev;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.napkinlaf.dev.GeneratorTest;
import net.sourceforge.napkinlaf.dev.RandomValueSpinner;
import net.sourceforge.napkinlaf.shapes.DrawnBoxGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnCheckGenerator;
import net.sourceforge.napkinlaf.util.RandomValueSource;

class CheckBoxTest
extends GeneratorTest
implements GeneratorTest.Drawer {
    private final DrawnCheckGenerator checkGen;
    private final DrawnBoxGenerator boxGen;
    private final RandomValueSpinner midXScaleSpin;
    private final RandomValueSpinner midYScaleSpin;
    private final RandomValueSpinner leftXScaleSpin;
    private final RandomValueSpinner leftYScaleSpin;
    private final RandomValueSpinner rightXScaleSpin;
    private final RandomValueSpinner rightYScaleSpin;
    private final JCheckBox isSelected;
    private final JCheckBox useBox;
    private final RandomValueSource[] spinners;
    private JComponent drawing;
    private Shape box;
    private Shape check;
    private static final DrawnBoxGenerator DEFAULT_BOX = new DrawnBoxGenerator();

    static {
        DEFAULT_BOX.getSize().setMid(10.0, 10.0);
    }

    CheckBoxTest() {
        this(DEFAULT_BOX);
    }

    CheckBoxTest(DrawnBoxGenerator boxGen) {
        this.boxGen = boxGen;
        this.checkGen = new DrawnCheckGenerator();
        this.isSelected = new JCheckBox("Selected", true);
        this.isSelected.addChangeListener(REPAINT);
        this.useBox = new JCheckBox("Use Box", true);
        this.useBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
            }
        });
        this.useBox.addChangeListener(REPAINT);
        this.midXScaleSpin = new RandomValueSpinner("mid x", this.checkGen.getMidScale().getX(), 0.0, 2.0, 100);
        this.midYScaleSpin = new RandomValueSpinner("mid y", this.checkGen.getMidScale().getY(), 0.0, 2.0, 100);
        this.leftXScaleSpin = new RandomValueSpinner("left x", this.checkGen.getLeftScale().getX(), 0.0, 2.0, 100);
        this.leftYScaleSpin = new RandomValueSpinner("left y", this.checkGen.getLeftScale().getY(), 0.0, 2.0, 100);
        this.rightXScaleSpin = new RandomValueSpinner("right x", this.checkGen.getRightScale().getX(), 0.0, 2.0, 100);
        this.rightYScaleSpin = new RandomValueSpinner("right y", this.checkGen.getRightScale().getY(), 0.0, 2.0, 100);
        this.spinners = new RandomValueSource[]{this.midXScaleSpin, this.midYScaleSpin, this.leftXScaleSpin, this.leftYScaleSpin, this.rightXScaleSpin, this.rightYScaleSpin, this.widthSpin};
        this.rebuild();
    }

    public RandomValueSource[] getSpinners() {
        return this.spinners;
    }

    public String getName() {
        return "CheckBox";
    }

    public JComponent getDrawing() {
        if (this.drawing == null) {
            this.drawing = new Drawing();
        }
        return this.drawing;
    }

    public void rebuild() {
        this.box = this.boxGen.generate(null);
        this.check = this.checkGen.generate(null);
    }

    public JComponent getControls() {
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.setAlignmentY(1.0f);
        controls.add(this.isSelected);
        controls.add(this.useBox);
        controls.add(CheckBoxTest.controlSet("left", this.leftXScaleSpin, this.leftYScaleSpin));
        controls.add(CheckBoxTest.controlSet("mid", this.midXScaleSpin, this.midYScaleSpin));
        controls.add(CheckBoxTest.controlSet("right", this.rightXScaleSpin, this.rightYScaleSpin));
        controls.add(CheckBoxTest.controlSet("Line", this.widthSpin));
        JPanel lineControl = new JPanel();
        lineControl.setBorder(new TitledBorder("Line"));
        lineControl.setLayout(new BoxLayout(lineControl, 0));
        controls.add(Box.createVerticalGlue());
        return controls;
    }

    private class Drawing
    extends JLabel {
        Drawing() {
            int space = 50;
            this.setBorder(new EmptyBorder(space, space, space, space));
        }

        protected void paintComponent(Graphics g1) {
            Graphics2D g = (Graphics2D)g1;
            double mid = (double)this.getHeight() / 2.0 - (double)this.getWidth() / 2.0;
            g.translate(50.0, mid);
            Graphics2D boxG = CheckBoxTest.lineGraphics(g, 1.0f);
            if (CheckBoxTest.this.useBox.isSelected()) {
                boxG.draw(CheckBoxTest.this.box);
            } else {
                boxG.draw(CheckBoxTest.this.boxGen.getSide(3));
            }
            if (CheckBoxTest.this.isSelected.isSelected()) {
                Graphics2D checkG = CheckBoxTest.lineGraphics(g, (float)CheckBoxTest.this.widthSpin.get());
                checkG.setColor(Color.green.darker());
                checkG.draw(CheckBoxTest.this.check);
            }
            Graphics2D markG = CheckBoxTest.markGraphics(g);
            CheckBoxTest.mark(markG, CheckBoxTest.this.leftXScaleSpin, CheckBoxTest.this.leftYScaleSpin, true);
            CheckBoxTest.mark(markG, CheckBoxTest.this.midXScaleSpin, CheckBoxTest.this.midYScaleSpin, true);
            CheckBoxTest.mark(markG, CheckBoxTest.this.rightXScaleSpin, CheckBoxTest.this.rightYScaleSpin, true);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            return new Dimension(200, 500);
        }
    }
}

