/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.dev;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.napkinlaf.dev.GeneratorTest;
import net.sourceforge.napkinlaf.dev.RandomValueSpinner;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnQuadLineGenerator;
import net.sourceforge.napkinlaf.util.RandomValue;
import net.sourceforge.napkinlaf.util.RandomValueSource;

class QuadTest
extends GeneratorTest
implements GeneratorTest.Drawer {
    private final DrawnQuadLineGenerator gen = new DrawnQuadLineGenerator();
    private Shape curve;
    private final RandomValueSpinner ctlXSpin = new RandomValueSpinner("x", this.gen.getCtl().getX(), 0.0, 100.0, 100);
    private final RandomValueSpinner ctlYSpin = new RandomValueSpinner("y", this.gen.getCtl().getY(), -20.0, 20.0, 100);
    private final RandomValueSpinner widthSpin;
    private final RandomValueSource[] spinners;
    private JComponent drawing;

    QuadTest() {
        RandomValue w = new RandomValue(1.0, 0.0);
        this.widthSpin = new RandomValueSpinner("w", w, 0.0, 3.0, 20);
        this.spinners = new RandomValueSpinner[]{this.ctlXSpin, this.ctlYSpin, this.widthSpin};
        this.rebuild();
    }

    public Shape generate(AffineTransform matrix) {
        return this.gen.generate(matrix);
    }

    public AbstractDrawnGenerator getGenerator() {
        return this.gen;
    }

    public void rebuild() {
        this.curve = this.generate(null);
    }

    public RandomValueSource[] getSpinners() {
        return this.spinners;
    }

    public String getName() {
        return "Quad";
    }

    public JComponent getDrawing() {
        if (this.drawing == null) {
            this.drawing = new Drawing();
        }
        return this.drawing;
    }

    public JComponent getControls() {
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.setAlignmentY(1.0f);
        controls.add(QuadTest.controlSet("Control", this.ctlXSpin, this.ctlYSpin));
        controls.add(QuadTest.controlSet("Line", this.widthSpin));
        JPanel lineControl = new JPanel();
        lineControl.setBorder(new TitledBorder("Line"));
        lineControl.setLayout(new BoxLayout(lineControl, 0));
        controls.add(Box.createVerticalGlue());
        return controls;
    }

    private class Drawing
    extends JLabel {
        Drawing() {
            this.setBorder(new EmptyBorder(50, 50, 50, 50));
        }

        protected void paintComponent(Graphics g1) {
            Graphics2D g = (Graphics2D)g1;
            double mid = this.getHeight() / 2;
            g.translate(50.0, mid);
            Graphics2D lineG = QuadTest.lineGraphics(g, (float)QuadTest.this.widthSpin.get());
            lineG.draw(QuadTest.this.curve);
            Graphics2D markG = QuadTest.markGraphics(g);
            QuadTest.mark(markG, QuadTest.this.ctlXSpin, QuadTest.this.ctlYSpin, true);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            return new Dimension(200, 500);
        }
    }
}

